/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus.migration;

import java.io.InputStream;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.MigrationStatus;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.graphdb.GraphDBMigrator;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraphDatabase;
import org.apache.atlas.repository.graphdb.janus.migration.AtlasGraphSONReader;
import org.apache.atlas.repository.graphdb.janus.migration.ElementProcessors;
import org.apache.atlas.repository.graphdb.janus.migration.ReaderStatusManager;
import org.apache.atlas.repository.graphdb.janus.migration.TypesDefScrubber;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GraphDBGraphSONMigrator
implements GraphDBMigrator {
    private static final Logger LOG = LoggerFactory.getLogger(GraphDBMigrator.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"GraphDBMigrator");
    private final TypesDefScrubber typesDefStrubberForMigrationImport = new TypesDefScrubber();

    public AtlasTypesDef getScrubbedTypesDef(String jsonStr) {
        AtlasTypesDef typesDef = (AtlasTypesDef)AtlasType.fromJson((String)jsonStr, AtlasTypesDef.class);
        return this.typesDefStrubberForMigrationImport.scrub(typesDef);
    }

    public void importData(AtlasTypeRegistry typeRegistry, InputStream fs) throws AtlasBaseException {
        AtlasPerfTracer perf = null;
        try {
            LOG.info("Starting loadLegacyGraphSON...");
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"loadLegacyGraphSON");
            }
            AtlasGraphSONReader legacyGraphSONReader = AtlasGraphSONReader.build().relationshipCache(new ElementProcessors(typeRegistry, this.typesDefStrubberForMigrationImport)).schemaDB(AtlasJanusGraphDatabase.getGraphInstance()).bulkLoadingDB((Graph)AtlasJanusGraphDatabase.getBulkLoadingGraphInstance()).create();
            legacyGraphSONReader.readGraph(fs);
        }
        catch (Exception ex) {
            try {
                LOG.error("Error loading loadLegacyGraphSON2", (Throwable)ex);
                throw new AtlasBaseException((Throwable)ex);
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                LOG.info("Done! loadLegacyGraphSON.");
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        LOG.info("Done! loadLegacyGraphSON.");
    }

    public MigrationStatus getMigrationStatus() {
        return ReaderStatusManager.get((Graph)AtlasJanusGraphDatabase.getGraphInstance());
    }
}

