/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus.migration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.janus.migration.RelationshipCacheGenerator;
import org.apache.atlas.repository.graphdb.janus.migration.TypesDefScrubber;
import org.apache.atlas.repository.graphdb.janus.migration.TypesWithCollectionsFinder;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementProcessors {
    private static final Logger LOG = LoggerFactory.getLogger(ElementProcessors.class);
    public static final String PRIMITIVE_MAP_CATEGORY = "MAP_PRIMITIVE";
    public static final String NON_PRIMITIVE_MAP_CATEGORY = "MAP";
    public static final String NON_PRIMITIVE_ARRAY_CATEGORY = "ARRAY";
    private static final String[] NON_PRIMITIVE_KEYS = new String[]{"ARRAY"};
    private final Map<String, RelationshipCacheGenerator.TypeInfo> relationshipLookup;
    private final Map<String, Map<String, List<String>>> postProcessMap;
    private final Map<String, TypesDefScrubber.ClassificationToStructDefName> traitToTypeMap;
    private final NonPrimitiveListPropertyProcessor nonPrimitiveListPropertyProcessor = new NonPrimitiveListPropertyProcessor();
    private final NonPrimitiveMapPropertyProcessor nonPrimitiveMapPropertyProcessor = new NonPrimitiveMapPropertyProcessor();
    private final PrimitiveMapPropertyProcessor primitiveMapPropertyProcessor = new PrimitiveMapPropertyProcessor();
    private final EdgeCollectionPropertyProcessor edgeCollectionPropertyProcessor = new EdgeCollectionPropertyProcessor();
    private final EdgeRelationshipPropertyProcessor edgeRelationshipPropertyProcessor = new EdgeRelationshipPropertyProcessor();
    private final EdgeTraitTypesPropertyProcessor edgeTraitTypesPropertyProcessor = new EdgeTraitTypesPropertyProcessor();

    public ElementProcessors(AtlasTypeRegistry typeRegistry, TypesDefScrubber scrubber) {
        this(RelationshipCacheGenerator.get(typeRegistry), TypesWithCollectionsFinder.getVertexPropertiesForCollectionAttributes(typeRegistry), scrubber.getTraitToTypeMap());
    }

    ElementProcessors(Map<String, RelationshipCacheGenerator.TypeInfo> lookup, Map<String, Map<String, List<String>>> postProcessMap, Map<String, TypesDefScrubber.ClassificationToStructDefName> traitToTypeMap) {
        this.relationshipLookup = lookup;
        this.postProcessMap = postProcessMap;
        this.traitToTypeMap = traitToTypeMap;
    }

    public static String[] getNonPrimitiveCategoryKeys() {
        return NON_PRIMITIVE_KEYS;
    }

    public Map<String, Map<String, List<String>>> getPropertiesToPostProcess() {
        return this.postProcessMap;
    }

    public String addIndexKeysForCollections(Vertex out, Object edgeId, String label, Map<String, Object> edgeProperties) {
        return this.edgeCollectionPropertyProcessor.update(out, edgeId, label, edgeProperties);
    }

    public void processCollections(String typeNameKey, Map<String, Object> vertexProperties) {
        if (!vertexProperties.containsKey(typeNameKey)) {
            return;
        }
        String typeName = (String)vertexProperties.get(typeNameKey);
        if (!this.postProcessMap.containsKey(typeName)) {
            return;
        }
        this.primitiveMapPropertyProcessor.update(typeName, vertexProperties);
        this.nonPrimitiveMapPropertyProcessor.update(typeName, vertexProperties);
        this.nonPrimitiveListPropertyProcessor.update(typeName, vertexProperties);
    }

    public String updateEdge(Vertex in, Vertex out, Object edgeId, String label, Map<String, Object> props) {
        return this.edgeRelationshipPropertyProcessor.update(in, out, edgeId, label, props);
    }

    private class EdgeTraitTypesPropertyProcessor {
        private EdgeTraitTypesPropertyProcessor() {
        }

        private void update(String label, Vertex in) {
            if (ElementProcessors.this.traitToTypeMap.size() == 0) {
                return;
            }
            if (!in.property(Constants.ENTITY_TYPE_PROPERTY_KEY).isPresent()) {
                return;
            }
            String typeName = (String)in.property(Constants.ENTITY_TYPE_PROPERTY_KEY).value();
            String key = label;
            if (!ElementProcessors.this.traitToTypeMap.containsKey(key)) {
                key = StringUtils.substringBeforeLast((String)key, (String)".");
                if (!ElementProcessors.this.traitToTypeMap.containsKey(key)) {
                    return;
                }
            }
            if (!((TypesDefScrubber.ClassificationToStructDefName)((Object)ElementProcessors.this.traitToTypeMap.get(key))).getTypeName().equals(typeName)) {
                return;
            }
            in.property(Constants.ENTITY_TYPE_PROPERTY_KEY, (Object)((TypesDefScrubber.ClassificationToStructDefName)((Object)ElementProcessors.this.traitToTypeMap.get(key))).getLegacyTypeName());
        }
    }

    private class NonPrimitiveListPropertyProcessor {
        private final String category = "ARRAY";

        private NonPrimitiveListPropertyProcessor() {
        }

        private void update(String typeName, Map<String, Object> props) {
            if (!((Map)ElementProcessors.this.postProcessMap.get(typeName)).containsKey(ElementProcessors.NON_PRIMITIVE_ARRAY_CATEGORY)) {
                return;
            }
            List propertyTypeList = (List)((Map)ElementProcessors.this.postProcessMap.get(typeName)).get(ElementProcessors.NON_PRIMITIVE_ARRAY_CATEGORY);
            for (String property : propertyTypeList) {
                Map<String, String> listMap;
                if (!props.containsKey(property) || (listMap = this.getUpdatedEdgeList(props.get(property))) == null) continue;
                props.put(property, listMap);
            }
        }

        private Map<String, String> getUpdatedEdgeList(Object o) {
            HashMap<String, String> listMap = new HashMap<String, String>();
            if (!(o instanceof List)) {
                return null;
            }
            List list = (List)o;
            for (int i = 0; i < list.size(); ++i) {
                listMap.put((String)list.get(i), Integer.toString(i));
            }
            return listMap;
        }
    }

    private class NonPrimitiveMapPropertyProcessor {
        final String category = "MAP";

        private NonPrimitiveMapPropertyProcessor() {
        }

        public void update(String typeName, Map<String, Object> vertexProperties) {
            if (!ElementProcessors.this.postProcessMap.containsKey(typeName)) {
                return;
            }
            if (!((Map)ElementProcessors.this.postProcessMap.get(typeName)).containsKey(ElementProcessors.NON_PRIMITIVE_MAP_CATEGORY)) {
                return;
            }
            List propertyTypeList = (List)((Map)ElementProcessors.this.postProcessMap.get(typeName)).get(ElementProcessors.NON_PRIMITIVE_MAP_CATEGORY);
            for (String property : propertyTypeList) {
                List list;
                if (!vertexProperties.containsKey(property) || (list = (List)vertexProperties.get(property)) == null) continue;
                for (Object listEntry : list) {
                    String key = (String)listEntry;
                    String valueKey = this.getMapKey(property, key);
                    if (!vertexProperties.containsKey(valueKey)) continue;
                    vertexProperties.remove(valueKey);
                }
                vertexProperties.remove(property);
            }
        }

        private String getMapKey(String property, String key) {
            return String.format("%s.%s", property, key);
        }
    }

    private class PrimitiveMapPropertyProcessor {
        final String category = "MAP_PRIMITIVE";

        private PrimitiveMapPropertyProcessor() {
        }

        public void update(String typeName, Map<String, Object> vertexProperties) {
            if (!((Map)ElementProcessors.this.postProcessMap.get(typeName)).containsKey(ElementProcessors.PRIMITIVE_MAP_CATEGORY)) {
                return;
            }
            List propertyTypeList = (List)((Map)ElementProcessors.this.postProcessMap.get(typeName)).get(ElementProcessors.PRIMITIVE_MAP_CATEGORY);
            for (String property : propertyTypeList) {
                List list;
                if (!vertexProperties.containsKey(property) || (list = (List)vertexProperties.get(property)) == null) continue;
                Map<String, Object> map = this.getAggregatedMap(vertexProperties, property, list);
                vertexProperties.put(property, map);
            }
        }

        private Map<String, Object> getAggregatedMap(Map<String, Object> vertexProperties, String property, List<Object> list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Object listEntry : list) {
                String key = (String)listEntry;
                String valueKey = this.getMapKey(property, key);
                if (!vertexProperties.containsKey(valueKey)) continue;
                Object value = this.getValueFromProperties(valueKey, vertexProperties);
                vertexProperties.remove(valueKey);
                map.put(key, value);
            }
            return map;
        }

        private String getMapKey(String property, String key) {
            return String.format("%s.%s", property, key);
        }

        private Object getValueFromProperties(String key, Map<String, Object> vertexProperties) {
            if (!vertexProperties.containsKey(key)) {
                return null;
            }
            return vertexProperties.get(key);
        }
    }

    private class EdgeCollectionPropertyProcessor {
        private static final int LABEL_INDEX = 0;
        private static final int KEY_INDEX = 1;

        private EdgeCollectionPropertyProcessor() {
        }

        public String update(Vertex out, Object edgeId, String label, Map<String, Object> edgeProperties) {
            String[] labelKeyPair = this.getNonPrimitiveArrayFromLabel(out, (String)edgeId, label);
            if (labelKeyPair != null) {
                edgeProperties.put(Constants.ATTRIBUTE_INDEX_PROPERTY_KEY, Integer.valueOf(labelKeyPair[1]));
                return label;
            }
            labelKeyPair = this.getNonPrimitiveMapKeyFromLabel(out, label);
            if (labelKeyPair != null) {
                label = labelKeyPair[0];
                edgeProperties.put(Constants.ATTRIBUTE_KEY_PROPERTY_KEY, labelKeyPair[1]);
            }
            return label;
        }

        private String[] getNonPrimitiveArrayFromLabel(Vertex v, String edgeId, String label) {
            String propertyName;
            if (!v.property(Constants.ENTITY_TYPE_PROPERTY_KEY).isPresent()) {
                return null;
            }
            String typeName = (String)v.property(Constants.ENTITY_TYPE_PROPERTY_KEY).value();
            if (!this.containsNonPrimitiveCollectionProperty(typeName, propertyName = StringUtils.remove((String)label, (String)"__"), ElementProcessors.NON_PRIMITIVE_ARRAY_CATEGORY)) {
                return null;
            }
            Map edgeIdIndexList = (Map)v.property(propertyName).value();
            if (edgeIdIndexList.containsKey(edgeId)) {
                return this.getLabelKeyPair(label, (String)edgeIdIndexList.get(edgeId));
            }
            return null;
        }

        private String[] getNonPrimitiveMapKeyFromLabel(Vertex v, String label) {
            if (!v.property(Constants.ENTITY_TYPE_PROPERTY_KEY).isPresent()) {
                return null;
            }
            String typeName = (String)v.property(Constants.ENTITY_TYPE_PROPERTY_KEY).value();
            if (!ElementProcessors.this.postProcessMap.containsKey(typeName)) {
                return null;
            }
            if (!((Map)ElementProcessors.this.postProcessMap.get(typeName)).containsKey(ElementProcessors.NON_PRIMITIVE_MAP_CATEGORY)) {
                return null;
            }
            String propertyName = StringUtils.remove((String)label, (String)"__");
            List properties = (List)((Map)ElementProcessors.this.postProcessMap.get(typeName)).get(ElementProcessors.NON_PRIMITIVE_MAP_CATEGORY);
            for (String p : properties) {
                if (!propertyName.startsWith(p)) continue;
                return this.getLabelKeyPair(String.format("%s%s", "__", p), StringUtils.remove((String)propertyName, (String)p).substring(1).trim());
            }
            return null;
        }

        private boolean containsNonPrimitiveCollectionProperty(String typeName, String propertyName, String categoryType) {
            if (!ElementProcessors.this.postProcessMap.containsKey(typeName)) {
                return false;
            }
            if (!((Map)ElementProcessors.this.postProcessMap.get(typeName)).containsKey(categoryType)) {
                return false;
            }
            List properties = (List)((Map)ElementProcessors.this.postProcessMap.get(typeName)).get(categoryType);
            for (String p : properties) {
                if (!p.equals(propertyName)) continue;
                return true;
            }
            return false;
        }

        private String[] getLabelKeyPair(String label, String value) {
            return new String[]{label, value};
        }
    }

    private class EdgeRelationshipPropertyProcessor {
        private EdgeRelationshipPropertyProcessor() {
        }

        public String update(Vertex in, Vertex out, Object edgeId, String label, Map<String, Object> props) {
            ElementProcessors.this.edgeTraitTypesPropertyProcessor.update(label, in);
            if (this.addRelationshipTypeForClassification(in, out, label, props)) {
                label = "classifiedAs";
            } else {
                this.addRelationshipTypeName(label, props);
                label = ElementProcessors.this.addIndexKeysForCollections(out, edgeId, label, props);
            }
            this.addMandatoryRelationshipProperties(label, props);
            return label;
        }

        private String getRelationshipTypeName(String label) {
            return ElementProcessors.this.relationshipLookup.containsKey(label) ? ((RelationshipCacheGenerator.TypeInfo)((Object)ElementProcessors.this.relationshipLookup.get(label))).getTypeName() : "";
        }

        private AtlasRelationshipDef.PropagateTags getDefaultPropagateValue(String label) {
            return ElementProcessors.this.relationshipLookup.containsKey(label) ? ((RelationshipCacheGenerator.TypeInfo)((Object)ElementProcessors.this.relationshipLookup.get(label))).getPropagateTags() : AtlasRelationshipDef.PropagateTags.NONE;
        }

        private boolean addRelationshipTypeForClassification(Vertex in, Vertex out, String label, Map<String, Object> props) {
            if (in.property(Constants.ENTITY_TYPE_PROPERTY_KEY).isPresent()) {
                String inTypeName = (String)in.property(Constants.ENTITY_TYPE_PROPERTY_KEY).value();
                if (StringUtils.isNotEmpty((String)inTypeName)) {
                    if (inTypeName.equals(label)) {
                        props.put(Constants.ENTITY_TYPE_PROPERTY_KEY, inTypeName);
                        props.put(Constants.CLASSIFICATION_EDGE_NAME_PROPERTY_KEY, inTypeName);
                        this.addEntityGuidToTrait(in, out);
                        return true;
                    }
                } else {
                    LOG.info("Could not find typeName for trait: {}", (Object)label);
                }
            }
            return false;
        }

        private void addEntityGuidToTrait(Vertex in, Vertex out) {
            String entityGuid = "";
            if (out.property(Constants.GUID_PROPERTY_KEY).isPresent()) {
                entityGuid = (String)out.property(Constants.GUID_PROPERTY_KEY).value();
            }
            if (StringUtils.isNotEmpty((String)entityGuid)) {
                in.property(Constants.CLASSIFICATION_ENTITY_GUID, (Object)entityGuid);
                in.property(Constants.CLASSIFICATION_VERTEX_PROPAGATE_KEY, (Object)false);
            }
        }

        private void addRelationshipTypeName(String edgeLabel, Map<String, Object> props) {
            String typeName = this.getRelationshipTypeName(edgeLabel);
            if (StringUtils.isNotEmpty((String)typeName)) {
                props.put(Constants.ENTITY_TYPE_PROPERTY_KEY, typeName);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Could not find relationship type for: {}", (Object)edgeLabel);
            }
        }

        private void addMandatoryRelationshipProperties(String label, Map<String, Object> props) {
            props.put(Constants.RELATIONSHIP_GUID_PROPERTY_KEY, UUID.randomUUID().toString());
            props.put(Constants.RELATIONSHIPTYPE_TAG_PROPAGATION_KEY, String.valueOf(this.getDefaultPropagateValue(label)));
            props.put(Constants.CLASSIFICATION_EDGE_IS_PROPAGATED_PROPERTY_KEY, false);
        }
    }
}

