/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus.migration;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.repository.graphdb.janus.migration.ElementProcessors;
import org.apache.atlas.repository.graphdb.janus.migration.GraphSONUtility;
import org.apache.atlas.repository.graphdb.janus.migration.JsonNodeParsers;
import org.apache.atlas.repository.graphdb.janus.migration.JsonNodeProcessManager;
import org.apache.atlas.repository.graphdb.janus.migration.PostProcessManager;
import org.apache.atlas.repository.graphdb.janus.migration.ReaderStatusManager;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.shaded.jackson.core.JsonFactory;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonToken;
import org.apache.tinkerpop.shaded.jackson.databind.JsonNode;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.janusgraph.core.JanusGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtlasGraphSONReader {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasGraphSONReader.class);
    private static String APPLICATION_PROPERTY_MIGRATION_START_INDEX = "atlas.migration.mode.start.index";
    private static String APPLICATION_PROPERTY_MIGRATION_NUMER_OF_WORKERS = "atlas.migration.mode.workers";
    private static String APPLICATION_PROPERTY_MIGRATION_BATCH_SIZE = "atlas.migration.mode.batch.size";
    private final ObjectMapper mapper;
    private final ElementProcessors relationshipCache;
    private final Graph graph;
    private final Graph bulkLoadGraph;
    private final int numWorkers;
    private final int batchSize;
    private final long suppliedStartIndex;
    private final GraphSONUtility graphSONUtility;
    private ReaderStatusManager readerStatusManager;
    private AtomicLong counter;

    private AtlasGraphSONReader(ObjectMapper mapper, ElementProcessors relationshipLookup, Graph graph, Graph bulkLoadGraph, int numWorkers, int batchSize, long suppliedStartIndex) {
        this.mapper = mapper;
        this.relationshipCache = relationshipLookup;
        this.graph = graph;
        this.bulkLoadGraph = bulkLoadGraph;
        this.numWorkers = numWorkers;
        this.batchSize = batchSize;
        this.suppliedStartIndex = suppliedStartIndex;
        this.graphSONUtility = new GraphSONUtility(this.relationshipCache);
    }

    public void readGraph(InputStream inputStream) throws IOException {
        this.counter = new AtomicLong(0L);
        long startIndex = this.initStatusManager();
        JsonFactory factory = this.mapper.getFactory();
        LOG.info("AtlasGraphSONReader.readGraph: numWorkers: {}: batchSize: {}: startIndex: {}", new Object[]{this.numWorkers, this.batchSize, startIndex});
        try (JsonParser parser = factory.createParser(inputStream);){
            if (parser.nextToken() != JsonToken.START_OBJECT) {
                throw new IOException("Expected data to start with an Object");
            }
            this.readerStatusManager.update(this.bulkLoadGraph, (Long)this.counter.get(), "IN_PROGRESS");
            block24: while (parser.nextToken() != JsonToken.END_OBJECT) {
                String fieldName;
                switch (fieldName = parser.getCurrentName() == null ? "" : parser.getCurrentName()) {
                    case "mode": {
                        parser.nextToken();
                        String mode = parser.getText();
                        if (!mode.equals("EXTENDED")) {
                            throw new IllegalStateException("The legacy GraphSON must be generated with GraphSONMode.EXTENDED");
                        }
                        this.counter.getAndIncrement();
                        continue block24;
                    }
                    case "vertices": {
                        this.processElement(parser, new JsonNodeParsers.ParseVertex(), startIndex);
                        continue block24;
                    }
                    case "edges": {
                        this.processElement(parser, new JsonNodeParsers.ParseEdge(), startIndex);
                        continue block24;
                    }
                    case "vertexCount": {
                        parser.nextToken();
                        LOG.info("Vertex count: {}", (Object)parser.getLongValue());
                        continue block24;
                    }
                    case "edgeCount": {
                        parser.nextToken();
                        LOG.info("Edge count: {}", (Object)parser.getLongValue());
                        continue block24;
                    }
                }
                throw new IllegalStateException(String.format("Unexpected token in GraphSON - %s", fieldName));
            }
            this.postProcess(startIndex);
            this.readerStatusManager.end(this.bulkLoadGraph, this.counter.get(), "SUCCESS");
        }
        catch (Exception ex) {
            this.readerStatusManager.end(this.bulkLoadGraph, this.counter.get(), "FAILED");
            throw new IOException(ex);
        }
        finally {
            LOG.info("AtlasGraphSONReader.readGraph: Done!: {}", (Object)this.counter.get());
        }
    }

    private long initStatusManager() {
        this.readerStatusManager = new ReaderStatusManager(this.graph, this.bulkLoadGraph);
        return this.suppliedStartIndex == 0L ? this.readerStatusManager.getStartIndex() : this.suppliedStartIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processElement(JsonParser parser, JsonNodeParsers.ParseElement parseElement, long startIndex) throws InterruptedException {
        LOG.info("processElement: {}: Starting... : counter at: {}", (Object)parseElement.getMessage(), (Object)this.counter.get());
        try {
            this.readerStatusManager.update(this.graph, (Long)this.counter.get(), true);
            parseElement.setContext(this.graphSONUtility);
            JsonNodeProcessManager.WorkItemManager wim = JsonNodeProcessManager.create(this.graph, this.bulkLoadGraph, parseElement, this.numWorkers, this.batchSize, this.shouldSkip(startIndex, this.counter.get()));
            parser.nextToken();
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                this.handleInterrupt(this.bulkLoadGraph, this.counter.incrementAndGet());
                JsonNode node = (JsonNode)parser.readValueAsTree();
                if (this.shouldSkip(startIndex, this.counter.get()) || parseElement.isTypeNode(node)) continue;
                this.updateStatusConditionally(this.bulkLoadGraph, this.counter.get());
                wim.produce(node);
            }
            wim.shutdown();
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.error("processElement: {}: failed!", (Object)parseElement.getMessage(), (Object)ex);
        }
        finally {
            LOG.info("processElement: {}: Done! : [{}]", (Object)parseElement.getMessage(), (Object)this.counter);
            this.readerStatusManager.update(this.bulkLoadGraph, (Long)this.counter.get(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postProcess(long startIndex) {
        LOG.info("postProcess: Starting... : counter at: {}", (Object)this.counter.get());
        try {
            PostProcessManager.WorkItemsManager wim = PostProcessManager.create(this.bulkLoadGraph, this.relationshipCache.getPropertiesToPostProcess(), this.batchSize, this.numWorkers);
            GraphTraversal query = this.bulkLoadGraph.traversal().V(new Object[0]);
            while (query.hasNext()) {
                this.handleInterrupt(this.bulkLoadGraph, this.counter.incrementAndGet());
                if (this.shouldSkip(startIndex, this.counter.get())) continue;
                Vertex v = (Vertex)query.next();
                wim.produce(v.id());
                this.updateStatusConditionally(this.bulkLoadGraph, this.counter.get());
            }
            wim.shutdown();
        }
        catch (Exception ex) {
            LOG.error("postProcess: failed!", (Throwable)ex);
        }
        finally {
            LOG.info("postProcess: Done! : [{}]", (Object)this.counter.get());
            this.readerStatusManager.update(this.bulkLoadGraph, (Long)this.counter.get(), true);
        }
    }

    private boolean shouldSkip(long startIndex, long index) {
        return startIndex != 0L && index <= startIndex;
    }

    private void handleInterrupt(Graph graph, long counter) throws InterruptedException {
        if (!Thread.interrupted()) {
            return;
        }
        this.readerStatusManager.update(graph, (Long)counter, false);
        LOG.error("Thread interrupted: {}", (Object)counter);
        throw new InterruptedException();
    }

    private void updateStatusConditionally(Graph graph, long counter) {
        if (counter % (long)this.batchSize == 0L) {
            this.readerStatusManager.update(graph, (Long)counter, false);
        }
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder {
        private int batchSize = 500;
        private ElementProcessors relationshipCache;
        private Graph graph;
        private Graph bulkLoadGraph;
        private int numWorkers;
        private long suppliedStartIndex;

        private Builder() {
        }

        private void setDefaults() {
            try {
                this.startIndex(ApplicationProperties.get().getLong(APPLICATION_PROPERTY_MIGRATION_START_INDEX, 0L)).numWorkers(ApplicationProperties.get().getInt(APPLICATION_PROPERTY_MIGRATION_NUMER_OF_WORKERS, 4)).batchSize(ApplicationProperties.get().getInt(APPLICATION_PROPERTY_MIGRATION_BATCH_SIZE, 3000));
            }
            catch (AtlasException ex) {
                LOG.error("setDefaults: failed!", (Throwable)ex);
            }
        }

        public AtlasGraphSONReader create() {
            this.setDefaults();
            if (this.bulkLoadGraph == null) {
                this.bulkLoadGraph = this.graph;
            }
            GraphSONMapper.Builder builder = GraphSONMapper.build();
            GraphSONMapper mapper = builder.create();
            return new AtlasGraphSONReader(mapper.createMapper(), this.relationshipCache, this.graph, this.bulkLoadGraph, this.numWorkers, this.batchSize, this.suppliedStartIndex);
        }

        public Builder relationshipCache(ElementProcessors relationshipCache) {
            this.relationshipCache = relationshipCache;
            return this;
        }

        public Builder schemaDB(JanusGraph graph) {
            this.graph = graph;
            return this;
        }

        public Builder bulkLoadingDB(Graph graph) {
            this.bulkLoadGraph = graph;
            return this;
        }

        public Builder numWorkers(int numWorkers) {
            if (this.bulkLoadGraph == null || this.graph == null) {
                this.numWorkers = 1;
                LOG.info("numWorkers: {}, since one of the 2 graphs is null.", (Object)this.numWorkers);
            } else {
                this.numWorkers = numWorkers;
            }
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder startIndex(long suppliedStartIndex) {
            this.suppliedStartIndex = suppliedStartIndex;
            return this;
        }
    }
}

