/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus.graphson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class AtlasElementPropertyConfig {
    private final List<String> vertexPropertyKeys;
    private final List<String> edgePropertyKeys;
    private final ElementPropertiesRule vertexPropertiesRule;
    private final ElementPropertiesRule edgePropertiesRule;
    private final boolean normalized;
    public static final AtlasElementPropertyConfig ALL_PROPERTIES = new AtlasElementPropertyConfig(null, null, ElementPropertiesRule.INCLUDE, ElementPropertiesRule.INCLUDE, false);

    public AtlasElementPropertyConfig(Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys, ElementPropertiesRule vertexPropertiesRule, ElementPropertiesRule edgePropertiesRule) {
        this(vertexPropertyKeys, edgePropertyKeys, vertexPropertiesRule, edgePropertiesRule, false);
    }

    public AtlasElementPropertyConfig(Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys, ElementPropertiesRule vertexPropertiesRule, ElementPropertiesRule edgePropertiesRule, boolean normalized) {
        this.vertexPropertiesRule = vertexPropertiesRule;
        this.vertexPropertyKeys = AtlasElementPropertyConfig.sortKeys(vertexPropertyKeys, normalized);
        this.edgePropertiesRule = edgePropertiesRule;
        this.edgePropertyKeys = AtlasElementPropertyConfig.sortKeys(edgePropertyKeys, normalized);
        this.normalized = normalized;
    }

    public static AtlasElementPropertyConfig includeProperties(Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys) {
        return new AtlasElementPropertyConfig(vertexPropertyKeys, edgePropertyKeys, ElementPropertiesRule.INCLUDE, ElementPropertiesRule.INCLUDE);
    }

    public static AtlasElementPropertyConfig includeProperties(Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys, boolean normalized) {
        return new AtlasElementPropertyConfig(vertexPropertyKeys, edgePropertyKeys, ElementPropertiesRule.INCLUDE, ElementPropertiesRule.INCLUDE, normalized);
    }

    public static AtlasElementPropertyConfig excludeProperties(Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys) {
        return new AtlasElementPropertyConfig(vertexPropertyKeys, edgePropertyKeys, ElementPropertiesRule.EXCLUDE, ElementPropertiesRule.EXCLUDE);
    }

    public static AtlasElementPropertyConfig excludeProperties(Set<String> vertexPropertyKeys, Set<String> edgePropertyKeys, boolean normalized) {
        return new AtlasElementPropertyConfig(vertexPropertyKeys, edgePropertyKeys, ElementPropertiesRule.EXCLUDE, ElementPropertiesRule.EXCLUDE, normalized);
    }

    public List<String> getVertexPropertyKeys() {
        return this.vertexPropertyKeys;
    }

    public List<String> getEdgePropertyKeys() {
        return this.edgePropertyKeys;
    }

    public ElementPropertiesRule getVertexPropertiesRule() {
        return this.vertexPropertiesRule;
    }

    public ElementPropertiesRule getEdgePropertiesRule() {
        return this.edgePropertiesRule;
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    private static List<String> sortKeys(Set<String> keys, boolean normalized) {
        ArrayList<String> propertyKeyList;
        if (keys != null) {
            if (normalized) {
                ArrayList<String> sorted = new ArrayList<String>(keys);
                Collections.sort(sorted);
                propertyKeyList = sorted;
            } else {
                propertyKeyList = new ArrayList<String>(keys);
            }
        } else {
            propertyKeyList = null;
        }
        return propertyKeyList;
    }

    public static enum ElementPropertiesRule {
        INCLUDE,
        EXCLUDE;

    }
}

