/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.StreamSupport;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasSchemaViolationException;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.graphdb.AtlasVertexQuery;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusEdge;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusElement;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraph;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusObjectFactory;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusVertexQuery;
import org.apache.atlas.repository.graphdb.utils.IteratorToIterableAdapter;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.SchemaViolationException;

public class AtlasJanusVertex
extends AtlasJanusElement<Vertex>
implements AtlasVertex<AtlasJanusVertex, AtlasJanusEdge> {
    public AtlasJanusVertex(AtlasJanusGraph graph, Vertex source) {
        super(graph, source);
    }

    public <T> void addProperty(String propertyName, T value) {
        try {
            ((Vertex)this.getWrappedElement()).property(VertexProperty.Cardinality.set, propertyName, value, new Object[0]);
        }
        catch (SchemaViolationException e) {
            throw new AtlasSchemaViolationException((Throwable)e);
        }
    }

    public <T> void addListProperty(String propertyName, T value) {
        try {
            ((Vertex)this.getWrappedElement()).property(VertexProperty.Cardinality.list, propertyName, value, new Object[0]);
        }
        catch (SchemaViolationException e) {
            throw new AtlasSchemaViolationException((Throwable)e);
        }
    }

    public Iterable<AtlasEdge<AtlasJanusVertex, AtlasJanusEdge>> getEdges(AtlasEdgeDirection dir, String edgeLabel) {
        Direction d = AtlasJanusObjectFactory.createDirection(dir);
        Iterator edges = ((Vertex)this.getWrappedElement()).edges(d, new String[]{edgeLabel});
        return this.graph.wrapEdges(edges);
    }

    public Iterable<AtlasEdge<AtlasJanusVertex, AtlasJanusEdge>> getEdges(AtlasEdgeDirection dir, String[] edgeLabels) {
        Direction direction = AtlasJanusObjectFactory.createDirection(dir);
        Iterator edges = ((Vertex)this.getWrappedElement()).edges(direction, edgeLabels);
        return this.graph.wrapEdges(edges);
    }

    public long getEdgesCount(AtlasEdgeDirection dir, String edgeLabel) {
        Direction direction = AtlasJanusObjectFactory.createDirection(dir);
        Iterator it = ((Vertex)this.getWrappedElement()).edges(direction, new String[]{edgeLabel});
        IteratorToIterableAdapter iterable = new IteratorToIterableAdapter(it);
        return StreamSupport.stream(iterable.spliterator(), true).count();
    }

    public boolean hasEdges(AtlasEdgeDirection dir, String edgeLabel) {
        Direction direction = AtlasJanusObjectFactory.createDirection(dir);
        Iterator edges = ((Vertex)this.getWrappedElement()).edges(direction, new String[]{edgeLabel});
        return edges.hasNext();
    }

    private JanusGraphVertex getAsJanusVertex() {
        return (JanusGraphVertex)this.getWrappedElement();
    }

    public Iterable<AtlasEdge<AtlasJanusVertex, AtlasJanusEdge>> getEdges(AtlasEdgeDirection in) {
        Direction d = AtlasJanusObjectFactory.createDirection(in);
        Iterator edges = ((Vertex)this.getWrappedElement()).edges(d, new String[0]);
        return this.graph.wrapEdges(edges);
    }

    @Override
    public <T> Collection<T> getPropertyValues(String propertyName, Class<T> clazz) {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator it = ((Vertex)this.getWrappedElement()).properties(new String[]{propertyName});
        while (it.hasNext()) {
            result.add(((VertexProperty)it.next()).value());
        }
        return result;
    }

    public AtlasVertexQuery<AtlasJanusVertex, AtlasJanusEdge> query() {
        return new AtlasJanusVertexQuery(this.graph, this.getAsJanusVertex().query());
    }

    public AtlasJanusVertex getV() {
        return this;
    }
}

