/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.repository.graphdb.AtlasCardinality;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasEdgeLabel;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraphIndex;
import org.apache.atlas.repository.graphdb.AtlasGraphManagement;
import org.apache.atlas.repository.graphdb.AtlasPropertyKey;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraph;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusObjectFactory;
import org.apache.atlas.repository.graphdb.janus.GraphDbObjectFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.log.TransactionRecovery;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.JanusGraphSchemaElement;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.PropertyKeyMaker;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.diskstorage.BackendTransaction;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.database.management.GraphIndexStatusReport;
import org.janusgraph.graphdb.database.management.GraphIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.graphdb.log.StandardTransactionLogProcessor;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.MixedIndexType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasJanusGraphManagement
implements AtlasGraphManagement {
    private static final boolean lockEnabled = AtlasConfiguration.STORAGE_CONSISTENCY_LOCK_ENABLED.getBoolean();
    private static final Parameter[] STRING_PARAMETER_ARRAY = new Parameter[]{Mapping.STRING.asParameter()};
    private static final Logger LOG = LoggerFactory.getLogger(AtlasJanusGraphManagement.class);
    private static final char[] RESERVED_CHARS = new char[]{'{', '}', '\"', '$', '\u001e'};
    private AtlasJanusGraph graph;
    private JanusGraphManagement management;
    private Set<String> newMultProperties = new HashSet<String>();

    public AtlasJanusGraphManagement(AtlasJanusGraph graph, JanusGraphManagement managementSystem) {
        this.management = managementSystem;
        this.graph = graph;
    }

    public void createVertexMixedIndex(String indexName, String backingIndex, List<AtlasPropertyKey> propertyKeys) {
        JanusGraphManagement.IndexBuilder indexBuilder = this.management.buildIndex(indexName, Vertex.class);
        for (AtlasPropertyKey key : propertyKeys) {
            PropertyKey janusKey = AtlasJanusObjectFactory.createPropertyKey(key);
            indexBuilder.addKey(janusKey);
        }
        indexBuilder.buildMixedIndex(backingIndex);
    }

    public void createEdgeMixedIndex(String indexName, String backingIndex, List<AtlasPropertyKey> propertyKeys) {
        JanusGraphManagement.IndexBuilder indexBuilder = this.management.buildIndex(indexName, Edge.class);
        for (AtlasPropertyKey key : propertyKeys) {
            PropertyKey janusKey = AtlasJanusObjectFactory.createPropertyKey(key);
            indexBuilder.addKey(janusKey);
        }
        indexBuilder.buildMixedIndex(backingIndex);
    }

    public void createEdgeIndex(String label, String indexName, AtlasEdgeDirection edgeDirection, List<AtlasPropertyKey> propertyKeys) {
        EdgeLabel edgeLabel = this.management.getEdgeLabel(label);
        if (edgeLabel == null) {
            edgeLabel = this.management.makeEdgeLabel(label).make();
        }
        Direction direction = AtlasJanusObjectFactory.createDirection(edgeDirection);
        PropertyKey[] keys = AtlasJanusObjectFactory.createPropertyKeys(propertyKeys);
        if (this.management.getRelationIndex((RelationType)edgeLabel, indexName) == null) {
            this.management.buildEdgeIndex(edgeLabel, indexName, direction, keys);
        }
    }

    public void createFullTextMixedIndex(String indexName, String backingIndex, List<AtlasPropertyKey> propertyKeys) {
        JanusGraphManagement.IndexBuilder indexBuilder = this.management.buildIndex(indexName, Vertex.class);
        for (AtlasPropertyKey key : propertyKeys) {
            PropertyKey janusKey = AtlasJanusObjectFactory.createPropertyKey(key);
            indexBuilder.addKey(janusKey, new Parameter[]{Parameter.of((String)"mapping", (Object)Mapping.TEXT)});
        }
        indexBuilder.buildMixedIndex(backingIndex);
    }

    public boolean containsPropertyKey(String propertyName) {
        return this.management.containsPropertyKey(propertyName);
    }

    public void rollback() {
        this.management.rollback();
    }

    public void commit() {
        this.graph.addMultiProperties(this.newMultProperties);
        this.newMultProperties.clear();
        this.management.commit();
    }

    private static void checkName(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"Need to specify name");
        for (char c : RESERVED_CHARS) {
            Preconditions.checkArgument((name.indexOf(c) < 0 ? 1 : 0) != 0, (String)"Name can not contains reserved character %s: %s", (char)c, (Object)name);
        }
    }

    public AtlasPropertyKey makePropertyKey(String propertyName, Class propertyClass, AtlasCardinality cardinality) {
        if (cardinality.isMany()) {
            this.newMultProperties.add(propertyName);
        }
        PropertyKeyMaker propertyKeyBuilder = this.management.makePropertyKey(propertyName).dataType(propertyClass);
        if (cardinality != null) {
            Cardinality janusCardinality = AtlasJanusObjectFactory.createCardinality(cardinality);
            propertyKeyBuilder.cardinality(janusCardinality);
        }
        PropertyKey propertyKey = propertyKeyBuilder.make();
        return GraphDbObjectFactory.createPropertyKey(propertyKey);
    }

    public AtlasEdgeLabel makeEdgeLabel(String label) {
        EdgeLabel edgeLabel = this.management.makeEdgeLabel(label).make();
        return GraphDbObjectFactory.createEdgeLabel(edgeLabel);
    }

    public void deletePropertyKey(String propertyKey) {
        String deletedKeyName;
        PropertyKey janusPropertyKey = this.management.getPropertyKey(propertyKey);
        if (null == janusPropertyKey) {
            return;
        }
        int i = 0;
        while (true) {
            if (null == this.management.getPropertyKey(deletedKeyName = janusPropertyKey + "_deleted_" + i)) break;
            ++i;
        }
        this.management.changeName((JanusGraphSchemaElement)janusPropertyKey, deletedKeyName);
    }

    public AtlasPropertyKey getPropertyKey(String propertyName) {
        AtlasJanusGraphManagement.checkName(propertyName);
        return GraphDbObjectFactory.createPropertyKey(this.management.getPropertyKey(propertyName));
    }

    public AtlasEdgeLabel getEdgeLabel(String label) {
        return GraphDbObjectFactory.createEdgeLabel(this.management.getEdgeLabel(label));
    }

    public String addMixedIndex(String indexName, AtlasPropertyKey propertyKey, boolean isStringField) {
        PropertyKey janusKey = AtlasJanusObjectFactory.createPropertyKey(propertyKey);
        JanusGraphIndex janusGraphIndex = this.management.getGraphIndex(indexName);
        if (isStringField) {
            this.management.addIndexKey(janusGraphIndex, janusKey, new Parameter[]{Mapping.STRING.asParameter()});
            LOG.debug("created a string type for {} with janueKey {}.", (Object)propertyKey.getName(), (Object)janusKey);
        } else {
            this.management.addIndexKey(janusGraphIndex, janusKey, new Parameter[0]);
            LOG.debug("created a default type for {} with janueKey {}.", (Object)propertyKey.getName(), (Object)janusKey);
        }
        String encodedName = "";
        encodedName = isStringField ? this.graph.getIndexFieldName(propertyKey, janusGraphIndex, STRING_PARAMETER_ARRAY) : this.graph.getIndexFieldName(propertyKey, janusGraphIndex, new Parameter[0]);
        LOG.info("property '{}' is encoded to '{}'.", (Object)propertyKey.getName(), (Object)encodedName);
        return encodedName;
    }

    public String getIndexFieldName(String indexName, AtlasPropertyKey propertyKey, boolean isStringField) {
        JanusGraphIndex janusGraphIndex = this.management.getGraphIndex(indexName);
        if (isStringField) {
            return this.graph.getIndexFieldName(propertyKey, janusGraphIndex, STRING_PARAMETER_ARRAY);
        }
        return this.graph.getIndexFieldName(propertyKey, janusGraphIndex, new Parameter[0]);
    }

    public AtlasGraphIndex getGraphIndex(String indexName) {
        JanusGraphIndex index = this.management.getGraphIndex(indexName);
        return GraphDbObjectFactory.createGraphIndex(index);
    }

    public boolean edgeIndexExist(String label, String indexName) {
        EdgeLabel edgeLabel = this.management.getEdgeLabel(label);
        return edgeLabel != null && this.management.getRelationIndex((RelationType)edgeLabel, indexName) != null;
    }

    public void createVertexCompositeIndex(String propertyName, boolean isUnique, List<AtlasPropertyKey> propertyKeys) {
        this.createCompositeIndex(propertyName, isUnique, propertyKeys, Vertex.class);
    }

    public void createEdgeCompositeIndex(String propertyName, boolean isUnique, List<AtlasPropertyKey> propertyKeys) {
        this.createCompositeIndex(propertyName, isUnique, propertyKeys, Edge.class);
    }

    private void createCompositeIndex(String propertyName, boolean isUnique, List<AtlasPropertyKey> propertyKeys, Class<? extends Element> elementType) {
        JanusGraphManagement.IndexBuilder indexBuilder = this.management.buildIndex(propertyName, elementType);
        for (AtlasPropertyKey key : propertyKeys) {
            PropertyKey janusKey = AtlasJanusObjectFactory.createPropertyKey(key);
            indexBuilder.addKey(janusKey);
        }
        if (isUnique) {
            indexBuilder.unique();
        }
        JanusGraphIndex index = indexBuilder.buildCompositeIndex();
        if (lockEnabled && isUnique) {
            this.management.setConsistency((JanusGraphSchemaElement)index, ConsistencyModifier.LOCK);
        }
    }

    public void updateUniqueIndexesForConsistencyLock() {
        try {
            AtlasJanusGraphManagement.setConsistency(this.management, Vertex.class);
            AtlasJanusGraphManagement.setConsistency(this.management, Edge.class);
        }
        finally {
            this.commit();
        }
    }

    public void updateSchemaStatus() {
        AtlasJanusGraphManagement.updateSchemaStatus(this.management, this.graph.getGraph(), Vertex.class);
        AtlasJanusGraphManagement.updateSchemaStatus(this.management, this.graph.getGraph(), Edge.class);
    }

    public static void updateSchemaStatus(JanusGraphManagement mgmt, JanusGraph graph, Class<? extends Element> elementType) {
        LOG.info("updating SchemaStatus for {}: Starting...", (Object)elementType.getSimpleName());
        int count = 0;
        Iterable iterable = mgmt.getGraphIndexes(elementType);
        for (JanusGraphIndex index : iterable) {
            if (!index.isCompositeIndex()) continue;
            PropertyKey[] propertyKeys = index.getFieldKeys();
            SchemaStatus status = index.getIndexStatus(propertyKeys[0]);
            String indexName = index.name();
            try {
                if (status == SchemaStatus.REGISTERED) {
                    JanusGraphManagement management = graph.openManagement();
                    JanusGraphIndex indexToUpdate = management.getGraphIndex(indexName);
                    management.updateIndex((Index)indexToUpdate, SchemaAction.ENABLE_INDEX).get();
                    management.commit();
                    GraphIndexStatusReport report = ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.ENABLED})).call();
                    if (!report.getConvergedKeys().isEmpty() && report.getConvergedKeys().containsKey(indexName)) {
                        LOG.info("SchemaStatus updated for index: {}, from {} to {}.", new Object[]{index.name(), SchemaStatus.REGISTERED, SchemaStatus.ENABLED});
                        ++count;
                        continue;
                    }
                    if (report.getNotConvergedKeys().isEmpty() || !report.getNotConvergedKeys().containsKey(indexName)) continue;
                    LOG.error("SchemaStatus failed to update index: {}, from {} to {}.", new Object[]{index.name(), SchemaStatus.REGISTERED, SchemaStatus.ENABLED});
                    continue;
                }
                if (status != SchemaStatus.INSTALLED) continue;
                LOG.warn("SchemaStatus {} found for index: {}", (Object)SchemaStatus.INSTALLED, (Object)indexName);
            }
            catch (InterruptedException e) {
                LOG.error("IllegalStateException for indexName : {}, Exception: ", (Object)indexName, (Object)e);
            }
            catch (ExecutionException e) {
                LOG.error("ExecutionException for indexName : {}, Exception: ", (Object)indexName, (Object)e);
            }
        }
        LOG.info("updating SchemaStatus for {}: {}: Done!", (Object)elementType.getSimpleName(), (Object)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setConsistency(JanusGraphManagement mgmt, Class<? extends Element> elementType) {
        LOG.info("setConsistency: {}: Starting...", (Object)elementType.getSimpleName());
        int count = 0;
        try {
            Iterable iterable = mgmt.getGraphIndexes(elementType);
            for (JanusGraphIndex index : iterable) {
                if (!index.isCompositeIndex() || !index.isUnique() || mgmt.getConsistency((JanusGraphSchemaElement)index) == ConsistencyModifier.LOCK) continue;
                for (PropertyKey propertyKey : index.getFieldKeys()) {
                    LOG.info("setConsistency: {}: {}", (Object)count, (Object)propertyKey.name());
                }
                mgmt.setConsistency((JanusGraphSchemaElement)index, ConsistencyModifier.LOCK);
                ++count;
            }
        }
        finally {
            LOG.info("setConsistency: {}: {}: Done!", (Object)elementType.getSimpleName(), (Object)count);
        }
    }

    public void reindex(String indexName, List<AtlasElement> elements) throws Exception {
        try {
            JanusGraphIndex index = this.management.getGraphIndex(indexName);
            if (index == null || !(this.management instanceof ManagementSystem) || !(this.graph.getGraph() instanceof StandardJanusGraph)) {
                LOG.error("Could not retrieve index for name: {} ", (Object)indexName);
                return;
            }
            ManagementSystem managementSystem = (ManagementSystem)this.management;
            IndexType indexType = managementSystem.getSchemaVertex((JanusGraphSchemaElement)index).asIndexType();
            if (!(indexType instanceof MixedIndexType)) {
                LOG.warn("Index: {}: Not of MixedIndexType ", (Object)indexName);
                return;
            }
            IndexSerializer indexSerializer = ((StandardJanusGraph)this.graph.getGraph()).getIndexSerializer();
            this.reindexElement(managementSystem, indexSerializer, (MixedIndexType)indexType, elements);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            this.management.commit();
        }
    }

    public Object startIndexRecovery(long recoveryStartTime) {
        Instant recoveryStartInstant = Instant.ofEpochMilli(recoveryStartTime);
        JanusGraph janusGraph = this.graph.getGraph();
        return JanusGraphFactory.startTransactionRecovery((JanusGraph)janusGraph, (Instant)recoveryStartInstant);
    }

    public void stopIndexRecovery(Object txRecoveryObject) {
        if (txRecoveryObject == null) {
            return;
        }
        try {
            if (txRecoveryObject instanceof TransactionRecovery) {
                TransactionRecovery txRecovery = (TransactionRecovery)txRecoveryObject;
                StandardJanusGraph janusGraph = (StandardJanusGraph)this.graph.getGraph();
                LOG.info("stopIndexRecovery: Index recovery: Paused!");
                janusGraph.getBackend().getSystemTxLog().close();
                txRecovery.shutdown();
            } else {
                LOG.error("stopIndexRecovery({}): Invalid transaction recovery object!", txRecoveryObject);
            }
        }
        catch (Exception e) {
            LOG.warn("stopIndexRecovery: Error while shutting down transaction recovery", (Throwable)e);
        }
    }

    public void printIndexRecoveryStats(Object txRecoveryObject) {
        if (txRecoveryObject == null) {
            return;
        }
        try {
            if (txRecoveryObject instanceof TransactionRecovery) {
                StandardTransactionLogProcessor txRecovery = (StandardTransactionLogProcessor)txRecoveryObject;
                long[] statistics = txRecovery.getStatistics();
                if (statistics.length >= 2) {
                    LOG.info("Index Recovery: Stats: Success:{}: Failed: {}", (Object)statistics[0], (Object)statistics[1]);
                } else {
                    LOG.info("Index Recovery: Stats: {}", (Object)statistics);
                }
            } else {
                LOG.error("Transaction stats: Invalid transaction recovery object!: Unexpected type: {}: Details: {}", (Object)txRecoveryObject.getClass().toString(), txRecoveryObject);
            }
        }
        catch (Exception e) {
            LOG.error("Error: Retrieving log transaction stats!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindexElement(ManagementSystem managementSystem, IndexSerializer indexSerializer, MixedIndexType indexType, List<AtlasElement> elements) throws Exception {
        HashMap documentsPerStore = new HashMap();
        StandardJanusGraphTx tx = managementSystem.getWrappedTx();
        BackendTransaction txHandle = tx.getTxHandle();
        try {
            JanusGraphElement janusGraphElement = null;
            for (AtlasElement element : elements) {
                try {
                    if (element == null || element.getWrappedElement() == null) continue;
                    janusGraphElement = (JanusGraphElement)element.getWrappedElement();
                    indexSerializer.reindexElement(janusGraphElement, indexType, documentsPerStore);
                }
                catch (Exception e) {
                    LOG.warn("{}: Exception: {}:{}", new Object[]{indexType.getName(), e.getClass().getSimpleName(), e.getMessage()});
                }
            }
        }
        finally {
            if (txHandle != null) {
                txHandle.getIndexTransaction(indexType.getBackingIndexName()).restore(documentsPerStore);
            }
        }
    }
}

