/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.AtlasAggregationEntry;
import org.apache.atlas.repository.graphdb.AggregationContext;
import org.apache.atlas.repository.graphdb.AtlasGraphIndexClient;
import org.apache.atlas.repository.graphdb.AtlasGraphManagement;
import org.apache.atlas.repository.graphdb.janus.AtlasSolrQueryBuilder;
import org.apache.atlas.type.AtlasStructType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.V2Request;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.TermsResponse;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.janusgraph.diskstorage.es.ElasticSearch7Index;
import org.janusgraph.diskstorage.es.ElasticSearchClient;
import org.janusgraph.diskstorage.solr.Solr6Index;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasJanusGraphIndexClient
implements AtlasGraphIndexClient {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasJanusGraphIndexClient.class);
    private static final FreqComparator FREQ_COMPARATOR = new FreqComparator();
    private static final int DEFAULT_SUGGESTION_COUNT = 5;
    private static final int MIN_FACET_COUNT_REQUIRED = 1;
    private static final String TERMS_PREFIX = "terms.prefix";
    private static final String TERMS_FIELD = "terms.fl";
    private static final int SOLR_HEALTHY_STATUS = 0;
    private static final long SOLR_STATUS_LOG_FREQUENCY_MS = 60000L;
    private static long prevIdxHealthCheckTime;
    private final Configuration configuration;

    public AtlasJanusGraphIndexClient(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean isHealthy() {
        long currentTime;
        boolean isHealthy;
        block6: {
            isHealthy = false;
            currentTime = System.currentTimeMillis();
            String idxBackEnd = this.configuration.getString("atlas.graph.index.search.backend");
            try {
                if ("solr".equals(idxBackEnd)) {
                    isHealthy = this.isSolrHealthy();
                } else if ("elasticsearch".equals(idxBackEnd)) {
                    isHealthy = this.isElasticsearchHealthy();
                }
                LOG.info("indexBackEnd={}; isHealthy={}", (Object)idxBackEnd, (Object)isHealthy);
            }
            catch (Exception exception) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.error("Error: isHealthy", (Throwable)exception);
            }
        }
        if (!(isHealthy || prevIdxHealthCheckTime != 0L && currentTime - prevIdxHealthCheckTime <= 60000L)) {
            LOG.info("Backend Health: Unhealthy!");
            prevIdxHealthCheckTime = currentTime;
        }
        return isHealthy;
    }

    /*
     * Exception decompiling
     */
    public void applySearchWeight(String collectionName, Map<String, Integer> indexFieldName2SearchWeightMap) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<AtlasAggregationEntry>> getAggregatedMetrics(AggregationContext aggregationContext) {
        SolrClient solrClient = null;
        try {
            List facetFields;
            String indexFieldName;
            solrClient = Solr6Index.getSolrClient();
            if (solrClient == null) {
                LOG.warn("The indexing system is not solr based. Will return empty Aggregation metrics.");
                Map map = Collections.EMPTY_MAP;
                return map;
            }
            Set aggregationCommonFields = aggregationContext.getAggregationFieldNames();
            Set aggregationAttributes = aggregationContext.getAggregationAttributes();
            Map indexFieldNameCache = aggregationContext.getIndexFieldNameCache();
            if (CollectionUtils.isEmpty((Collection)aggregationCommonFields)) {
                LOG.warn("There are no fields provided for aggregation purpose.");
                if (CollectionUtils.isEmpty((Collection)aggregationAttributes)) {
                    LOG.warn("There are no aggregation fields or attributes are provided. Will return empty metrics.");
                    Map map = Collections.EMPTY_MAP;
                    return map;
                }
            }
            if (CollectionUtils.isEmpty((Collection)aggregationAttributes)) {
                LOG.warn("There no attributes provided for aggregation purpose.");
            }
            HashMap<String, String> indexFieldName2PropertyKeyNameMap = new HashMap<String, String>();
            AtlasSolrQueryBuilder solrQueryBuilder = new AtlasSolrQueryBuilder();
            solrQueryBuilder.withEntityTypes(aggregationContext.getSearchForEntityTypes()).withQueryString(aggregationContext.getQueryString()).withCriteria(aggregationContext.getFilterCriteria()).withExcludedDeletedEntities(aggregationContext.isExcludeDeletedEntities()).withIncludeSubTypes(aggregationContext.isIncludeSubTypes()).withCommonIndexFieldNames(indexFieldNameCache);
            SolrQuery solrQuery = new SolrQuery();
            String finalSolrQuery = solrQueryBuilder.build();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Final query string prepared is {}", (Object)finalSolrQuery);
            }
            solrQuery.setQuery(finalSolrQuery);
            solrQuery.setRequestHandler("/freetext");
            if (CollectionUtils.isNotEmpty((Collection)aggregationCommonFields)) {
                for (String propertyName : aggregationCommonFields) {
                    indexFieldName = (String)indexFieldNameCache.get(propertyName);
                    indexFieldName2PropertyKeyNameMap.put(indexFieldName, propertyName);
                    solrQuery.addFacetField(new String[]{indexFieldName});
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)aggregationAttributes)) {
                for (AtlasStructType.AtlasAttribute attribute : aggregationAttributes) {
                    indexFieldName = attribute.getIndexFieldName();
                    indexFieldName2PropertyKeyNameMap.put(indexFieldName, attribute.getQualifiedName());
                    solrQuery.addFacetField(new String[]{indexFieldName});
                }
            }
            solrQuery.setFacetMinCount(1);
            QueryResponse queryResponse = solrClient.query("vertex_index", (SolrParams)solrQuery, SolrRequest.METHOD.POST);
            List list = facetFields = queryResponse == null ? null : queryResponse.getFacetFields();
            if (CollectionUtils.isNotEmpty((Collection)facetFields)) {
                HashMap ret = new HashMap();
                for (FacetField facetField : facetFields) {
                    String indexFieldName2 = facetField.getName();
                    ArrayList<AtlasAggregationEntry> entries = new ArrayList<AtlasAggregationEntry>(facetField.getValueCount());
                    List values = facetField.getValues();
                    for (FacetField.Count count : values) {
                        entries.add(new AtlasAggregationEntry(count.getName(), count.getCount()));
                    }
                    String propertyKeyName = (String)indexFieldName2PropertyKeyNameMap.get(indexFieldName2);
                    ret.put(propertyKeyName, entries);
                }
                HashMap hashMap = ret;
                return hashMap;
            }
        }
        catch (Exception e) {
            LOG.error("Error encountered in getting the aggregation metrics. Will return empty aggregation.", (Throwable)e);
        }
        finally {
            Solr6Index.releaseSolrClient(solrClient);
        }
        return Collections.EMPTY_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applySuggestionFields(String collectionName, List<String> suggestionProperties) {
        SolrClient solrClient = null;
        try {
            solrClient = Solr6Index.getSolrClient();
            if (solrClient == null) {
                LOG.warn("The indexing system is not solr based. Suggestions feature will not be available.");
                return;
            }
            Solr6Index.Mode solrMode = Solr6Index.getSolrMode();
            this.performRequestHandlerAction(collectionName, solrClient, this.generatePayLoadForSuggestions(AtlasJanusGraphIndexClient.generateSuggestionsString(suggestionProperties)), solrMode);
        }
        catch (Throwable t) {
            String msg = String.format("Error encountered in creating the request handler '%s' for collection '%s'", "/terms", collectionName);
            LOG.error(msg, t);
        }
        finally {
            Solr6Index.releaseSolrClient(solrClient);
        }
        LOG.info("Applied\u00a0suggestion fields request handler for collection {}.", (Object)collectionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSuggestions(String prefixString, String indexFieldName) {
        SolrClient solrClient = null;
        try {
            QueryResponse queryResponse;
            TermsResponse termsResponse;
            solrClient = Solr6Index.getSolrClient();
            if (solrClient == null) {
                LOG.warn("The indexing system is not solr based. Suggestions feature will not be available.");
                List list = Collections.EMPTY_LIST;
                return list;
            }
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setRequestHandler("/terms").setParam(TERMS_PREFIX, new String[]{prefixString}).setParam("omitHeader", true);
            if (StringUtils.isNotEmpty((String)indexFieldName)) {
                solrQuery.setParam(TERMS_FIELD, new String[]{indexFieldName});
            }
            TermsResponse termsResponse2 = termsResponse = (queryResponse = solrClient.query("vertex_index", (SolrParams)solrQuery)) == null ? null : queryResponse.getTermsResponse();
            if (termsResponse == null) {
                LOG.info("Received null for terms response. Will return no suggestions.");
                List list = Collections.EMPTY_LIST;
                return list;
            }
            HashMap<String, TermFreq> termsMap = new HashMap<String, TermFreq>();
            for (List fieldTerms : termsResponse.getTermMap().values()) {
                for (TermsResponse.Term fieldTerm : fieldTerms) {
                    TermFreq term = (TermFreq)termsMap.get(fieldTerm.getTerm());
                    if (term == null) {
                        term = new TermFreq(fieldTerm.getTerm(), fieldTerm.getFrequency());
                        termsMap.put(term.getTerm(), term);
                        continue;
                    }
                    term.addFreq(fieldTerm.getFrequency());
                }
            }
            List<String> list = AtlasJanusGraphIndexClient.getTopTerms(termsMap);
            return list;
        }
        catch (IOException | SolrServerException e) {
            String msg = String.format("Error encountered in generating the suggestions. Ignoring the error", e);
            LOG.error(msg);
        }
        finally {
            Solr6Index.releaseSolrClient(solrClient);
        }
        return Collections.EMPTY_LIST;
    }

    private boolean isSolrHealthy() throws SolrServerException, IOException {
        SolrClient client = Solr6Index.getSolrClient();
        return client != null && client.ping("vertex_index").getStatus() == 0;
    }

    private boolean isElasticsearchHealthy() throws IOException {
        ElasticSearchClient client = ElasticSearch7Index.getElasticSearchClient();
        String janusVertexIndex = "janusgraph_vertex_index";
        return client != null && client.indexExists(janusVertexIndex);
    }

    private void graphManagementCommit(AtlasGraphManagement management) {
        try {
            management.commit();
        }
        catch (Exception ex) {
            LOG.warn("Graph transaction management commit failed; attempting rollback: {}", (Throwable)ex);
            this.graphManagementRollback(management);
        }
    }

    private void graphManagementRollback(AtlasGraphManagement management) {
        try {
            management.rollback();
        }
        catch (Exception ex) {
            LOG.warn("Graph transaction management rollback failed: {}", (Throwable)ex);
        }
    }

    @VisibleForTesting
    static List<String> getTopTerms(Map<String, TermFreq> termsMap) {
        ArrayList<String> ret;
        if (MapUtils.isNotEmpty(termsMap)) {
            PriorityQueue<TermFreq> termsQueue = new PriorityQueue<TermFreq>(termsMap.size(), FREQ_COMPARATOR);
            for (TermFreq term : termsMap.values()) {
                termsQueue.add(term);
            }
            ret = new ArrayList<String>(5);
            while (!termsQueue.isEmpty()) {
                ret.add(termsQueue.poll().getTerm());
                if (ret.size() < 5) continue;
                break;
            }
        } else {
            ret = Collections.EMPTY_LIST;
        }
        return ret;
    }

    @VisibleForTesting
    static String generatePayLoadForFreeText(String action, String qfValue) {
        return String.format("{ %s :  {        'name' : '%s',        'class': 'solr.SearchHandler' ,        'defaults': {          'defType': 'edismax' ,           'rows':    100 ,           'lowercaseOperators': true ,           'qf': '%s' ,           'hl.fl': '*' ,           'hl.requireFieldMatch': true ,           'lowercaseOperators': true ,          }    }}", action, "/freetext", qfValue);
    }

    @VisibleForTesting
    String generatePayLoadForSuggestions(String suggestionFieldsString) {
        return String.format("{\n update-requesthandler :  { \n       'name' :    '%s', \n       'class':    'solr.SearchHandler' , \n       'startup':  'lazy' ,\n       'defaults': { \n          'terms':       true , \n          'distrib':     false , \n          'terms.limit': 5 , \n           'terms.fl'  : \n              [\n              %s \n           ] \n         }\n       'components': [ \n           'terms' \n        ] \n    } \n}", "/terms", suggestionFieldsString);
    }

    @VisibleForTesting
    protected static String generateSearchWeightString(Map<String, Integer> indexFieldName2SearchWeightMap) {
        StringBuilder searchWeightBuilder = new StringBuilder();
        for (Map.Entry<String, Integer> entry : indexFieldName2SearchWeightMap.entrySet()) {
            searchWeightBuilder.append(" ").append(entry.getKey()).append("^").append(entry.getValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("generateSearchWeightString(fieldsCount={}): ret={}", (Object)indexFieldName2SearchWeightMap.size(), (Object)searchWeightBuilder.toString());
        }
        return searchWeightBuilder.toString();
    }

    @VisibleForTesting
    protected static String generateSuggestionsString(List<String> suggestionIndexFieldNames) {
        StringBuilder ret = new StringBuilder();
        Iterator<String> iterator = suggestionIndexFieldNames.iterator();
        while (iterator.hasNext()) {
            ret.append("'").append(iterator.next()).append("'");
            if (!iterator.hasNext()) continue;
            ret.append(", ");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("generateSuggestionsString(fieldsCount={}): ret={}", (Object)suggestionIndexFieldNames.size(), (Object)ret.toString());
        }
        return ret.toString();
    }

    private SolrResponse updateFreeTextRequestHandler(SolrClient solrClient, String collectionName, Map<String, Integer> indexFieldName2SearchWeightMap, Solr6Index.Mode mode) throws IOException, SolrServerException, AtlasBaseException {
        String searchWeightString = AtlasJanusGraphIndexClient.generateSearchWeightString(indexFieldName2SearchWeightMap);
        String payLoadString = AtlasJanusGraphIndexClient.generatePayLoadForFreeText("update-requesthandler", searchWeightString);
        return this.performRequestHandlerAction(collectionName, solrClient, payLoadString, mode);
    }

    private SolrResponse createFreeTextRequestHandler(SolrClient solrClient, String collectionName, Map<String, Integer> indexFieldName2SearchWeightMap, Solr6Index.Mode mode) throws IOException, SolrServerException, AtlasBaseException {
        String searchWeightString = AtlasJanusGraphIndexClient.generateSearchWeightString(indexFieldName2SearchWeightMap);
        String payLoadString = AtlasJanusGraphIndexClient.generatePayLoadForFreeText("create-requesthandler", searchWeightString);
        return this.performRequestHandlerAction(collectionName, solrClient, payLoadString, mode);
    }

    private SolrResponse performRequestHandlerAction(String collectionName, SolrClient solrClient, String actionPayLoad, Solr6Index.Mode mode) throws IOException, SolrServerException, AtlasBaseException {
        switch (mode) {
            case CLOUD: {
                V2Request v2request = new V2Request.Builder(String.format("/collections/%s/config", collectionName)).withMethod(SolrRequest.METHOD.POST).withPayload(actionPayLoad).build();
                return this.validateResponseForSuccess(v2request.process(solrClient));
            }
            case HTTP: {
                GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.POST, String.format("/%s/config", collectionName), null);
                RequestWriter.StringPayloadContentWriter contentWriter = new RequestWriter.StringPayloadContentWriter(actionPayLoad, "application/json; charset=UTF-8");
                request.setContentWriter((RequestWriter.ContentWriter)contentWriter);
                request.setUseV2(false);
                return this.validateResponseForSuccess(request.process(solrClient));
            }
        }
        throw new IllegalArgumentException("Unsupported Solr operation mode: " + (Object)((Object)mode));
    }

    private SolrResponse validateResponseForSuccess(SolrResponse solrResponse) throws AtlasBaseException {
        NamedList response;
        if (solrResponse == null) {
            String msg = "Received null response .";
            LOG.error(msg);
            throw new AtlasBaseException(msg);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("V2 Response is {}", (Object)solrResponse.toString());
        }
        if ((response = solrResponse.getResponse()) != null) {
            Object errorMessages = response.get("errorMessages");
            if (errorMessages != null) {
                String msg2;
                LOG.error("Error encountered in performing request handler create/update");
                List errorObjects = (List)errorMessages;
                Map errObject = (Map)errorObjects.get(0);
                List msgs = (List)errObject.get("errorMessages");
                StringBuilder sb = new StringBuilder();
                for (String msg2 : msgs) {
                    sb.append(msg2);
                }
                String errors = sb.toString();
                msg2 = String.format("Error encountered in performing response handler action. %s.", errors);
                LOG.error(msg2);
                throw new AtlasBaseException(msg2);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Successfully performed response handler action. V2 Response is {}", (Object)solrResponse.toString());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Did not receive any response from SOLR.");
        }
        return solrResponse;
    }

    static final class TermFreq {
        private final String term;
        private long freq;

        public TermFreq(String term, long freq) {
            this.term = term;
            this.freq = freq;
        }

        public final String getTerm() {
            return this.term;
        }

        public final long getFreq() {
            return this.freq;
        }

        public final void addFreq(long val) {
            this.freq += val;
        }
    }

    static class FreqComparator
    implements Comparator<TermFreq> {
        FreqComparator() {
        }

        @Override
        public int compare(TermFreq lhs, TermFreq rhs) {
            return Long.compare(rhs.getFreq(), lhs.getFreq());
        }
    }
}

