/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasException;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.GraphDatabase;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusEdge;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraph;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusVertex;
import org.apache.atlas.repository.graphdb.janus.serializer.BigDecimalSerializer;
import org.apache.atlas.repository.graphdb.janus.serializer.BigIntegerSerializer;
import org.apache.atlas.repository.graphdb.janus.serializer.TypeCategorySerializer;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.diskstorage.StandardIndexProvider;
import org.janusgraph.diskstorage.StandardStoreManager;
import org.janusgraph.diskstorage.es.ElasticSearch7Index;
import org.janusgraph.diskstorage.hbase.HBaseStoreManager;
import org.janusgraph.diskstorage.solr.Solr6Index;
import org.janusgraph.graphdb.database.serialize.attribute.SerializableSerializer;
import org.janusgraph.graphdb.tinkerpop.JanusGraphIoRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasJanusGraphDatabase
implements GraphDatabase<AtlasJanusVertex, AtlasJanusEdge> {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasJanusGraphDatabase.class);
    private static final String OLDER_STORAGE_EXCEPTION = "Storage version is incompatible with current client";
    public static final String GRAPH_PREFIX = "atlas.graph";
    public static final String INDEX_BACKEND_CONF = "index.search.backend";
    public static final String SOLR_ZOOKEEPER_URL = "atlas.graph.index.search.solr.zookeeper-url";
    public static final String SOLR_ZOOKEEPER_URLS = "atlas.graph.index.search.solr.zookeeper-urls";
    public static final String INDEX_BACKEND_LUCENE = "lucene";
    public static final String INDEX_BACKEND_ES = "elasticsearch";
    public static final String GRAPH_TX_LOG_CONF = "tx.log-tx";
    public static final String GRAPH_TX_LOG_VERBOSE_CONF = "tx.recovery.verbose";
    public static final String GRAPH_TX_LOG_TTL_CONF = "log.tx.ttl";
    private static volatile AtlasJanusGraph atlasGraphInstance = null;
    private static volatile JanusGraph graphInstance;

    public AtlasJanusGraphDatabase() {
        GraphSONMapper.build().addRegistry((IoRegistry)JanusGraphIoRegistry.instance()).create();
    }

    public static Configuration getConfiguration() throws AtlasException {
        Configuration configProperties = ApplicationProperties.get();
        if (AtlasJanusGraphDatabase.isEmbeddedSolr()) {
            AtlasJanusGraphDatabase.startEmbeddedSolr();
            configProperties.setProperty("atlas.search.freetext.enable", (Object)false);
        }
        configProperties.setProperty(SOLR_ZOOKEEPER_URLS, (Object)configProperties.getStringArray(SOLR_ZOOKEEPER_URL));
        Configuration janusConfig = ApplicationProperties.getSubsetConfiguration((Configuration)configProperties, (String)GRAPH_PREFIX);
        janusConfig.setProperty("attributes.custom.attribute1.attribute-class", (Object)DataTypes.TypeCategory.class.getName());
        janusConfig.setProperty("attributes.custom.attribute1.serializer-class", (Object)TypeCategorySerializer.class.getName());
        janusConfig.setProperty("attributes.custom.attribute2.attribute-class", (Object)ArrayList.class.getName());
        janusConfig.setProperty("attributes.custom.attribute2.serializer-class", (Object)SerializableSerializer.class.getName());
        janusConfig.setProperty("attributes.custom.attribute3.attribute-class", (Object)BigInteger.class.getName());
        janusConfig.setProperty("attributes.custom.attribute3.serializer-class", (Object)BigIntegerSerializer.class.getName());
        janusConfig.setProperty("attributes.custom.attribute4.attribute-class", (Object)BigDecimal.class.getName());
        janusConfig.setProperty("attributes.custom.attribute4.serializer-class", (Object)BigDecimalSerializer.class.getName());
        return janusConfig;
    }

    private static void addHBase2Support() {
        try {
            Field field = StandardStoreManager.class.getDeclaredField("ALL_MANAGER_CLASSES");
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            HashMap<String, String> customMap = new HashMap<String, String>(StandardStoreManager.getAllManagerClasses());
            customMap.put("hbase2", HBaseStoreManager.class.getName());
            ImmutableMap immap = ImmutableMap.copyOf(customMap);
            field.set(null, immap);
            LOG.debug("Injected HBase2 support - {}", (Object)HBaseStoreManager.class.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void addSolr6Index() {
        try {
            Field field = StandardIndexProvider.class.getDeclaredField("ALL_MANAGER_CLASSES");
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            HashMap<String, String> customMap = new HashMap<String, String>(StandardIndexProvider.getAllProviderClasses());
            customMap.put("solr", Solr6Index.class.getName());
            ImmutableMap immap = ImmutableMap.copyOf(customMap);
            field.set(null, immap);
            LOG.debug("Injected solr6 index - {}", (Object)Solr6Index.class.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void addElasticSearch7Index() {
        try {
            Field field = StandardIndexProvider.class.getDeclaredField("ALL_MANAGER_CLASSES");
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            HashMap<String, String> customMap = new HashMap<String, String>(StandardIndexProvider.getAllProviderClasses());
            customMap.put(INDEX_BACKEND_ES, ElasticSearch7Index.class.getName());
            ImmutableMap immap = ImmutableMap.copyOf(customMap);
            field.set(null, immap);
            LOG.debug("Injected es7 index - {}", (Object)ElasticSearch7Index.class.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JanusGraph getGraphInstance() {
        if (graphInstance != null) return graphInstance;
        Class<AtlasJanusGraphDatabase> clazz = AtlasJanusGraphDatabase.class;
        synchronized (AtlasJanusGraphDatabase.class) {
            Configuration config;
            if (graphInstance != null) return graphInstance;
            try {
                config = AtlasJanusGraphDatabase.getConfiguration();
            }
            catch (AtlasException e) {
                throw new RuntimeException(e);
            }
            AtlasJanusGraphDatabase.configureTxLogBasedIndexRecovery();
            graphInstance = AtlasJanusGraphDatabase.initJanusGraph(config);
            atlasGraphInstance = new AtlasJanusGraph();
            AtlasJanusGraphDatabase.validateIndexBackend(config);
            // ** MonitorExit[var0] (shouldn't be in output)
            return graphInstance;
        }
    }

    @VisibleForTesting
    static JanusGraph initJanusGraph(Configuration config) {
        org.apache.commons.configuration2.Configuration conf2 = AtlasJanusGraphDatabase.createConfiguration2(config);
        try {
            return JanusGraphFactory.open((org.apache.commons.configuration2.Configuration)conf2);
        }
        catch (JanusGraphException e) {
            LOG.warn("JanusGraphException: {}", (Object)e.getMessage());
            if (e.getMessage().startsWith(OLDER_STORAGE_EXCEPTION)) {
                LOG.info("Newer client is being used with older janus storage version. Setting allow-upgrade=true and reattempting connection");
                config.addProperty("graph.allow-upgrade", (Object)true);
                return JanusGraphFactory.open((org.apache.commons.configuration2.Configuration)conf2);
            }
            throw new RuntimeException(e);
        }
    }

    public static void configureTxLogBasedIndexRecovery() {
        try {
            final boolean recoveryEnabled = ApplicationProperties.get().getBoolean("atlas.index.recovery.enable", true);
            long ttl = AtlasConfiguration.SOLR_INDEX_TX_LOG_TTL_CONF.getLong();
            final Duration txLogTtlSecs = Duration.ofSeconds(Duration.ofHours(ttl).getSeconds());
            HashMap<String, Object> properties = new HashMap<String, Object>(){
                {
                    this.put(AtlasJanusGraphDatabase.GRAPH_TX_LOG_CONF, recoveryEnabled);
                    this.put(AtlasJanusGraphDatabase.GRAPH_TX_LOG_VERBOSE_CONF, recoveryEnabled);
                    this.put(AtlasJanusGraphDatabase.GRAPH_TX_LOG_TTL_CONF, txLogTtlSecs);
                }
            };
            AtlasJanusGraphDatabase.updateGlobalConfiguration((Map<String, Object>)properties);
            LOG.info("Tx Log-based Index Recovery: {}!", (Object)(recoveryEnabled ? "Enabled" : "Disabled"));
        }
        catch (Exception e) {
            LOG.error("Error: Failed!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateGlobalConfiguration(Map<String, Object> map) {
        JanusGraph graph = null;
        JanusGraphManagement managementSystem = null;
        try {
            graph = AtlasJanusGraphDatabase.initJanusGraph(AtlasJanusGraphDatabase.getConfiguration());
            managementSystem = graph.openManagement();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                managementSystem.set(entry.getKey(), entry.getValue());
            }
            LOG.info("Global properties updated!: {}", map);
        }
        catch (Exception ex) {
            LOG.error("Error updating global configuration: {}", map, (Object)ex);
        }
        finally {
            if (managementSystem != null) {
                managementSystem.commit();
            }
            if (graph != null) {
                graph.close();
            }
        }
    }

    public static JanusGraph getBulkLoadingGraphInstance() {
        try {
            Configuration cfg = AtlasJanusGraphDatabase.getConfiguration();
            cfg.setProperty("storage.batch-loading", (Object)true);
            org.apache.commons.configuration2.Configuration conf2 = AtlasJanusGraphDatabase.createConfiguration2(cfg);
            return JanusGraphFactory.open((org.apache.commons.configuration2.Configuration)conf2);
        }
        catch (IllegalArgumentException ex) {
            LOG.error("getBulkLoadingGraphInstance: Failed!", (Throwable)ex);
        }
        catch (AtlasException ex) {
            LOG.error("getBulkLoadingGraphInstance: Failed!", (Throwable)ex);
        }
        return null;
    }

    private static org.apache.commons.configuration2.Configuration createConfiguration2(Configuration conf) {
        Properties properties = org.apache.commons.configuration.ConfigurationConverter.getProperties((Configuration)conf);
        return ConfigurationConverter.getConfiguration((Properties)properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unload() {
        Class<AtlasJanusGraphDatabase> clazz = AtlasJanusGraphDatabase.class;
        synchronized (AtlasJanusGraphDatabase.class) {
            if (graphInstance == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            graphInstance.tx().commit();
            graphInstance.close();
            graphInstance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static void validateIndexBackend(Configuration config) {
        String configuredIndexBackend = config.getString(INDEX_BACKEND_CONF);
        JanusGraphManagement managementSystem = AtlasJanusGraphDatabase.getGraphInstance().openManagement();
        String currentIndexBackend = managementSystem.get(INDEX_BACKEND_CONF);
        managementSystem.commit();
        if (!configuredIndexBackend.equals(currentIndexBackend)) {
            throw new RuntimeException("Configured Index Backend " + configuredIndexBackend + " differs from earlier configured Index Backend " + currentIndexBackend + ". Aborting!");
        }
    }

    public boolean isGraphLoaded() {
        return graphInstance != null;
    }

    public void initializeTestGraph() {
    }

    public void cleanup() {
        JanusGraph g = AtlasJanusGraphDatabase.getGraphInstance();
        try {
            if (g != null) {
                g.close();
            }
        }
        catch (Throwable t) {
            LOG.warn("Could not close test JanusGraph", t);
            t.printStackTrace();
        }
        try {
            if (g != null) {
                JanusGraphFactory.drop((JanusGraph)g);
            }
        }
        catch (Throwable t) {
            LOG.warn("Could not clear test JanusGraph", t);
            t.printStackTrace();
        }
        if (AtlasJanusGraphDatabase.isEmbeddedSolr()) {
            try {
                AtlasJanusGraphDatabase.stopEmbeddedSolr();
            }
            catch (Throwable t) {
                LOG.warn("Could not stop local solr server", t);
            }
        }
    }

    public AtlasGraph<AtlasJanusVertex, AtlasJanusEdge> getGraph() {
        AtlasJanusGraphDatabase.getGraphInstance();
        return atlasGraphInstance;
    }

    public AtlasGraph<AtlasJanusVertex, AtlasJanusEdge> getGraphBulkLoading() {
        return new AtlasJanusGraph(AtlasJanusGraphDatabase.getBulkLoadingGraphInstance());
    }

    private static void startEmbeddedSolr() throws AtlasException {
        LOG.info("==> startEmbeddedSolr()");
        try {
            Class<?> localSolrRunnerClz = Class.forName("org.apache.atlas.runner.LocalSolrRunner");
            Method startMethod = localSolrRunnerClz.getMethod("start", new Class[0]);
            startMethod.invoke(null, new Object[0]);
        }
        catch (Exception excp) {
            LOG.error("startEmbeddedSolr(): failed", (Throwable)excp);
            throw new AtlasException("startEmbeddedSolr(): failed", (Throwable)excp);
        }
        LOG.info("<== startEmbeddedSolr()");
    }

    private static void stopEmbeddedSolr() throws AtlasException {
        LOG.info("==> stopEmbeddedSolr()");
        try {
            Class<?> localSolrRunnerClz = Class.forName("org.apache.atlas.runner.LocalSolrRunner");
            Method stopMethod = localSolrRunnerClz.getMethod("stop", new Class[0]);
            stopMethod.invoke(null, new Object[0]);
        }
        catch (Exception excp) {
            LOG.error("stopEmbeddedSolr(): failed", (Throwable)excp);
            throw new AtlasException("stopEmbeddedSolr(): failed", (Throwable)excp);
        }
        LOG.info("<== stopEmbeddedSolr()");
    }

    public static boolean isEmbeddedSolr() {
        boolean ret = false;
        try {
            Configuration conf = ApplicationProperties.get();
            Object property = conf.getProperty("atlas.graph.index.search.solr.embedded");
            if (property != null && property instanceof String) {
                ret = Boolean.valueOf((String)property);
            }
        }
        catch (AtlasException atlasException) {
            // empty catch block
        }
        return ret;
    }

    static {
        AtlasJanusGraphDatabase.addHBase2Support();
        AtlasJanusGraphDatabase.addSolr6Index();
        AtlasJanusGraphDatabase.addElasticSearch7Index();
    }
}

