define([ "require", "backbone", "hbs!tmpl/site/DownloadSearchResultLayoutView_tmpl", "utils/Utils", "utils/UrlLinks", "utils/Globals", "collection/VDownloadList" ], function(require, Backbone, DownloadSearchResultLayoutViewTmpl, Utils, UrlLinks, Globals, VDownloadList) {
    "use strict";
    var DownloadSearchResultLayoutView = Backbone.Marionette.LayoutView.extend({
        _viewName: "DownloadSearchResultLayoutView",
        template: DownloadSearchResultLayoutViewTmpl,
        regions: {},
        ui: {
            downloadsPanel: ".downloads-panel",
            closeDownloadsButton: "[data-id='closeDownloads']",
            downloadListContainer: "[data-id='downloadListContainer']",
            downloadTitle: "[data-id='downloadtitle']",
            refreshDownloadsButton: "[data-id='refreshDownloads']",
            loader: "[data-id='downloadListLoader']",
            toggleDownloads: "[data-id='toggleDownloads']"
        },
        events: function() {
            var events = {};
            return events["click " + this.ui.closeDownloadsButton] = "onHideDownloads", events["click " + this.ui.refreshDownloadsButton] = "onRefreshDownloads", 
            events["change " + this.ui.toggleDownloads] = function(e) {
                this.showCompletedDownloads = !this.showCompletedDownloads, this.showCompletedDownloads ? this.ui.toggleDownloads.attr("data-original-title", "Display All Files") : this.ui.toggleDownloads.attr("data-original-title", "Display Available Files"), 
                this.genrateDownloadList();
            }, events;
        },
        initialize: function(options) {
            this.options = options, this.showDownloads = new VDownloadList(), this.showCompletedDownloads = !0, 
            this.downloadsData = [], this.bindEvents();
        },
        bindEvents: function() {
            this.listenTo(this.options.exportVent, "downloads:showDownloads", function() {
                this.onShowDownloads();
            });
        },
        onRender: function() {
            this.ui.toggleDownloads.attr("data-original-title", "Display All Files");
        },
        fetchDownloadsData: function() {
            var that = this, apiObj = {
                success: function(data, response) {
                    that.downloadsData = data.searchDownloadRecords, that.genrateDownloadList();
                },
                complete: function() {
                    that.hideLoader();
                },
                reset: !0
            };
            this.showDownloads.getDownloadsList(apiObj);
        },
        genrateDownloadList: function() {
            var stateIconEl = "", completedDownloads = "", allDownloads = "", downloadList = "", sortedData = _.sortBy(this.downloadsData, function(obj) {
                return obj.createdTime;
            }).reverse();
            sortedData.length ? _.each(sortedData, function(obj) {
                "PENDING" === obj.status ? stateIconEl = "<span class='download-state'><i class='fa fa-refresh fa-spin-custom' aria-hidden='true'></i></span>" : (stateIconEl = "<span class='download-state'><a href=" + UrlLinks.downloadSearchResultsFileUrl(obj.fileName) + "><i class='fa fa-arrow-circle-o-down fa-lg' aria-hidden='true'></i></a></span>", 
                completedDownloads += "<li><i class='fa fa-file-excel-o fa-lg' aria-hidden='true'></i><span class='file-name'>" + obj.fileName + "</span>" + stateIconEl + "</li>"), 
                allDownloads += "<li><i class='fa fa-file-excel-o fa-lg' aria-hidden='true'></i><span class='file-name'>" + obj.fileName + "</span>" + stateIconEl + "</li>";
            }) : completedDownloads = allDownloads = "<li class='text-center' style='border-bottom:none'>No Data Found</li>", 
            this.downloadsData.length && "" === completedDownloads && (completedDownloads = "<li class='text-center' style='border-bottom:none'>No Data Found</li>"), 
            downloadList = this.showCompletedDownloads ? completedDownloads : allDownloads, 
            this.ui.downloadListContainer.empty(), this.ui.downloadListContainer.html(downloadList);
        },
        onRefreshDownloads: function() {
            var that = this;
            Utils.disableRefreshButton(this.ui.refreshDownloadsButton, this), this.showLoader(), 
            that.fetchDownloadsData();
        },
        onShowDownloads: function() {
            this.fetchDownloadsData(), this.showLoader(), this.ui.downloadsPanel.css("right", "20px");
        },
        onHideDownloads: function() {
            this.ui.downloadsPanel.css("right", "-700px");
        },
        showLoader: function() {
            this.$(".downloadListLoader").show();
        },
        hideLoader: function(options) {
            this.$(".downloadListLoader").hide();
        }
    });
    return DownloadSearchResultLayoutView;
});