define([ "require", "hbs!tmpl/graph/PropagationPropertyModalView_tmpl", "models/VRelationship", "models/VEntity", "modules/Modal", "utils/Utils", "utils/UrlLinks", "utils/Messages", "collection/VRelationshipList" ], function(require, PropagationPropertyModalViewTmpl, VRelationship, VEntity, Modal, Utils, UrlLinks, Messages, VRelationshipList) {
    "use strict";
    var PropogationPropertyModal = Backbone.Marionette.LayoutView.extend({
        template: PropagationPropertyModalViewTmpl,
        templateHelpers: function() {},
        regions: {
            RPropagatedClassificationTable: "#r_PropagatedClassificationTable"
        },
        ui: {
            propagationOptions: '[data-id="propagationOptions"]',
            edgeDetailName: '[data-id="edgeDetailName"]',
            propagationState: "[data-id='propagationState']",
            entityClick: "[data-id='entityClick']",
            editPropagationType: 'input[name="editPropagationType"]',
            PropagatedClassificationTable: "[data-id='PropagatedClassificationTable']"
        },
        events: function() {
            var events = {}, that = this;
            return events["change " + this.ui.propagationOptions] = function() {
                this.modalEdited = !0, this.modal.$el.find("button.ok").attr("disabled", !1);
            }, events["click " + this.ui.editPropagationType] = function(e) {
                this.modalEdited === !0 && (e.preventDefault(), that.notifyModal());
            }, events["change " + this.ui.editPropagationType] = function(e) {
                e.target.checked ? (this.showPropagatedClassificationTable(), this.viewType = "table") : (this.showEditPropagation(), 
                this.viewType = "flow");
            }, events["click " + this.ui.entityClick] = function(e) {
                var that = this, url = "", notifyObj = {
                    modal: !0,
                    text: "Are you sure you want to navigate away from this page ?",
                    ok: function(argument) {
                        that.modal.trigger("cancel"), Utils.setUrl({
                            url: url,
                            mergeBrowserUrl: !1,
                            trigger: !0
                        });
                    },
                    cancel: function(argument) {}
                }, $entityName = $(e.currentTarget), url = $entityName.hasClass("entityName") ? "#!/detailPage/" + $entityName[0].dataset.entityguid + "?tabActive=lineage" : "#!/tag/tagAttribute/" + $entityName.data("name");
                Utils.notifyConfirm(notifyObj);
            }, events["change " + this.ui.propagationState] = function(e) {
                this.modalEdited = !0, this.modal.$el.find("button.ok").attr("disabled", !1);
                var $el = $(e.currentTarget), entityguid = $el[0].dataset.entityguid, classificationName = $el[0].dataset.typename, updateClassificationLists = function(fromClassifications, toClassifications) {
                    return _.reject(fromClassifications, function(val, key) {
                        if (val.entityGuid == entityguid && classificationName == val.typeName) return toClassifications.push(val), 
                        !0;
                    });
                };
                e.target.checked ? this.propagatedClassifications = updateClassificationLists(this.propagatedClassifications, this.blockedPropagatedClassifications) : this.blockedPropagatedClassifications = updateClassificationLists(this.blockedPropagatedClassifications, this.propagatedClassifications);
            }, events;
        },
        initialize: function(options) {
            _.extend(this, _.pick(options, "edgeInfo", "relationshipId", "lineageData", "apiGuid", "detailPageFetchCollection")), 
            this.entityModel = new VRelationship(), this.VEntityModel = new VEntity(), this.relationShipCollection = new VRelationshipList(), 
            this.modalEdited = !1, this.viewType = "flow";
            var that = this, modalObj = {
                title: "Classification Propagation Control",
                content: this,
                okText: "Update",
                okCloses: !1,
                cancelText: "Cancel",
                mainClass: "modal-lg",
                allowCancel: !0
            };
            this.commonTableOptions = {
                collection: this.relationShipCollection,
                includeFilter: !1,
                includePagination: !1,
                includeFooterRecords: !1,
                includePageSize: !1,
                includeGotoPage: !1,
                includeAtlasTableSorting: !1,
                gridOpts: {
                    className: "table table-hover backgrid table-quickMenu",
                    emptyText: "No records found!"
                },
                filterOpts: {},
                paginatorOpts: {}
            }, this.modal = new Modal(modalObj), this.modal.open(), this.modal.$el.find("button.ok").attr("disabled", !0), 
            this.on("ok", function() {
                that.updateRelation();
            }), this.on("closeModal", function() {
                this.modal.trigger("cancel");
            }), this.updateEdgeView(this.edgeInfo);
        },
        onRender: function() {},
        renderTableLayoutView: function() {
            var that = this;
            require([ "utils/TableLayout" ], function(TableLayout) {
                var cols = new Backgrid.Columns(that.getSchemaTableColumns());
                that.RPropagatedClassificationTable.show(new TableLayout(_.extend({}, that.commonTableOptions, {
                    columns: cols
                })));
            });
        },
        getSchemaTableColumns: function(options) {
            var that = this;
            return this.relationShipCollection.constructor.getTableCols({
                typeName: {
                    label: "Classification",
                    cell: "html",
                    editable: !1,
                    sortable: !1,
                    formatter: _.extend({}, Backgrid.CellFormatter.prototype, {
                        fromRaw: function(rawValue, model) {
                            return "<a class='classificationName' data-id='entityClick' title='" + rawValue + "' data-name='" + rawValue + "''>" + rawValue + "</a>";
                        }
                    })
                },
                entityGuid: {
                    label: "Entity Name",
                    cell: "html",
                    editable: !1,
                    sortable: !1,
                    formatter: _.extend({}, Backgrid.CellFormatter.prototype, {
                        fromRaw: function(rawValue, model) {
                            var guid = rawValue, entityObj = that.apiGuid[that.relationshipId].referredEntities[guid], name = guid;
                            return entityObj && (name = Utils.getName(entityObj) + " (" + entityObj.typeName + ")"), 
                            "<a class='entityName' data-id='entityClick' data-entityguid =" + guid + ">" + name + "</a>";
                        }
                    })
                },
                fromBlockClassification: {
                    label: "Block Propagation",
                    cell: "html",
                    fixWidth: "150",
                    editable: !1,
                    sortable: !1,
                    formatter: _.extend({}, Backgrid.CellFormatter.prototype, {
                        fromRaw: function(rawValue, model) {
                            return "<div class='text-center'><input type='checkbox' " + (rawValue ? "checked" : "") + " data-entityguid ='" + model.attributes.entityGuid + "' + data-typeName ='" + model.attributes.typeName + "' data-id='propagationState' class='input'></div>";
                        }
                    })
                }
            }, this.relationShipCollection);
        },
        updateEdgeView: function(options) {
            var obj = options, fromEntity = this.lineageData.guidEntityMap[obj.fromEntityId], toEntity = this.lineageData.guidEntityMap[obj.toEntityId];
            fromEntity && toEntity && this.ui.edgeDetailName.html(_.escape(fromEntity.displayText) + " <span class='navigation-font'><i class='fa fa-long-arrow-right fa-color'></i></span> " + _.escape(toEntity.displayText)), 
            obj && obj.relationshipId && (this.showLoader(), this.getEdgeEntity({
                id: obj.relationshipId,
                from: fromEntity,
                to: toEntity
            }));
        },
        getPropagationFlow: function(options) {
            var relationshipData = options.relationshipData, graphData = options.graphData, propagateTags = relationshipData.propagateTags;
            return relationshipData.end1 ? relationshipData.end1.guid == graphData.from.guid || "BOTH" == propagateTags || "NONE" == propagateTags ? propagateTags : "ONE_TO_TWO" == propagateTags ? "TWO_TO_ONE" : "ONE_TO_TWO" : propagateTags;
        },
        getEdgeEntity: function(options) {
            var that = this, id = options.id, from = options.from, to = options.to, enableOtherFlow = function(relationshipObj) {
                var isTwoToOne = !1;
                "BOTH" == relationshipObj.propagateTags ? that.ui.propagationOptions.find(".both").show() : (that.ui.propagationOptions.find(".both").hide(), 
                that.edgeInfo.fromEntityId != relationshipObj.end1.guid && "ONE_TO_TWO" == relationshipObj.propagateTags ? isTwoToOne = !0 : that.edgeInfo.fromEntityId == relationshipObj.end1.guid && "TWO_TO_ONE" == relationshipObj.propagateTags && (isTwoToOne = !0), 
                isTwoToOne ? that.ui.propagationOptions.find(".TWO_TO_ONE").show() : that.ui.propagationOptions.find(".TWO_TO_ONE").hide());
            }, updateValue = function(relationshipData) {
                var relationshipObj = relationshipData.relationship;
                relationshipObj && (that.$("input[name='propagateRelation'][value=" + that.getPropagationFlow({
                    relationshipData: relationshipObj,
                    graphData: options
                }) + "]").prop("checked", !0), enableOtherFlow(relationshipObj), that.showBlockedClassificationTable(relationshipData), 
                that.hideLoader({
                    buttonDisabled: !0
                }));
            };
            this.ui.propagationOptions.find("li label>span.fromName").text(from.typeName), this.ui.propagationOptions.find("li label>span.toName").text(to.typeName), 
            id !== this.ui.propagationOptions.attr("entity-id") && (this.ui.propagationOptions.attr("entity-id", id), 
            this.apiGuid[id] ? updateValue(this.apiGuid[id]) : (this.edgeCall && 4 != this.edgeCall.readyState && this.edgeCall.abort(), 
            this.edgeCall = this.entityModel.getRelationship(id, {
                success: function(relationshipData) {
                    that.apiGuid[relationshipData.relationship.guid] = relationshipData, updateValue(relationshipData);
                },
                cust_error: function() {
                    that.hideLoader();
                }
            })));
        },
        updateRelation: function() {
            var that = this, entityId = that.ui.propagationOptions.attr("entity-id"), PropagationValue = this.$("input[name='propagateRelation']:checked").val(), relationshipProp = {};
            this.ui.propagationOptions.attr("propagation", PropagationValue), relationshipProp = "flow" == this.viewType ? {
                propagateTags: that.getPropagationFlow({
                    relationshipData: _.extend({}, this.apiGuid[entityId].relationship, {
                        propagateTags: PropagationValue
                    }),
                    graphData: {
                        from: {
                            guid: this.edgeInfo.fromEntityId
                        }
                    }
                })
            } : {
                blockedPropagatedClassifications: this.blockedPropagatedClassifications,
                propagatedClassifications: this.propagatedClassifications
            }, this.showLoader(), this.entityModel.saveRelationship({
                data: JSON.stringify(_.extend({}, that.apiGuid[entityId].relationship, relationshipProp)),
                success: function(relationshipData) {
                    relationshipData && (that.hideLoader({
                        buttonDisabled: !0
                    }), that.modal.trigger("cancel"), that.apiGuid[relationshipData.guid] = relationshipData, 
                    that.detailPageFetchCollection(), Utils.notifySuccess({
                        content: "Propagation flow updated succesfully."
                    }));
                },
                cust_error: function() {
                    that.hideLoader();
                }
            });
        },
        showBlockedClassificationTable: function(options) {
            var propagationData = [], relationship = options.relationship, updateClassification = function(classificationList, isChecked) {
                _.each(classificationList, function(val, key) {
                    propagationData.push(_.extend(val, {
                        fromBlockClassification: isChecked
                    }));
                });
            };
            this.blockedPropagatedClassifications = _.clone(relationship.blockedPropagatedClassifications) || [], 
            this.propagatedClassifications = _.clone(relationship.propagatedClassifications) || [], 
            updateClassification(this.blockedPropagatedClassifications, !0), updateClassification(this.propagatedClassifications, !1), 
            this.relationShipCollection.fullCollection.reset(propagationData), this.renderTableLayoutView();
        },
        showLoader: function() {
            this.modal.$el.find("button.ok").showButtonLoader(), this.$(".overlay").removeClass("hide").addClass("show");
        },
        hideLoader: function(options) {
            var buttonDisabled = options && options.buttonDisabled;
            this.modal.$el.find("button.ok").hideButtonLoader(), this.modal.$el.find("button.ok").attr("disabled", !!buttonDisabled && buttonDisabled), 
            this.$(".overlay").removeClass("show").addClass("hide");
        },
        notifyModal: function(options) {
            var that = this, notifyObj = {
                modal: !0,
                text: "It looks like you have edited something. If you leave before saving, your changes will be lost.",
                ok: function(argument) {
                    that.viewType = that.ui.editPropagationType.is(":checked") ? "flow" : "table", that.ui.editPropagationType.prop("checked", "flow" !== that.viewType).trigger("change"), 
                    that.modal.$el.find("button.ok").attr("disabled", !0);
                },
                cancel: function(argument) {
                    that.viewType = that.ui.editPropagationType.is(":checked") ? "table" : "flow";
                }
            };
            Utils.notifyConfirm(notifyObj);
        },
        showEditPropagation: function() {
            this.$(".editPropagation").show(), this.$(".propagatedClassificationTable").hide();
        },
        showPropagatedClassificationTable: function() {
            this.$(".editPropagation").hide(), this.$(".propagatedClassificationTable").show();
        }
    });
    return PropogationPropertyModal;
});