define([ "require", "utils/Globals", "collection/BaseCollection", "models/VDownload", "utils/UrlLinks", "utils/Utils" ], function(require, Globals, BaseCollection, VDownload, UrlLinks, Utils) {
    "use strict";
    var VDownloadLists = BaseCollection.extend({
        url: UrlLinks.downloadBasicSearchResultsCSV(),
        model: VDownload,
        initialize: function() {
            this.modelName = "VDownloads", this.modelAttrName = "generateSearchResultsCSV";
        },
        parseRecords: function(resp, options) {
            try {
                if (!this.modelAttrName) throw new Error("this.modelAttrName not defined for " + this);
                return resp[this.modelAttrName] ? resp[this.modelAttrName] : resp;
            } catch (e) {
                console.log(e);
            }
        },
        getDownloadsList: function(options) {
            var url = UrlLinks.getDownloadsList();
            return options = _.extend({
                contentType: "application/json",
                dataType: "json"
            }, options), this.constructor.nonCrudOperation.call(this, url, "GET", options);
        },
        startDownloading: function(options) {
            var queryParams = Utils.getUrlState.getQueryParams(), url = "basic" === queryParams.searchType ? UrlLinks.downloadBasicSearchResultsCSV() : UrlLinks.downloadAdvanceSearchResultsCSV(), options = _.extend({
                contentType: "application/json",
                dataType: "json"
            }, options);
            return this.constructor.nonCrudOperation.call(this, url, "POST", options);
        }
    }, {
        tableCols: {}
    });
    return VDownloadLists;
});