/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHA256Utils {
    private static final ThreadLocal<MessageDigest> DIGESTER_FACTORY = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    });

    private SHA256Utils() {
    }

    public static MessageDigest getDigester() {
        MessageDigest digester = DIGESTER_FACTORY.get();
        digester.reset();
        return digester;
    }

    public static String toString(byte[] hash) {
        try {
            StringBuilder hexString = new StringBuilder();
            for (int i = 0; i < hash.length; ++i) {
                String hex = Integer.toHexString(0xFF & hash[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

