/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LruCache<K, V>
extends LinkedHashMap<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)LruCache.class.getName());
    private static final long serialVersionUID = 8715233786643882558L;
    private final int evictionWarningThrottle;
    private final int capacity;
    private long evictionsSinceWarning;
    private Date lastEvictionWarning = new Date();

    public LruCache(int cacheSize, int evictionWarningThrottle) {
        super(cacheSize, 0.75f, true);
        this.evictionWarningThrottle = evictionWarningThrottle;
        this.capacity = cacheSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        if (this.size() > this.capacity) {
            this.evictionWarningIfNeeded();
            return true;
        }
        return false;
    }

    private void evictionWarningIfNeeded() {
        if (this.evictionWarningThrottle <= 0) {
            return;
        }
        ++this.evictionsSinceWarning;
        if (this.evictionsSinceWarning >= (long)this.evictionWarningThrottle) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("There have been {} evictions from the cache since {}", (Object)this.evictionsSinceWarning, (Object)dateFormat.format(this.lastEvictionWarning));
            }
            this.evictionsSinceWarning = 0L;
            this.lastEvictionWarning = new Date();
        }
    }
}

