/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtlasPerfTracer {
    private static final long reportingThresholdMs = 0L;
    private final Logger logger;
    private final String tag;
    private final long startTimeMs;

    private AtlasPerfTracer(Logger logger, String tag) {
        this.logger = logger;
        this.tag = tag;
        this.startTimeMs = System.currentTimeMillis();
    }

    public static Logger getPerfLogger(String name) {
        return LoggerFactory.getLogger((String)("org.apache.atlas.perf." + name));
    }

    public static Logger getPerfLogger(Class<?> cls) {
        return AtlasPerfTracer.getPerfLogger(cls.getName());
    }

    public static boolean isPerfTraceEnabled(Logger logger) {
        return logger.isDebugEnabled();
    }

    public static AtlasPerfTracer getPerfTracer(Logger logger, String tag) {
        return new AtlasPerfTracer(logger, tag);
    }

    public static void log(AtlasPerfTracer tracer) {
        if (tracer != null) {
            tracer.log();
        }
    }

    public String getTag() {
        return this.tag;
    }

    public long getStartTime() {
        return this.startTimeMs;
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.startTimeMs;
    }

    public void log() {
        long elapsedTime = this.getElapsedTime();
        if (elapsedTime > 0L) {
            this.logger.debug("PERF|{}|{}", (Object)this.tag, (Object)elapsedTime);
        }
    }
}

