/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.net.URI;
import java.util.Optional;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.utils.HdfsNameServiceResolver;
import org.apache.atlas.utils.PathExtractorContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasPathExtractorUtil {
    public static final char QNAME_SEP_METADATA_NAMESPACE = '@';
    public static final char QNAME_SEP_ENTITY_NAME = '.';
    public static final String SCHEME_SEPARATOR = "://";
    public static final String ATTRIBUTE_QUALIFIED_NAME = "qualifiedName";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_BUCKET = "bucket";
    public static final String HDFS_TYPE_PATH = "hdfs_path";
    public static final String ATTRIBUTE_PATH = "path";
    public static final String ATTRIBUTE_CLUSTER_NAME = "clusterName";
    public static final String ATTRIBUTE_NAMESERVICE_ID = "nameServiceId";
    public static final String AWS_S3_ATLAS_MODEL_VERSION_V2 = "v2";
    public static final String AWS_S3_BUCKET = "aws_s3_bucket";
    public static final String AWS_S3_PSEUDO_DIR = "aws_s3_pseudo_dir";
    public static final String AWS_S3_V2_BUCKET = "aws_s3_v2_bucket";
    public static final String AWS_S3_V2_PSEUDO_DIR = "aws_s3_v2_directory";
    public static final String S3_SCHEME = "s3://";
    public static final String S3A_SCHEME = "s3a://";
    public static final String ATTRIBUTE_CONTAINER = "container";
    public static final String ATTRIBUTE_OBJECT_PREFIX = "objectPrefix";
    public static final String RELATIONSHIP_AWS_S3_BUCKET_S3_PSEUDO_DIRS = "aws_s3_bucket_aws_s3_pseudo_dirs";
    public static final String RELATIONSHIP_AWS_S3_V2_CONTAINER_CONTAINED = "aws_s3_v2_container_contained";
    public static final String ADLS_GEN2_ACCOUNT = "adls_gen2_account";
    public static final String ADLS_GEN2_CONTAINER = "adls_gen2_container";
    public static final String ADLS_GEN2_DIRECTORY = "adls_gen2_directory";
    public static final String ADLS_GEN2_ACCOUNT_HOST_SUFFIX = ".dfs.core.windows.net";
    public static final String ABFS_SCHEME = "abfs://";
    public static final String ABFSS_SCHEME = "abfss://";
    public static final String ATTRIBUTE_ACCOUNT = "account";
    public static final String ATTRIBUTE_PARENT = "parent";
    public static final String RELATIONSHIP_ADLS_GEN2_ACCOUNT_CONTAINERS = "adls_gen2_account_containers";
    public static final String RELATIONSHIP_ADLS_GEN2_PARENT_CHILDREN = "adls_gen2_parent_children";
    public static final String OZONE_VOLUME = "ozone_volume";
    public static final String OZONE_BUCKET = "ozone_bucket";
    public static final String OZONE_KEY = "ozone_key";
    public static final String OZONE_SCHEME = "ofs://";
    public static final String OZONE_3_SCHEME = "o3fs://";
    public static final String ATTRIBUTE_VOLUME = "volume";
    public static final String RELATIONSHIP_OZONE_VOLUME_BUCKET = "ozone_volume_buckets";
    public static final String RELATIONSHIP_OZONE_PARENT_CHILDREN = "ozone_parent_children";
    public static final String OZONE_SCHEME_NAME = "ofs";
    public static final String GCS_SCHEME = "gs://";
    public static final String GCS_BUCKET = "gcp_storage_bucket";
    public static final String GCS_VIRTUAL_DIR = "gcp_storage_virtual_directory";
    public static final String ATTRIBUTE_GCS_PARENT = "parent";
    public static final String RELATIONSHIP_GCS_PARENT_CHILDREN = "gcp_storage_parent_children";
    private static final Logger LOG = LoggerFactory.getLogger(AtlasPathExtractorUtil.class);

    private AtlasPathExtractorUtil() {
    }

    public static AtlasEntity.AtlasEntityWithExtInfo getPathEntity(Path path, PathExtractorContext context) {
        if (StringUtils.isEmpty((CharSequence)path.toString())) {
            throw new IllegalArgumentException("Invalid Input: Path is Null");
        }
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = new AtlasEntity.AtlasEntityWithExtInfo();
        String strPath = path.toString();
        if (context.isConvertPathToLowerCase()) {
            strPath = strPath.toLowerCase();
        }
        AtlasEntity ret = AtlasPathExtractorUtil.isS3Path(strPath) ? (AtlasPathExtractorUtil.isAwsS3AtlasModelVersionV2(context) ? AtlasPathExtractorUtil.addS3PathEntityV2(path, (AtlasEntity.AtlasEntityExtInfo)entityWithExtInfo, context) : AtlasPathExtractorUtil.addS3PathEntityV1(path, (AtlasEntity.AtlasEntityExtInfo)entityWithExtInfo, context)) : (AtlasPathExtractorUtil.isAbfsPath(strPath) ? AtlasPathExtractorUtil.addAbfsPathEntity(path, (AtlasEntity.AtlasEntityExtInfo)entityWithExtInfo, context) : (AtlasPathExtractorUtil.isOzonePath(strPath) ? AtlasPathExtractorUtil.addOzonePathEntity(path, (AtlasEntity.AtlasEntityExtInfo)entityWithExtInfo, context) : (AtlasPathExtractorUtil.isGCSPath(strPath) ? AtlasPathExtractorUtil.addGCSPathEntity(path, (AtlasEntity.AtlasEntityExtInfo)entityWithExtInfo, context) : AtlasPathExtractorUtil.addHDFSPathEntity(path, context))));
        entityWithExtInfo.setEntity(ret);
        return entityWithExtInfo;
    }

    private static boolean isAwsS3AtlasModelVersionV2(PathExtractorContext context) {
        return StringUtils.isNotEmpty((CharSequence)context.getAwsS3AtlasModelVersion()) && StringUtils.equalsIgnoreCase((CharSequence)context.getAwsS3AtlasModelVersion(), (CharSequence)AWS_S3_ATLAS_MODEL_VERSION_V2);
    }

    private static boolean isS3Path(String strPath) {
        return strPath != null && (strPath.startsWith(S3_SCHEME) || strPath.startsWith(S3A_SCHEME));
    }

    private static boolean isAbfsPath(String strPath) {
        return strPath != null && (strPath.startsWith(ABFS_SCHEME) || strPath.startsWith(ABFSS_SCHEME));
    }

    private static boolean isOzonePath(String strPath) {
        return strPath != null && (strPath.startsWith(OZONE_SCHEME) || strPath.startsWith(OZONE_3_SCHEME));
    }

    private static boolean isGCSPath(String strPath) {
        return strPath != null && strPath.startsWith(GCS_SCHEME);
    }

    private static AtlasEntity addS3PathEntityV1(Path path, AtlasEntity.AtlasEntityExtInfo extInfo, PathExtractorContext context) {
        String strPath = path.toString();
        LOG.debug("==> addS3PathEntityV1(strPath={})", (Object)strPath);
        String metadataNamespace = context.getMetadataNamespace();
        String bucketName = path.toUri().getAuthority();
        String bucketQualifiedName = (path.toUri().getScheme() + SCHEME_SEPARATOR + path.toUri().getAuthority() + '@').toLowerCase() + metadataNamespace;
        String pathQualifiedName = (strPath + '@').toLowerCase() + metadataNamespace;
        AtlasEntity bucketEntity = context.getEntity(bucketQualifiedName);
        AtlasEntity ret = context.getEntity(pathQualifiedName);
        if (ret == null) {
            if (bucketEntity == null) {
                bucketEntity = new AtlasEntity(AWS_S3_BUCKET);
                bucketEntity.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)bucketQualifiedName);
                bucketEntity.setAttribute(ATTRIBUTE_NAME, (Object)bucketName);
                context.putEntity(bucketQualifiedName, bucketEntity);
            }
            extInfo.addReferredEntity(bucketEntity);
            ret = new AtlasEntity(AWS_S3_PSEUDO_DIR);
            ret.setRelationshipAttribute(ATTRIBUTE_BUCKET, (Object)AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)bucketEntity, (String)RELATIONSHIP_AWS_S3_BUCKET_S3_PSEUDO_DIRS));
            ret.setAttribute(ATTRIBUTE_OBJECT_PREFIX, (Object)Path.getPathWithoutSchemeAndAuthority((Path)path).toString().toLowerCase());
            ret.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)pathQualifiedName);
            ret.setAttribute(ATTRIBUTE_NAME, (Object)Path.getPathWithoutSchemeAndAuthority((Path)path).toString().toLowerCase());
            context.putEntity(pathQualifiedName, ret);
        }
        LOG.debug("<== addS3PathEntityV1(strPath={})", (Object)strPath);
        return ret;
    }

    private static AtlasEntity addS3PathEntityV2(Path path, AtlasEntity.AtlasEntityExtInfo extInfo, PathExtractorContext context) {
        String strPath = path.toString();
        LOG.debug("==> addS3PathEntityV2(strPath={})", (Object)strPath);
        String metadataNamespace = context.getMetadataNamespace();
        String pathQualifiedName = strPath + '@' + metadataNamespace;
        AtlasEntity ret = context.getEntity(pathQualifiedName);
        if (ret == null) {
            String bucketName = path.toUri().getAuthority();
            String schemeAndBucketName = (path.toUri().getScheme() + SCHEME_SEPARATOR + bucketName).toLowerCase();
            String bucketQualifiedName = schemeAndBucketName + '@' + metadataNamespace;
            AtlasEntity bucketEntity = context.getEntity(bucketQualifiedName);
            if (bucketEntity == null) {
                bucketEntity = new AtlasEntity(AWS_S3_V2_BUCKET);
                bucketEntity.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)bucketQualifiedName);
                bucketEntity.setAttribute(ATTRIBUTE_NAME, (Object)bucketName);
                LOG.debug("adding entity: typeName={}, qualifiedName={}", (Object)bucketEntity.getTypeName(), bucketEntity.getAttribute(ATTRIBUTE_QUALIFIED_NAME));
                context.putEntity(bucketQualifiedName, bucketEntity);
            }
            extInfo.addReferredEntity(bucketEntity);
            AtlasRelatedObjectId parentObjId = AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)bucketEntity, (String)RELATIONSHIP_AWS_S3_V2_CONTAINER_CONTAINED);
            String parentPath = "/";
            String dirPath = path.toUri().getPath();
            if (StringUtils.isEmpty((CharSequence)dirPath)) {
                dirPath = "/";
            }
            for (String subDirName : dirPath.split("/")) {
                if (StringUtils.isEmpty((CharSequence)subDirName)) continue;
                String subDirPath = parentPath + subDirName + "/";
                String subDirQualifiedName = schemeAndBucketName + subDirPath + '@' + metadataNamespace;
                ret = context.getEntity(subDirQualifiedName);
                if (ret == null) {
                    ret = new AtlasEntity(AWS_S3_V2_PSEUDO_DIR);
                    ret.setRelationshipAttribute(ATTRIBUTE_CONTAINER, (Object)parentObjId);
                    ret.setAttribute(ATTRIBUTE_OBJECT_PREFIX, (Object)subDirPath);
                    ret.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)subDirQualifiedName);
                    ret.setAttribute(ATTRIBUTE_NAME, (Object)subDirName);
                    LOG.debug("adding entity: typeName={}, qualifiedName={}", (Object)ret.getTypeName(), ret.getAttribute(ATTRIBUTE_QUALIFIED_NAME));
                    context.putEntity(subDirQualifiedName, ret);
                }
                parentObjId = AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)ret, (String)RELATIONSHIP_AWS_S3_V2_CONTAINER_CONTAINED);
                parentPath = subDirPath;
            }
            if (ret == null) {
                ret = bucketEntity;
            }
        }
        LOG.debug("<== addS3PathEntityV2(strPath={})", (Object)strPath);
        return ret;
    }

    private static AtlasEntity addAbfsPathEntity(Path path, AtlasEntity.AtlasEntityExtInfo extInfo, PathExtractorContext context) {
        String strPath = path.toString();
        LOG.debug("==> addAbfsPathEntity(strPath={})", (Object)strPath);
        String metadataNamespace = context.getMetadataNamespace();
        String pathQualifiedName = strPath + '@' + metadataNamespace;
        AtlasEntity ret = context.getEntity(pathQualifiedName);
        if (ret == null) {
            String abfsScheme = path.toUri().getScheme();
            String storageAcctName = AtlasPathExtractorUtil.getAbfsStorageAccountName(path.toUri());
            String schemeAndStorageAcctName = (abfsScheme + SCHEME_SEPARATOR + storageAcctName).toLowerCase();
            String storageAcctQualifiedName = schemeAndStorageAcctName + '@' + metadataNamespace;
            AtlasEntity storageAcctEntity = context.getEntity(storageAcctQualifiedName);
            if (storageAcctEntity == null) {
                storageAcctEntity = new AtlasEntity(ADLS_GEN2_ACCOUNT);
                storageAcctEntity.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)storageAcctQualifiedName);
                storageAcctEntity.setAttribute(ATTRIBUTE_NAME, (Object)storageAcctName);
                LOG.debug("adding entity: typeName={}, qualifiedName={}", (Object)storageAcctEntity.getTypeName(), storageAcctEntity.getAttribute(ATTRIBUTE_QUALIFIED_NAME));
                context.putEntity(storageAcctQualifiedName, storageAcctEntity);
            }
            extInfo.addReferredEntity(storageAcctEntity);
            AtlasRelatedObjectId storageAcctObjId = AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)storageAcctEntity, (String)RELATIONSHIP_ADLS_GEN2_ACCOUNT_CONTAINERS);
            String containerName = path.toUri().getUserInfo();
            String schemeAndContainerName = (abfsScheme + SCHEME_SEPARATOR + containerName + '@' + storageAcctName).toLowerCase();
            String containerQualifiedName = schemeAndContainerName + '@' + metadataNamespace;
            AtlasEntity containerEntity = context.getEntity(containerQualifiedName);
            if (containerEntity == null) {
                containerEntity = new AtlasEntity(ADLS_GEN2_CONTAINER);
                containerEntity.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)containerQualifiedName);
                containerEntity.setAttribute(ATTRIBUTE_NAME, (Object)containerName);
                containerEntity.setRelationshipAttribute(ATTRIBUTE_ACCOUNT, (Object)storageAcctObjId);
                LOG.debug("adding entity: typeName={}, qualifiedName={}", (Object)containerEntity.getTypeName(), containerEntity.getAttribute(ATTRIBUTE_QUALIFIED_NAME));
                context.putEntity(containerQualifiedName, containerEntity);
            }
            extInfo.addReferredEntity(containerEntity);
            AtlasRelatedObjectId parentObjId = AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)containerEntity, (String)RELATIONSHIP_ADLS_GEN2_PARENT_CHILDREN);
            String parentPath = "/";
            String dirPath = path.toUri().getPath();
            if (StringUtils.isEmpty((CharSequence)dirPath)) {
                dirPath = "/";
            }
            for (String subDirName : dirPath.split("/")) {
                if (StringUtils.isEmpty((CharSequence)subDirName)) continue;
                String subDirPath = parentPath + subDirName;
                String subDirQualifiedName = schemeAndContainerName + subDirPath + '@' + metadataNamespace;
                ret = context.getEntity(subDirQualifiedName);
                if (ret == null) {
                    ret = new AtlasEntity(ADLS_GEN2_DIRECTORY);
                    ret.setRelationshipAttribute("parent", (Object)parentObjId);
                    ret.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)subDirQualifiedName);
                    ret.setAttribute(ATTRIBUTE_NAME, (Object)subDirName);
                    LOG.debug("adding entity: typeName={}, qualifiedName={}", (Object)ret.getTypeName(), ret.getAttribute(ATTRIBUTE_QUALIFIED_NAME));
                    context.putEntity(subDirQualifiedName, ret);
                }
                parentObjId = AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)ret, (String)RELATIONSHIP_ADLS_GEN2_PARENT_CHILDREN);
                parentPath = subDirPath + "/";
            }
            if (ret == null) {
                ret = storageAcctEntity;
            }
        }
        LOG.debug("<== addAbfsPathEntity(strPath={})", (Object)strPath);
        return ret;
    }

    private static String o3fsAuthorityExtractor(String path) {
        return Optional.ofNullable(path).filter(p -> p.startsWith(OZONE_3_SCHEME)).map(p -> p.substring(OZONE_3_SCHEME.length()).split("/", 2)).filter(parts -> ((String[])parts).length > 0).map(parts -> parts[0]).orElse("");
    }

    private static String[] o3fsKeyExtractor(String path) {
        return Optional.ofNullable(path).filter(p -> p.startsWith(OZONE_3_SCHEME)).map(p -> p.substring(OZONE_3_SCHEME.length()).split("/", 2)).filter(parts -> ((String[])parts).length == 2).map(parts -> parts[1].split("/")).orElse(new String[]{""});
    }

    private static int getO3fsPathLength(String path) {
        if (!path.startsWith(OZONE_3_SCHEME)) {
            return 0;
        }
        String o3fsAuthorityWithKeys = path.substring(OZONE_3_SCHEME.length());
        String[] authorityAndKeys = o3fsAuthorityWithKeys.split("/", 2);
        String o3fsAuthority = authorityAndKeys[0];
        String keyPath = authorityAndKeys.length > 1 ? authorityAndKeys[1].trim() : "";
        String[] bucketAndVolume = o3fsAuthority.split("\\.");
        int length = 0;
        if (bucketAndVolume.length >= 1) {
            ++length;
        }
        if (bucketAndVolume.length >= 2) {
            ++length;
        }
        if (!keyPath.isEmpty()) {
            String[] keys = keyPath.split("/");
            length += keys.length;
        }
        return length;
    }

    private static AtlasEntity createOzoneEntity(PathExtractorContext context, String typeName, String name, String qualifiedName, AtlasRelatedObjectId relationship) {
        AtlasEntity ozoneEntity = context.getEntity(qualifiedName);
        if (ozoneEntity == null) {
            ozoneEntity = new AtlasEntity(typeName);
            ozoneEntity.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)qualifiedName);
            ozoneEntity.setAttribute(ATTRIBUTE_NAME, (Object)name);
            if (relationship != null) {
                String relationshipAttribute = typeName.equals(OZONE_BUCKET) ? ATTRIBUTE_VOLUME : "parent";
                ozoneEntity.setRelationshipAttribute(relationshipAttribute, (Object)relationship);
            }
            context.putEntity(qualifiedName, ozoneEntity);
            LOG.info("Added entity: typeName={}, qualifiedName={}", (Object)typeName, (Object)qualifiedName);
        }
        return ozoneEntity;
    }

    private static AtlasEntity addOfsPathEntity(Path path, AtlasEntity.AtlasEntityExtInfo extInfo, PathExtractorContext context) {
        String[] ofsPath;
        String metadataNamespace = context.getMetadataNamespace();
        String ozoneScheme = path.toUri().getScheme();
        String ofsVolumeName = AtlasPathExtractorUtil.getOzoneVolumeName(path);
        String ofsVolumeQualifiedName = OZONE_SCHEME + ofsVolumeName + '@' + metadataNamespace;
        String ofsDirPath = path.toUri().getPath();
        if (StringUtils.isEmpty((CharSequence)ofsDirPath)) {
            ofsDirPath = "/";
        }
        if ((ofsPath = ofsDirPath.split("/")).length < 2) {
            return null;
        }
        AtlasEntity volumeEntity = AtlasPathExtractorUtil.createOzoneEntity(context, OZONE_VOLUME, ofsVolumeName, ofsVolumeQualifiedName, null);
        extInfo.addReferredEntity(volumeEntity);
        if (ofsPath.length == 2) {
            return volumeEntity;
        }
        String ofsBucketName = ofsPath[2];
        String ofsBucketQualifiedName = OZONE_SCHEME + ofsVolumeName + '.' + ofsBucketName + '@' + metadataNamespace;
        AtlasEntity bucketEntity = AtlasPathExtractorUtil.createOzoneEntity(context, OZONE_BUCKET, ofsBucketName, ofsBucketQualifiedName, AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)volumeEntity, (String)RELATIONSHIP_OZONE_VOLUME_BUCKET));
        extInfo.addReferredEntity(bucketEntity);
        if (ofsPath.length == 3) {
            return bucketEntity;
        }
        AtlasEntity currentOfsKeyEntity = null;
        StringBuilder keyPathBuilder = new StringBuilder();
        String keyQNamePrefix = ozoneScheme + SCHEME_SEPARATOR + path.toUri().getAuthority();
        AtlasEntity parentEntityForOfsKey = bucketEntity;
        for (int i = 3; i < ofsPath.length; ++i) {
            String ofsKeyName = ofsPath[i];
            if (StringUtils.isEmpty((CharSequence)ofsKeyName)) continue;
            keyPathBuilder.append("/").append(ofsKeyName);
            String ofsKeyQualifiedName = keyQNamePrefix + "/" + ofsVolumeName + "/" + ofsBucketName + keyPathBuilder + '@' + metadataNamespace;
            parentEntityForOfsKey = currentOfsKeyEntity = AtlasPathExtractorUtil.createOzoneEntity(context, OZONE_KEY, ofsKeyName, ofsKeyQualifiedName, AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)parentEntityForOfsKey, (String)RELATIONSHIP_OZONE_PARENT_CHILDREN));
            AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)parentEntityForOfsKey, (String)RELATIONSHIP_OZONE_PARENT_CHILDREN);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== addOzonePathEntity(strPath={})", (Object)path.toString());
        }
        return currentOfsKeyEntity;
    }

    private static AtlasEntity addO3fsPathEntity(Path path, AtlasEntity.AtlasEntityExtInfo extInfo, PathExtractorContext context) {
        String[] o3fsKeys = AtlasPathExtractorUtil.o3fsKeyExtractor(path.toString());
        int o3fsPathLength = AtlasPathExtractorUtil.getO3fsPathLength(path.toString());
        String metadataNamespace = context.getMetadataNamespace();
        String ozoneScheme = path.toUri().getScheme();
        String o3fsBucketName = AtlasPathExtractorUtil.getOzoneBucketName(path);
        String o3fsVolumeName = AtlasPathExtractorUtil.getOzoneVolumeName(path);
        String o3fsVolumeQualifiedName = ozoneScheme + SCHEME_SEPARATOR + o3fsVolumeName + '@' + metadataNamespace;
        AtlasEntity volumeEntity = AtlasPathExtractorUtil.createOzoneEntity(context, OZONE_VOLUME, o3fsVolumeName, o3fsVolumeQualifiedName, null);
        extInfo.addReferredEntity(volumeEntity);
        String bucketQualifiedName = ozoneScheme + SCHEME_SEPARATOR + o3fsVolumeName + '.' + o3fsBucketName + '@' + metadataNamespace;
        AtlasEntity bucketEntity = AtlasPathExtractorUtil.createOzoneEntity(context, OZONE_BUCKET, o3fsBucketName, bucketQualifiedName, AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)volumeEntity, (String)RELATIONSHIP_OZONE_VOLUME_BUCKET));
        extInfo.addReferredEntity(bucketEntity);
        if (o3fsPathLength < 1) {
            return null;
        }
        if (o3fsPathLength == 1) {
            return volumeEntity;
        }
        if (o3fsPathLength == 2) {
            return bucketEntity;
        }
        AtlasEntity currentO3fsKeyEntity = null;
        AtlasEntity parentEntityForO3fsKey = bucketEntity;
        StringBuilder keyPathBuilder = new StringBuilder();
        String authority = AtlasPathExtractorUtil.o3fsAuthorityExtractor(path.toString());
        for (String o3fsKeyName : o3fsKeys) {
            keyPathBuilder.append("/").append(o3fsKeyName);
            String o3fsKeyQualifiedName = ozoneScheme + SCHEME_SEPARATOR + authority + keyPathBuilder + '@' + metadataNamespace;
            parentEntityForO3fsKey = currentO3fsKeyEntity = AtlasPathExtractorUtil.createOzoneEntity(context, OZONE_KEY, o3fsKeyName, o3fsKeyQualifiedName, AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)parentEntityForO3fsKey, (String)RELATIONSHIP_OZONE_PARENT_CHILDREN));
            AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)parentEntityForO3fsKey, (String)RELATIONSHIP_OZONE_PARENT_CHILDREN);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== addOzonePathEntity(strPath={})", (Object)path.toString());
        }
        return currentO3fsKeyEntity;
    }

    private static AtlasEntity addOzonePathEntity(Path path, AtlasEntity.AtlasEntityExtInfo extInfo, PathExtractorContext context) {
        String strPath = path.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> addOzonePathEntity(strPath={})", (Object)strPath);
        }
        return strPath.startsWith(OZONE_3_SCHEME) ? AtlasPathExtractorUtil.addO3fsPathEntity(path, extInfo, context) : AtlasPathExtractorUtil.addOfsPathEntity(path, extInfo, context);
    }

    private static AtlasEntity addGCSPathEntity(Path path, AtlasEntity.AtlasEntityExtInfo extInfo, PathExtractorContext context) {
        String strPath = path.toString();
        LOG.debug("==> addGCSPathEntity(strPath={})", (Object)strPath);
        String metadataNamespace = context.getMetadataNamespace();
        String pathQualifiedName = strPath + '@' + metadataNamespace;
        AtlasEntity ret = context.getEntity(pathQualifiedName);
        if (ret == null) {
            String bucketName = path.toUri().getAuthority();
            String schemeAndBucketName = (path.toUri().getScheme() + SCHEME_SEPARATOR + bucketName).toLowerCase();
            String bucketQualifiedName = schemeAndBucketName + '@' + metadataNamespace;
            AtlasEntity bucketEntity = context.getEntity(bucketQualifiedName);
            if (bucketEntity == null) {
                bucketEntity = new AtlasEntity(GCS_BUCKET);
                bucketEntity.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)bucketQualifiedName);
                bucketEntity.setAttribute(ATTRIBUTE_NAME, (Object)bucketName);
                LOG.debug("adding entity: typeName={}, qualifiedName={}", (Object)bucketEntity.getTypeName(), bucketEntity.getAttribute(ATTRIBUTE_QUALIFIED_NAME));
                context.putEntity(bucketQualifiedName, bucketEntity);
            }
            extInfo.addReferredEntity(bucketEntity);
            AtlasRelatedObjectId parentObjId = AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)bucketEntity, (String)RELATIONSHIP_GCS_PARENT_CHILDREN);
            String parentPath = "/";
            String dirPath = path.toUri().getPath();
            if (StringUtils.isEmpty((CharSequence)dirPath)) {
                dirPath = "/";
            }
            for (String subDirName : dirPath.split("/")) {
                if (StringUtils.isEmpty((CharSequence)subDirName)) continue;
                String subDirPath = parentPath + subDirName + "/";
                String subDirQualifiedName = schemeAndBucketName + subDirPath + '@' + metadataNamespace;
                ret = context.getEntity(subDirQualifiedName);
                if (ret == null) {
                    ret = new AtlasEntity(GCS_VIRTUAL_DIR);
                    ret.setRelationshipAttribute("parent", (Object)parentObjId);
                    ret.setAttribute(ATTRIBUTE_OBJECT_PREFIX, (Object)parentPath);
                    ret.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)subDirQualifiedName);
                    ret.setAttribute(ATTRIBUTE_NAME, (Object)subDirName);
                    LOG.debug("adding entity: typeName={}, qualifiedName={}", (Object)ret.getTypeName(), ret.getAttribute(ATTRIBUTE_QUALIFIED_NAME));
                    context.putEntity(subDirQualifiedName, ret);
                }
                parentObjId = AtlasTypeUtil.getAtlasRelatedObjectId((AtlasEntity)ret, (String)RELATIONSHIP_GCS_PARENT_CHILDREN);
                parentPath = subDirPath;
            }
            if (ret == null) {
                ret = bucketEntity;
            }
        }
        LOG.debug("<== addGCSPathEntity(strPath={})", (Object)strPath);
        return ret;
    }

    private static AtlasEntity addHDFSPathEntity(Path path, PathExtractorContext context) {
        String strPath = path.toString();
        if (context.isConvertPathToLowerCase()) {
            strPath = strPath.toLowerCase();
        }
        LOG.debug("==> addHDFSPathEntity(strPath={})", (Object)strPath);
        String nameServiceID = HdfsNameServiceResolver.getNameServiceIDForPath(strPath);
        String attrPath = StringUtils.isEmpty((CharSequence)nameServiceID) ? strPath : HdfsNameServiceResolver.getPathWithNameServiceID(strPath);
        String pathQualifiedName = AtlasPathExtractorUtil.getQualifiedName(attrPath, context.getMetadataNamespace());
        AtlasEntity ret = context.getEntity(pathQualifiedName);
        if (ret == null) {
            ret = new AtlasEntity(HDFS_TYPE_PATH);
            if (StringUtils.isNotEmpty((CharSequence)nameServiceID)) {
                ret.setAttribute(ATTRIBUTE_NAMESERVICE_ID, (Object)nameServiceID);
            }
            String name = Path.getPathWithoutSchemeAndAuthority((Path)path).toString();
            if (context.isConvertPathToLowerCase()) {
                name = name.toLowerCase();
            }
            ret.setAttribute(ATTRIBUTE_PATH, (Object)attrPath);
            ret.setAttribute(ATTRIBUTE_QUALIFIED_NAME, (Object)pathQualifiedName);
            ret.setAttribute(ATTRIBUTE_NAME, (Object)name);
            ret.setAttribute(ATTRIBUTE_CLUSTER_NAME, (Object)context.getMetadataNamespace());
            context.putEntity(pathQualifiedName, ret);
        }
        LOG.debug("<== addHDFSPathEntity(strPath={})", (Object)strPath);
        return ret;
    }

    private static String getAbfsStorageAccountName(URI uri) {
        String ret = null;
        String host = uri.getHost();
        if (StringUtils.isNotEmpty((CharSequence)host) && host.contains(ADLS_GEN2_ACCOUNT_HOST_SUFFIX)) {
            ret = host.substring(0, host.indexOf(ADLS_GEN2_ACCOUNT_HOST_SUFFIX));
        }
        return ret;
    }

    private static String getOzoneVolumeName(Path path) {
        String strPath = path.toString();
        String volumeName = "";
        if (strPath.startsWith(OZONE_3_SCHEME)) {
            String pathAuthority = path.toUri().getAuthority();
            volumeName = pathAuthority.split("\\.")[1];
        } else if (strPath.startsWith(OZONE_SCHEME) && (strPath = strPath.replaceAll(OZONE_SCHEME, "")).split("/").length >= 2) {
            volumeName = strPath.split("/")[1];
        }
        return volumeName;
    }

    private static String getOzoneBucketName(Path path) {
        String strPath = path.toString();
        String bucketName = "";
        if (strPath.startsWith(OZONE_3_SCHEME)) {
            String pathAuthority = path.toUri().getAuthority();
            bucketName = pathAuthority.split("\\.")[0];
        } else if (strPath.startsWith(OZONE_SCHEME) && (strPath = strPath.replaceAll(OZONE_SCHEME, "")).split("/").length >= 3) {
            bucketName = strPath.split("/")[2];
        }
        return bucketName;
    }

    private static String getQualifiedName(String path, String metadataNamespace) {
        if (path.startsWith("hdfs://")) {
            return path + '@' + metadataNamespace;
        }
        return path.toLowerCase();
    }
}

