/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.groovy;

import java.util.Collections;
import java.util.List;
import org.apache.atlas.groovy.AbstractGroovyExpression;
import org.apache.atlas.groovy.GroovyExpression;
import org.apache.atlas.groovy.GroovyGenerationContext;

public class VariableAssignmentExpression
extends AbstractGroovyExpression {
    private final String type;
    private final String name;
    private final GroovyExpression value;

    public VariableAssignmentExpression(String type, String name, GroovyExpression v) {
        this.type = type;
        this.name = name;
        this.value = v;
    }

    public VariableAssignmentExpression(String name, GroovyExpression v) {
        this(null, name, v);
    }

    @Override
    public void generateGroovy(GroovyGenerationContext context) {
        if (this.type == null) {
            context.append("def ");
        } else {
            context.append(this.type);
            context.append(" ");
        }
        context.append(this.name);
        context.append("=");
        this.value.generateGroovy(context);
    }

    @Override
    public List<GroovyExpression> getChildren() {
        return Collections.singletonList(this.value);
    }

    @Override
    public GroovyExpression copy(List<GroovyExpression> newChildren) {
        return new VariableAssignmentExpression(this.name, newChildren.get(0));
    }
}

