/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.groovy;

import java.util.Arrays;
import java.util.List;
import org.apache.atlas.groovy.AbstractGroovyExpression;
import org.apache.atlas.groovy.GroovyExpression;
import org.apache.atlas.groovy.GroovyGenerationContext;
import org.apache.atlas.groovy.TraversalStepType;

public class TernaryOperatorExpression
extends AbstractGroovyExpression {
    private final GroovyExpression booleanExpr;
    private final GroovyExpression trueValue;
    private final GroovyExpression falseValue;

    public TernaryOperatorExpression(GroovyExpression booleanExpr, GroovyExpression trueValue, GroovyExpression falseValue) {
        this.booleanExpr = booleanExpr;
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }

    @Override
    public void generateGroovy(GroovyGenerationContext context) {
        context.append("((");
        this.booleanExpr.generateGroovy(context);
        context.append(")?(");
        this.trueValue.generateGroovy(context);
        context.append("):(");
        this.falseValue.generateGroovy(context);
        context.append("))");
    }

    @Override
    public List<GroovyExpression> getChildren() {
        return Arrays.asList(this.booleanExpr, this.trueValue, this.falseValue);
    }

    @Override
    public GroovyExpression copy(List<GroovyExpression> newChildren) {
        return new TernaryOperatorExpression(newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    public String toString() {
        GroovyGenerationContext context = new GroovyGenerationContext();
        this.generateGroovy(context);
        return context.getQuery();
    }

    @Override
    public TraversalStepType getType() {
        return this.trueValue.getType();
    }
}

