/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.groovy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.atlas.groovy.AbstractGroovyExpression;
import org.apache.atlas.groovy.GroovyExpression;
import org.apache.atlas.groovy.GroovyGenerationContext;
import org.apache.atlas.groovy.TraversalStepType;

public class StatementListExpression
extends AbstractGroovyExpression {
    private final List<GroovyExpression> stmts = new ArrayList<GroovyExpression>();

    public StatementListExpression() {
    }

    public StatementListExpression(List<GroovyExpression> newChildren) {
        this.stmts.addAll(newChildren);
    }

    public void addStatement(GroovyExpression expr) {
        if (expr instanceof StatementListExpression) {
            this.stmts.addAll(((StatementListExpression)expr).getStatements());
        } else {
            this.stmts.add(expr);
        }
    }

    public void addStatements(List<GroovyExpression> exprs) {
        for (GroovyExpression expr : exprs) {
            this.addStatement(expr);
        }
    }

    @Override
    public void generateGroovy(GroovyGenerationContext context) {
        Iterator<GroovyExpression> stmtIt = this.stmts.iterator();
        while (stmtIt.hasNext()) {
            GroovyExpression stmt = stmtIt.next();
            stmt.generateGroovy(context);
            if (!stmtIt.hasNext()) continue;
            context.append(";");
        }
    }

    @Override
    public List<GroovyExpression> getChildren() {
        return Collections.unmodifiableList(this.stmts);
    }

    @Override
    public GroovyExpression copy(List<GroovyExpression> newChildren) {
        return new StatementListExpression(newChildren);
    }

    public List<GroovyExpression> getStatements() {
        return this.stmts;
    }

    @Override
    public TraversalStepType getType() {
        return TraversalStepType.NONE;
    }

    public void replaceStatement(int index, GroovyExpression newExpr) {
        this.stmts.set(index, newExpr);
    }
}

