/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.groovy;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.atlas.groovy.AbstractGroovyExpression;
import org.apache.atlas.groovy.GroovyExpression;
import org.apache.atlas.groovy.GroovyGenerationContext;

public class LiteralExpression
extends AbstractGroovyExpression {
    public static final LiteralExpression TRUE = new LiteralExpression(true);
    public static final LiteralExpression FALSE = new LiteralExpression(false);
    public static final LiteralExpression NULL = new LiteralExpression(null);
    private final Object value;
    private boolean translateToParameter;
    private boolean addTypeSuffix;

    public LiteralExpression(Object value, boolean addTypeSuffix) {
        this.value = value;
        this.translateToParameter = value instanceof String;
        this.addTypeSuffix = addTypeSuffix;
    }

    public LiteralExpression(Object value, boolean addTypeSuffix, boolean translateToParameter) {
        this.value = value;
        this.translateToParameter = translateToParameter;
        this.addTypeSuffix = addTypeSuffix;
    }

    public LiteralExpression(Object value) {
        this.value = value;
        this.translateToParameter = value instanceof String;
    }

    @Override
    public void generateGroovy(GroovyGenerationContext context) {
        if (this.translateToParameter) {
            GroovyExpression result = context.addParameter(this.value);
            result.generateGroovy(context);
            return;
        }
        if (this.value instanceof String) {
            String escapedValue = this.getEscapedValue();
            context.append("'");
            context.append(escapedValue);
            context.append("'");
        } else {
            context.append(String.valueOf(this.value));
            context.append(this.getTypeSuffix());
        }
    }

    @Override
    public List<GroovyExpression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public GroovyExpression copy(List<GroovyExpression> newChildren) {
        return new LiteralExpression(this.value, this.addTypeSuffix, this.translateToParameter);
    }

    public Object getValue() {
        return this.value;
    }

    public void setTranslateToParameter(boolean translateToParameter) {
        this.translateToParameter = translateToParameter;
    }

    private String getTypeSuffix() {
        if (!this.addTypeSuffix) {
            return "";
        }
        if (this.value.getClass() == Long.class) {
            return "L";
        }
        if (this.value.getClass() == Float.class) {
            return "f";
        }
        if (this.value.getClass() == Double.class) {
            return "d";
        }
        return "";
    }

    private String getEscapedValue() {
        String escapedValue = (String)this.value;
        escapedValue = escapedValue.replaceAll(Pattern.quote("\\"), Matcher.quoteReplacement("\\\\"));
        escapedValue = escapedValue.replaceAll(Pattern.quote("'"), Matcher.quoteReplacement("\\'"));
        return escapedValue;
    }
}

