/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.groovy;

import java.util.Collections;
import java.util.List;
import org.apache.atlas.groovy.AbstractGroovyExpression;
import org.apache.atlas.groovy.GroovyExpression;
import org.apache.atlas.groovy.GroovyGenerationContext;

public class LabeledExpression
extends AbstractGroovyExpression {
    private final String label;
    private final GroovyExpression expr;

    public LabeledExpression(String label, GroovyExpression expr) {
        this.label = label;
        this.expr = expr;
    }

    @Override
    public void generateGroovy(GroovyGenerationContext context) {
        context.append(this.label);
        context.append(":");
        this.expr.generateGroovy(context);
    }

    @Override
    public List<GroovyExpression> getChildren() {
        return Collections.singletonList(this.expr);
    }

    @Override
    public GroovyExpression copy(List<GroovyExpression> newChildren) {
        return new LabeledExpression(this.label, newChildren.get(0));
    }
}

