/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.groovy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.atlas.groovy.AbstractFunctionExpression;
import org.apache.atlas.groovy.GroovyExpression;
import org.apache.atlas.groovy.GroovyGenerationContext;
import org.apache.atlas.groovy.TraversalStepType;

public class FunctionCallExpression
extends AbstractFunctionExpression {
    private final String functionName;
    private final List<GroovyExpression> arguments = new ArrayList<GroovyExpression>();

    public FunctionCallExpression(TraversalStepType type, String functionName, GroovyExpression ... arguments) {
        super(type, null);
        this.functionName = functionName;
        this.arguments.addAll(Arrays.asList(arguments));
    }

    public FunctionCallExpression(String functionName, GroovyExpression ... arguments) {
        super(null);
        this.functionName = functionName;
        this.arguments.addAll(Arrays.asList(arguments));
    }

    public FunctionCallExpression(TraversalStepType type, String functionName, List<GroovyExpression> arguments) {
        super(type, null);
        this.functionName = functionName;
        this.arguments.addAll(arguments);
    }

    public FunctionCallExpression(GroovyExpression target, String functionName, GroovyExpression ... arguments) {
        super(target);
        this.functionName = functionName;
        this.arguments.addAll(Arrays.asList(arguments));
    }

    public FunctionCallExpression(TraversalStepType type, GroovyExpression target, String functionName, List<? extends GroovyExpression> arguments) {
        super(type, target);
        this.functionName = functionName;
        this.arguments.addAll(arguments);
    }

    public FunctionCallExpression(TraversalStepType type, GroovyExpression target, String functionName, GroovyExpression ... arguments) {
        super(type, target);
        this.functionName = functionName;
        this.arguments.addAll(Arrays.asList(arguments));
    }

    public void addArgument(GroovyExpression expr) {
        this.arguments.add(expr);
    }

    public List<GroovyExpression> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public void generateGroovy(GroovyGenerationContext context) {
        if (this.getCaller() != null) {
            this.getCaller().generateGroovy(context);
            context.append(".");
        }
        context.append(this.functionName);
        context.append("(");
        Iterator<GroovyExpression> it = this.arguments.iterator();
        while (it.hasNext()) {
            GroovyExpression expr = it.next();
            expr.generateGroovy(context);
            if (!it.hasNext()) continue;
            context.append(",");
        }
        context.append(")");
    }

    @Override
    public List<GroovyExpression> getChildren() {
        ArrayList<GroovyExpression> result = new ArrayList<GroovyExpression>(this.arguments.size() + 1);
        if (this.getCaller() != null) {
            result.add(this.getCaller());
        }
        result.addAll(this.arguments);
        return result;
    }

    @Override
    public GroovyExpression copy(List<GroovyExpression> newChildren) {
        if (this.getCaller() == null) {
            return new FunctionCallExpression(this.getType(), this.functionName, newChildren);
        }
        GroovyExpression newTarget = newChildren.get(0);
        List<Object> args = newChildren.size() > 1 ? newChildren.subList(1, newChildren.size()) : Collections.emptyList();
        return new FunctionCallExpression(this.getType(), newTarget, this.functionName, args);
    }

    public void setArgument(int index, GroovyExpression value) {
        if (index < 0 || index >= this.arguments.size()) {
            throw new IllegalArgumentException("Invalid argIndex " + index);
        }
        this.arguments.set(index, value);
    }
}

