/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.groovy;

import java.util.Collections;
import java.util.List;
import org.apache.atlas.groovy.AbstractFunctionExpression;
import org.apache.atlas.groovy.GroovyExpression;
import org.apache.atlas.groovy.GroovyGenerationContext;

public class FieldExpression
extends AbstractFunctionExpression {
    private final String fieldName;

    public FieldExpression(GroovyExpression target, String fieldName) {
        super(target);
        this.fieldName = fieldName;
    }

    @Override
    public void generateGroovy(GroovyGenerationContext context) {
        this.getCaller().generateGroovy(context);
        context.append(".'");
        context.append(this.fieldName);
        context.append("'");
    }

    @Override
    public List<GroovyExpression> getChildren() {
        return Collections.singletonList(this.getCaller());
    }

    @Override
    public GroovyExpression copy(List<GroovyExpression> newChildren) {
        return new FieldExpression(newChildren.get(0), this.fieldName);
    }
}

