/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Properties;
import org.apache.atlas.utils.KafkaUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.JaasContext;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KafkaUtilsTest {
    protected static final String JAAS_MASKED_PASSWORD = "keypass";
    protected Path jksPath;
    protected String providerUrl;

    @Test
    public void testSetKafkaJAASPropertiesForAllProperValues() {
        Properties properties = new Properties();
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        String loginModuleName = "com.sun.security.auth.module.Krb5LoginModule";
        String loginModuleControlFlag = "required";
        String optionUseKeyTab = "false";
        String optionStoreKey = "true";
        String optionServiceName = "kafka";
        configuration.setProperty("atlas.jaas.KafkaClient.loginModuleName", (Object)"com.sun.security.auth.module.Krb5LoginModule");
        configuration.setProperty("atlas.jaas.KafkaClient.loginModuleControlFlag", (Object)"required");
        configuration.setProperty("atlas.jaas.KafkaClient.option.useKeyTab", (Object)"false");
        configuration.setProperty("atlas.jaas.KafkaClient.option.storeKey", (Object)"true");
        configuration.setProperty("atlas.jaas.KafkaClient.option.serviceName", (Object)"kafka");
        KafkaUtils.setKafkaJAASProperties((Configuration)configuration, (Properties)properties);
        String newPropertyValue = properties.getProperty("sasl.jaas.config");
        Assert.assertTrue((boolean)newPropertyValue.contains("com.sun.security.auth.module.Krb5LoginModule"), (String)"loginModuleName not present in new property");
        Assert.assertTrue((boolean)newPropertyValue.contains("required"), (String)"loginModuleControlFlag not present in new property");
        Assert.assertTrue((boolean)newPropertyValue.contains("useKeyTab=\"false\""), (String)"useKeyTab not present in new property or value doesn't match");
        Assert.assertTrue((boolean)newPropertyValue.contains("storeKey=\"true\""), (String)"storeKey not present in new property or value doesn't match");
        Assert.assertTrue((boolean)newPropertyValue.contains("serviceName=\"kafka\""), (String)"serviceName not present in new property or value doesn't match");
        this.assertJaaSConfigLoadable(newPropertyValue);
    }

    @Test
    public void testSetKafkaJAASPropertiesForMissingControlFlag() {
        Properties properties = new Properties();
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        String loginModuleName = "com.sun.security.auth.module.Krb5LoginModule";
        String loginModuleControlFlag = "required";
        String optionUseKeyTab = "false";
        String optionStoreKey = "true";
        String optionServiceName = "kafka";
        configuration.setProperty("atlas.jaas.KafkaClient.loginModuleName", (Object)"com.sun.security.auth.module.Krb5LoginModule");
        configuration.setProperty("atlas.jaas.KafkaClient.option.useKeyTab", (Object)"false");
        configuration.setProperty("atlas.jaas.KafkaClient.option.storeKey", (Object)"true");
        configuration.setProperty("atlas.jaas.KafkaClient.option.serviceName", (Object)"kafka");
        KafkaUtils.setKafkaJAASProperties((Configuration)configuration, (Properties)properties);
        String newPropertyValue = properties.getProperty("sasl.jaas.config");
        Assert.assertTrue((boolean)newPropertyValue.contains("com.sun.security.auth.module.Krb5LoginModule"), (String)"loginModuleName not present in new property");
        Assert.assertTrue((boolean)newPropertyValue.contains("required"), (String)"loginModuleControlFlag not present in new property");
        Assert.assertTrue((boolean)newPropertyValue.contains("useKeyTab=\"false\""), (String)"useKeyTab not present in new property or value doesn't match");
        Assert.assertTrue((boolean)newPropertyValue.contains("storeKey=\"true\""), (String)"storeKey not present in new property or value doesn't match");
        Assert.assertTrue((boolean)newPropertyValue.contains("serviceName=\"kafka\""), (String)"serviceName not present in new property or value doesn't match");
        this.assertJaaSConfigLoadable(newPropertyValue);
    }

    @Test
    public void testSetKafkaJAASPropertiesForMissingLoginModuleName() {
        Properties properties = new Properties();
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        String loginModuleControlFlag = "required";
        String optionUseKeyTab = "false";
        String optionStoreKey = "true";
        String optionServiceName = "kafka";
        configuration.setProperty("atlas.jaas.KafkaClient.loginModuleControlFlag", (Object)"required");
        configuration.setProperty("atlas.jaas.KafkaClient.option.useKeyTab", (Object)"false");
        configuration.setProperty("atlas.jaas.KafkaClient.option.storeKey", (Object)"true");
        configuration.setProperty("atlas.jaas.KafkaClient.option.serviceName", (Object)"kafka");
        KafkaUtils.setKafkaJAASProperties((Configuration)configuration, (Properties)properties);
        String newPropertyValue = properties.getProperty("sasl.jaas.config");
        Assert.assertNull((Object)newPropertyValue);
    }

    @Test
    public void testSetKafkaJAASPropertiesWithSpecialCharacters() {
        Properties properties = new Properties();
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        String loginModuleName = "com.sun.security.auth.module.Krb5LoginModule";
        String loginModuleControlFlag = "required";
        String optionKeyTabPath = "/path/to/file.keytab";
        String optionPrincipal = "test/_HOST@EXAMPLE.COM";
        configuration.setProperty("atlas.jaas.KafkaClient.loginModuleName", (Object)"com.sun.security.auth.module.Krb5LoginModule");
        configuration.setProperty("atlas.jaas.KafkaClient.loginModuleControlFlag", (Object)"required");
        configuration.setProperty("atlas.jaas.KafkaClient.option.keyTabPath", (Object)"/path/to/file.keytab");
        configuration.setProperty("atlas.jaas.KafkaClient.option.principal", (Object)"test/_HOST@EXAMPLE.COM");
        try {
            KafkaUtils.setKafkaJAASProperties((Configuration)configuration, (Properties)properties);
            String newPropertyValue = properties.getProperty("sasl.jaas.config");
            String updatedPrincipalValue = SecurityUtil.getServerPrincipal((String)"test/_HOST@EXAMPLE.COM", (String)null);
            Assert.assertTrue((boolean)newPropertyValue.contains("com.sun.security.auth.module.Krb5LoginModule"), (String)"loginModuleName not present in new property");
            Assert.assertTrue((boolean)newPropertyValue.contains("required"), (String)"loginModuleControlFlag not present in new property");
            Assert.assertTrue((boolean)newPropertyValue.contains("keyTabPath=\"/path/to/file.keytab\""));
            Assert.assertTrue((boolean)newPropertyValue.contains("principal=\"" + updatedPrincipalValue + "\""));
            this.assertJaaSConfigLoadable(newPropertyValue);
        }
        catch (IOException e) {
            Assert.fail((String)("Failed while getting updated principal value with exception : " + e.getMessage()));
        }
    }

    @Test
    public void testSetKafkaJAASPropertiesForTicketBasedLoginConfig() {
        Properties properties = new Properties();
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        String loginModuleName = "com.sun.security.auth.module.Krb5LoginModule";
        String loginModuleControlFlag = "required";
        String optionUseKeyTab = "false";
        String optionStoreKey = "true";
        String optionServiceName = "kafka";
        configuration.setProperty("atlas.kafka.bootstrap.servers", (Object)"localhost:9100");
        configuration.setProperty("atlas.jaas.ticketBased-KafkaClient.loginModuleName", (Object)"com.sun.security.auth.module.Krb5LoginModule");
        configuration.setProperty("atlas.jaas.ticketBased-KafkaClient.loginModuleControlFlag", (Object)"required");
        configuration.setProperty("atlas.jaas.ticketBased-KafkaClient.option.useKeyTab", (Object)"false");
        configuration.setProperty("atlas.jaas.ticketBased-KafkaClient.option.storeKey", (Object)"true");
        configuration.setProperty("atlas.jaas.ticketBased-KafkaClient.option.serviceName", (Object)"kafka");
        try (MockedStatic mockedKafkaUtilsClass = Mockito.mockStatic(KafkaUtils.class);){
            mockedKafkaUtilsClass.when(KafkaUtils::isLoginKeytabBased).thenReturn((Object)false);
            mockedKafkaUtilsClass.when(KafkaUtils::isLoginTicketBased).thenReturn((Object)true);
            mockedKafkaUtilsClass.when(() -> KafkaUtils.surroundWithQuotes((String)Mockito.anyString())).thenCallRealMethod();
            mockedKafkaUtilsClass.when(() -> KafkaUtilsTest.lambda$testSetKafkaJAASPropertiesForTicketBasedLoginConfig$1((Configuration)configuration, properties)).thenCallRealMethod();
            KafkaUtils.setKafkaJAASProperties((Configuration)configuration, (Properties)properties);
            String newPropertyValue = properties.getProperty("sasl.jaas.config");
            Assert.assertTrue((boolean)newPropertyValue.contains("com.sun.security.auth.module.Krb5LoginModule"), (String)"loginModuleName not present in new property");
            Assert.assertTrue((boolean)newPropertyValue.contains("required"), (String)"loginModuleControlFlag not present in new property");
            Assert.assertTrue((boolean)newPropertyValue.contains("useKeyTab=\"false\""), (String)"useKeyTab not present in new property or value doesn't match");
            Assert.assertTrue((boolean)newPropertyValue.contains("storeKey=\"true\""), (String)"storeKey not present in new property or value doesn't match");
            Assert.assertTrue((boolean)newPropertyValue.contains("serviceName=\"kafka\""), (String)"serviceName not present in new property or value doesn't match");
            this.assertJaaSConfigLoadable(newPropertyValue);
        }
    }

    @Test
    public void testSetKafkaJAASPropertiesForTicketBasedLoginFallback() {
        Properties properties = new Properties();
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        String loginModuleName = "com.sun.security.auth.module.Krb5LoginModule";
        String loginModuleControlFlag = "required";
        String optionUseKeyTab = "false";
        String optionStoreKey = "true";
        String optionServiceName = "kafka";
        configuration.setProperty("atlas.jaas.KafkaClient.loginModuleName", (Object)"com.sun.security.auth.module.Krb5LoginModule");
        configuration.setProperty("atlas.jaas.KafkaClient.loginModuleControlFlag", (Object)"required");
        configuration.setProperty("atlas.jaas.KafkaClient.option.useKeyTab", (Object)"false");
        configuration.setProperty("atlas.jaas.KafkaClient.option.storeKey", (Object)"true");
        configuration.setProperty("atlas.jaas.KafkaClient.option.serviceName", (Object)"kafka");
        try (MockedStatic mockedKafkaUtilsClass = Mockito.mockStatic(KafkaUtils.class);){
            mockedKafkaUtilsClass.when(KafkaUtils::isLoginKeytabBased).thenReturn((Object)false);
            mockedKafkaUtilsClass.when(KafkaUtils::isLoginTicketBased).thenReturn((Object)true);
            mockedKafkaUtilsClass.when(() -> KafkaUtils.surroundWithQuotes((String)Mockito.anyString())).thenCallRealMethod();
            mockedKafkaUtilsClass.when(() -> KafkaUtilsTest.lambda$testSetKafkaJAASPropertiesForTicketBasedLoginFallback$3((Configuration)configuration, properties)).thenCallRealMethod();
            KafkaUtils.setKafkaJAASProperties((Configuration)configuration, (Properties)properties);
            String newPropertyValue = properties.getProperty("sasl.jaas.config");
            Assert.assertTrue((boolean)newPropertyValue.contains("com.sun.security.auth.module.Krb5LoginModule"), (String)"loginModuleName not present in new property");
            Assert.assertTrue((boolean)newPropertyValue.contains("required"), (String)"loginModuleControlFlag not present in new property");
            Assert.assertTrue((boolean)newPropertyValue.contains("useKeyTab=\"false\""), (String)"useKeyTab not present in new property or value doesn't match");
            Assert.assertTrue((boolean)newPropertyValue.contains("storeKey=\"true\""), (String)"storeKey not present in new property or value doesn't match");
            Assert.assertTrue((boolean)newPropertyValue.contains("serviceName=\"kafka\""), (String)"serviceName not present in new property or value doesn't match");
            this.assertJaaSConfigLoadable(newPropertyValue);
        }
    }

    @Test
    public void testSetKafkaJAASPropertiesForTokenAuthConfig() {
        Properties properties = new Properties();
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        String loginModuleName = "org.apache.kafka.common.security.scram.ScramLoginModule";
        String loginModuleControlFlag = "required";
        String optionUseKeyTab = "false";
        String optionStoreKey = "false";
        String optionServiceName = "kafka";
        String optionTokenAuth = "true";
        String optionUsername = "30CQ4q1hQMy0dB6X0eXfxQ";
        String optionPassword = "KdaUQ4FlKWlDxwQrAeFGUVbb6sR0P+zoqOZDZjtIRP1wseXbSbhiTjz3QI9Ur9o4LTYZSv8TE1QqUC4FSwnoTA==";
        configuration.setProperty("atlas.kafka.bootstrap.servers", (Object)"localhost:9100");
        configuration.setProperty("atlas.jaas.KafkaClient.loginModuleName", (Object)"org.apache.kafka.common.security.scram.ScramLoginModule");
        configuration.setProperty("atlas.jaas.KafkaClient.loginModuleControlFlag", (Object)"required");
        configuration.setProperty("atlas.jaas.KafkaClient.option.useKeyTab", (Object)"false");
        configuration.setProperty("atlas.jaas.KafkaClient.option.storeKey", (Object)"false");
        configuration.setProperty("atlas.jaas.KafkaClient.option.serviceName", (Object)"kafka");
        configuration.setProperty("atlas.jaas.KafkaClient.option.tokenauth", (Object)"true");
        configuration.setProperty("atlas.jaas.KafkaClient.option.username", (Object)"30CQ4q1hQMy0dB6X0eXfxQ");
        configuration.setProperty("atlas.jaas.KafkaClient.option.password", (Object)"KdaUQ4FlKWlDxwQrAeFGUVbb6sR0P+zoqOZDZjtIRP1wseXbSbhiTjz3QI9Ur9o4LTYZSv8TE1QqUC4FSwnoTA==");
        try (MockedStatic mockedKafkaUtilsClass = Mockito.mockStatic(KafkaUtils.class);){
            mockedKafkaUtilsClass.when(() -> KafkaUtils.surroundWithQuotes((String)Mockito.anyString())).thenCallRealMethod();
            mockedKafkaUtilsClass.when(() -> KafkaUtilsTest.lambda$testSetKafkaJAASPropertiesForTokenAuthConfig$5((Configuration)configuration, properties)).thenCallRealMethod();
            KafkaUtils.setKafkaJAASProperties((Configuration)configuration, (Properties)properties);
            String newPropertyValue = properties.getProperty("sasl.jaas.config");
            Assert.assertTrue((boolean)newPropertyValue.contains("org.apache.kafka.common.security.scram.ScramLoginModule"), (String)"loginModuleName not present in new property");
            Assert.assertTrue((boolean)newPropertyValue.contains("required"), (String)"loginModuleControlFlag not present in new property");
            Assert.assertTrue((boolean)newPropertyValue.contains("useKeyTab=\"false\""), (String)"useKeyTab not present in new property or value doesn't match");
            Assert.assertTrue((boolean)newPropertyValue.contains("storeKey=\"false\""), (String)"storeKey not present in new property or value doesn't match");
            Assert.assertTrue((boolean)newPropertyValue.contains("serviceName=\"kafka\""), (String)"serviceName not present in new property or value doesn't match");
            Assert.assertTrue((boolean)newPropertyValue.contains("tokenauth=\"true\""), (String)"tokenauth not present in new property or value doesn't match");
            Assert.assertTrue((boolean)newPropertyValue.contains("username=\"30CQ4q1hQMy0dB6X0eXfxQ\""), (String)"username not present in new property or value doesn't match");
            Assert.assertTrue((boolean)newPropertyValue.contains("password=\"KdaUQ4FlKWlDxwQrAeFGUVbb6sR0P+zoqOZDZjtIRP1wseXbSbhiTjz3QI9Ur9o4LTYZSv8TE1QqUC4FSwnoTA==\""), (String)"password not present in new property or value doesn't match");
            this.assertJaaSConfigLoadable(newPropertyValue);
        }
    }

    @Test
    public void testSetKafkaJAASPropertiesForClearTextPassword() throws Exception {
        Properties properties = new Properties();
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        this.setupCredentials();
        String loginModuleName = "org.apache.kafka.common.security.scram.ScramLoginModule";
        String loginModuleControlFlag = "required";
        String optionUseKeyTab = "false";
        String optionStoreKey = "false";
        String optionServiceName = "kafka";
        String optionTokenAuth = "true";
        String optionUsername = "30CQ4q1hQMy0dB6X0eXfxQ";
        String optionPassword = "admin123";
        configuration.setProperty("atlas.kafka.bootstrap.servers", (Object)"localhost:9100");
        configuration.setProperty("atlas.jaas.KafkaClient.loginModuleName", (Object)"org.apache.kafka.common.security.scram.ScramLoginModule");
        configuration.setProperty("atlas.jaas.KafkaClient.loginModuleControlFlag", (Object)"required");
        configuration.setProperty("atlas.jaas.KafkaClient.option.useKeyTab", (Object)"false");
        configuration.setProperty("atlas.jaas.KafkaClient.option.storeKey", (Object)"false");
        configuration.setProperty("atlas.jaas.KafkaClient.option.serviceName", (Object)"kafka");
        configuration.setProperty("atlas.jaas.KafkaClient.option.tokenauth", (Object)"true");
        configuration.setProperty("atlas.jaas.KafkaClient.option.username", (Object)"30CQ4q1hQMy0dB6X0eXfxQ");
        configuration.setProperty("atlas.jaas.KafkaClient.option.password", (Object)"admin123");
        configuration.setProperty("hadoop.security.credential.provider.path", (Object)this.providerUrl);
        try (MockedStatic mockedKafkaUtilsClass = Mockito.mockStatic(KafkaUtils.class);){
            mockedKafkaUtilsClass.when(() -> KafkaUtils.surroundWithQuotes((String)Mockito.anyString())).thenCallRealMethod();
            mockedKafkaUtilsClass.when(() -> KafkaUtilsTest.lambda$testSetKafkaJAASPropertiesForClearTextPassword$7((Configuration)configuration, properties)).thenCallRealMethod();
            KafkaUtils.setKafkaJAASProperties((Configuration)configuration, (Properties)properties);
            String newPropertyValue = properties.getProperty("sasl.jaas.config");
            Assert.assertTrue((boolean)newPropertyValue.contains("org.apache.kafka.common.security.scram.ScramLoginModule"), (String)"loginModuleName not present in new property");
            Assert.assertTrue((boolean)newPropertyValue.contains("required"), (String)"loginModuleControlFlag not present in new property");
            Assert.assertTrue((boolean)newPropertyValue.contains("useKeyTab=\"false\""), (String)"useKeyTab not present in new property or value doesn't match");
            Assert.assertTrue((boolean)newPropertyValue.contains("storeKey=\"false\""), (String)"storeKey not present in new property or value doesn't match");
            Assert.assertTrue((boolean)newPropertyValue.contains("serviceName=\"kafka\""), (String)"serviceName not present in new property or value doesn't match");
            Assert.assertTrue((boolean)newPropertyValue.contains("tokenauth=\"true\""), (String)"tokenauth not pres////.ent in new property or value doesn't match");
            Assert.assertTrue((boolean)newPropertyValue.contains("username=\"30CQ4q1hQMy0dB6X0eXfxQ\""), (String)"username not present in new property or value doesn't match");
            Assert.assertTrue((boolean)newPropertyValue.contains("password=\"admin123\""), (String)"password not present in new property or value doesn't match");
            this.assertJaaSConfigLoadable(newPropertyValue);
        }
    }

    @Test
    public void testSetKafkaJAASPropertiesForPasswordEncryption() throws Exception {
        Properties properties = new Properties();
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        this.setupCredentials();
        String loginModuleName = "org.apache.kafka.common.security.scram.ScramLoginModule";
        String loginModuleControlFlag = "required";
        String optionUseKeyTab = "false";
        String optionStoreKey = "false";
        String optionServiceName = "kafka";
        String optionTokenAuth = "true";
        String optionUsername = "30CQ4q1hQMy0dB6X0eXfxQ";
        String optionPassword = "********";
        configuration.setProperty("atlas.kafka.bootstrap.servers", (Object)"localhost:9100");
        configuration.setProperty("atlas.jaas.KafkaClient.loginModuleName", (Object)"org.apache.kafka.common.security.scram.ScramLoginModule");
        configuration.setProperty("atlas.jaas.KafkaClient.loginModuleControlFlag", (Object)"required");
        configuration.setProperty("atlas.jaas.KafkaClient.option.useKeyTab", (Object)"false");
        configuration.setProperty("atlas.jaas.KafkaClient.option.storeKey", (Object)"false");
        configuration.setProperty("atlas.jaas.KafkaClient.option.serviceName", (Object)"kafka");
        configuration.setProperty("atlas.jaas.KafkaClient.option.tokenauth", (Object)"true");
        configuration.setProperty("atlas.jaas.KafkaClient.option.username", (Object)"30CQ4q1hQMy0dB6X0eXfxQ");
        configuration.setProperty("atlas.jaas.KafkaClient.option.password", (Object)"********");
        configuration.setProperty("hadoop.security.credential.provider.path", (Object)this.providerUrl);
        try (MockedStatic mockedKafkaUtilsClass = Mockito.mockStatic(KafkaUtils.class);){
            mockedKafkaUtilsClass.when(() -> KafkaUtils.surroundWithQuotes((String)Mockito.anyString())).thenCallRealMethod();
            mockedKafkaUtilsClass.when(() -> KafkaUtilsTest.lambda$testSetKafkaJAASPropertiesForPasswordEncryption$9((Configuration)configuration, properties)).thenCallRealMethod();
            KafkaUtils.setKafkaJAASProperties((Configuration)configuration, (Properties)properties);
            String newPropertyValue = properties.getProperty("sasl.jaas.config");
            Assert.assertTrue((boolean)newPropertyValue.contains("org.apache.kafka.common.security.scram.ScramLoginModule"), (String)"loginModuleName not present in new property");
            Assert.assertTrue((boolean)newPropertyValue.contains("required"), (String)"loginModuleControlFlag not present in new property");
            Assert.assertTrue((boolean)newPropertyValue.contains("useKeyTab=\"false\""), (String)"useKeyTab not present in new property or value doesn't match");
            Assert.assertTrue((boolean)newPropertyValue.contains("storeKey=\"false\""), (String)"storeKey not present in new property or value doesn't match");
            Assert.assertTrue((boolean)newPropertyValue.contains("serviceName=\"kafka\""), (String)"serviceName not present in new property or value doesn't match");
            Assert.assertTrue((boolean)newPropertyValue.contains("tokenauth=\"true\""), (String)"tokenauth not pres////.ent in new property or value doesn't match");
            Assert.assertTrue((boolean)newPropertyValue.contains("username=\"30CQ4q1hQMy0dB6X0eXfxQ\""), (String)"username not present in new property or value doesn't match");
            Assert.assertTrue((boolean)newPropertyValue.contains("password=\"keypass\""), (String)"password not present in new property or value doesn't match");
            this.assertJaaSConfigLoadable(newPropertyValue);
        }
    }

    protected void setupCredentials() throws Exception {
        this.jksPath = new Path(Files.createTempDirectory("tempproviders", new FileAttribute[0]).toString(), "kafka.jceks");
        this.providerUrl = "jceks://file/" + this.jksPath.toUri();
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration(false);
        conf.set("hadoop.security.credential.provider.path", this.providerUrl);
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((org.apache.hadoop.conf.Configuration)conf).get(0);
        try {
            provider.createCredentialEntry("atlas.jaas.KafkaClient.option.password", JAAS_MASKED_PASSWORD.toCharArray());
            provider.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void assertJaaSConfigLoadable(String jaasConfig) {
        HashMap<String, Password> jaasConfigs = new HashMap<String, Password>();
        jaasConfigs.put("sasl.jaas.config", new Password(jaasConfig));
        try {
            JaasContext.loadClientContext(jaasConfigs);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)String.format("JaaS config '%s' can not be loaded", jaasConfig), (Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$testSetKafkaJAASPropertiesForPasswordEncryption$9(Configuration configuration, Properties properties) throws Throwable {
        KafkaUtils.setKafkaJAASProperties((Configuration)configuration, (Properties)properties);
    }

    private static /* synthetic */ void lambda$testSetKafkaJAASPropertiesForClearTextPassword$7(Configuration configuration, Properties properties) throws Throwable {
        KafkaUtils.setKafkaJAASProperties((Configuration)configuration, (Properties)properties);
    }

    private static /* synthetic */ void lambda$testSetKafkaJAASPropertiesForTokenAuthConfig$5(Configuration configuration, Properties properties) throws Throwable {
        KafkaUtils.setKafkaJAASProperties((Configuration)configuration, (Properties)properties);
    }

    private static /* synthetic */ void lambda$testSetKafkaJAASPropertiesForTicketBasedLoginFallback$3(Configuration configuration, Properties properties) throws Throwable {
        KafkaUtils.setKafkaJAASProperties((Configuration)configuration, (Properties)properties);
    }

    private static /* synthetic */ void lambda$testSetKafkaJAASPropertiesForTicketBasedLoginConfig$1(Configuration configuration, Properties properties) throws Throwable {
        KafkaUtils.setKafkaJAASProperties((Configuration)configuration, (Properties)properties);
    }
}

