/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.utils.AtlasPathExtractorUtil;
import org.apache.atlas.utils.PathExtractorContext;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AtlasPathExtractorUtilTest {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasPathExtractorUtilTest.class);
    private static final String METADATA_NAMESPACE = "metaspace";
    private static final String QNAME_METADATA_NAMESPACE = "@metaspace";
    private static final String SCHEME_SEPARATOR = "://";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_QUALIFIED_NAME = "qualifiedName";
    private static final String HDFS_PATH_TYPE = "hdfs_path";
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_CLUSTER_NAME = "clusterName";
    private static final String OZONE_VOLUME = "ozone_volume";
    private static final String OZONE_BUCKET = "ozone_bucket";
    private static final String OZONE_KEY = "ozone_key";
    private static final String OZONE_SCHEME = "ofs://";
    private static final String OZONE_3_SCHEME = "o3fs://";
    private static final String HDFS_SCHEME = "hdfs://";
    private static final String HDFS_PATH = "hdfs://host_name:8020/warehouse/tablespace/external/hive/taBlE_306";
    private static final String ADLS_GEN2_ACCOUNT = "adls_gen2_account";
    private static final String ADLS_GEN2_CONTAINER = "adls_gen2_container";
    private static final String ADLS_GEN2_DIRECTORY = "adls_gen2_directory";
    private static final String ABFS_SCHEME = "abfs://";
    private static final String ABFS_PATH = "abfs://data@razrangersan.dfs.core.windows.net/tmp/cdp-demo/sample.csv";
    private static final String ABFSS_SCHEME = "abfss://";
    private static final String ABFSS_PATH = "abfss://data@razrangersan.dfs.core.windows.net/tmp/cdp-demo/sample.csv";
    private static final String AWS_S3_ATLAS_MODEL_VERSION_V2 = "V2";
    private static final String AWS_S3_BUCKET = "aws_s3_bucket";
    private static final String AWS_S3_PSEUDO_DIR = "aws_s3_pseudo_dir";
    private static final String AWS_S3_V2_BUCKET = "aws_s3_v2_bucket";
    private static final String AWS_S3_V2_PSEUDO_DIR = "aws_s3_v2_directory";
    private static final String S3_SCHEME = "s3://";
    private static final String S3_PATH = "s3://aws_my_bucket1/1234567890/renders/Irradiance_A.csv";
    private static final String S3A_SCHEME = "s3a://";
    private static final String S3A_PATH = "s3a://aws_my_bucket1/1234567890/renders/Irradiance_A.csv";
    private static final String ATTRIBUTE_OBJECT_PREFIX = "objectPrefix";
    private static final String GCS_VIRTUAL_DIR = "gcp_storage_virtual_directory";
    private static final String GCS_BUCKET = "gcp_storage_bucket";
    private static final String GCS_SCHEME = "gs://";
    private static final String GCS_PATH = "gs://gcs_test_bucket1/1234567890/data";

    @Test(dataProvider="ozonePathProvider")
    public void testGetPathEntityOzone3Path(OzoneKeyValidator validator) {
        String scheme = validator.scheme;
        String ozonePath = scheme + validator.location;
        PathExtractorContext extractorContext = new PathExtractorContext(METADATA_NAMESPACE);
        Path path = new Path(ozonePath);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = AtlasPathExtractorUtil.getPathEntity((Path)path, (PathExtractorContext)extractorContext);
        AtlasEntity entity = entityWithExtInfo.getEntity();
        Assert.assertNotNull((Object)entity);
        this.verifyOzoneKeyEntity(entity, validator);
        if (entity.getTypeName() == OZONE_KEY) {
            this.verifyReferredAndKnownEntities(entityWithExtInfo, extractorContext, validator, validator.knownEntitiesCountTillKey, 2);
        } else if (entity.getTypeName() == OZONE_BUCKET) {
            this.verifyReferredAndKnownEntities(entityWithExtInfo, extractorContext, validator, validator.knownEntitiesCountTillBucket, 2);
        } else if (entity.getTypeName() == OZONE_VOLUME) {
            this.verifyReferredAndKnownEntities(entityWithExtInfo, extractorContext, validator, validator.knownEntitiesCountTillVolume, 1);
        }
    }

    private void verifyReferredAndKnownEntities(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo, PathExtractorContext extractorContext, OzoneKeyValidator validator, int knownEntitiesCountTillVolume, int referredEntitiesSize) {
        Assert.assertEquals((int)entityWithExtInfo.getReferredEntities().size(), (int)referredEntitiesSize);
        this.verifyOzoneEntities(entityWithExtInfo.getReferredEntities(), validator);
        Assert.assertEquals((int)extractorContext.getKnownEntities().size(), (int)knownEntitiesCountTillVolume);
        this.verifyOzoneEntities(extractorContext.getKnownEntities(), validator);
    }

    @Test
    public void testGetPathEntityHdfsPath() {
        PathExtractorContext extractorContext = new PathExtractorContext(METADATA_NAMESPACE);
        Path path = new Path(HDFS_PATH);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = AtlasPathExtractorUtil.getPathEntity((Path)path, (PathExtractorContext)extractorContext);
        AtlasEntity entity = entityWithExtInfo.getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((String)entity.getTypeName(), (String)HDFS_PATH_TYPE);
        this.verifyHDFSEntity(entity, false);
        Assert.assertNull((Object)entityWithExtInfo.getReferredEntities());
        Assert.assertEquals((int)extractorContext.getKnownEntities().size(), (int)1);
        extractorContext.getKnownEntities().values().forEach(x -> this.verifyHDFSEntity((AtlasEntity)x, false));
    }

    @Test
    public void testGetPathEntityHdfsPathLowerCase() {
        PathExtractorContext extractorContext = new PathExtractorContext(METADATA_NAMESPACE, true, null);
        Path path = new Path(HDFS_PATH);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = AtlasPathExtractorUtil.getPathEntity((Path)path, (PathExtractorContext)extractorContext);
        AtlasEntity entity = entityWithExtInfo.getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((String)entity.getTypeName(), (String)HDFS_PATH_TYPE);
        this.verifyHDFSEntity(entity, true);
        Assert.assertNull((Object)entityWithExtInfo.getReferredEntities());
        Assert.assertEquals((int)extractorContext.getKnownEntities().size(), (int)1);
        extractorContext.getKnownEntities().values().forEach(x -> this.verifyHDFSEntity((AtlasEntity)x, true));
    }

    @Test
    public void testGetPathEntityABFSPath() {
        PathExtractorContext extractorContext = new PathExtractorContext(METADATA_NAMESPACE);
        Path path = new Path(ABFS_PATH);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = AtlasPathExtractorUtil.getPathEntity((Path)path, (PathExtractorContext)extractorContext);
        AtlasEntity entity = entityWithExtInfo.getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((String)entity.getTypeName(), (String)ADLS_GEN2_DIRECTORY);
        Assert.assertEquals((int)entityWithExtInfo.getReferredEntities().size(), (int)2);
        this.verifyABFSAdlsGen2Dir(ABFS_SCHEME, ABFS_PATH, entity);
        this.verifyABFSKnownEntities(ABFS_SCHEME, ABFS_PATH, extractorContext.getKnownEntities());
    }

    @Test
    public void testGetPathEntityABFSSPath() {
        PathExtractorContext extractorContext = new PathExtractorContext(METADATA_NAMESPACE);
        Path path = new Path(ABFSS_PATH);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = AtlasPathExtractorUtil.getPathEntity((Path)path, (PathExtractorContext)extractorContext);
        AtlasEntity entity = entityWithExtInfo.getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((String)entity.getTypeName(), (String)ADLS_GEN2_DIRECTORY);
        Assert.assertEquals((int)entityWithExtInfo.getReferredEntities().size(), (int)2);
        this.verifyABFSAdlsGen2Dir(ABFSS_SCHEME, ABFSS_PATH, entity);
        this.verifyABFSKnownEntities(ABFSS_SCHEME, ABFSS_PATH, extractorContext.getKnownEntities());
    }

    @Test
    public void testGetPathEntityS3V2Path() {
        PathExtractorContext extractorContext = new PathExtractorContext(METADATA_NAMESPACE, AWS_S3_ATLAS_MODEL_VERSION_V2);
        Path path = new Path(S3_PATH);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = AtlasPathExtractorUtil.getPathEntity((Path)path, (PathExtractorContext)extractorContext);
        AtlasEntity entity = entityWithExtInfo.getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((String)entity.getTypeName(), (String)AWS_S3_V2_PSEUDO_DIR);
        Assert.assertEquals((int)entityWithExtInfo.getReferredEntities().size(), (int)1);
        this.verifyS3V2PseudoDir(S3A_SCHEME, S3_PATH, entity);
        this.verifyS3V2KnownEntities(S3_SCHEME, S3_PATH, extractorContext.getKnownEntities());
    }

    @Test
    public void testGetPathEntityS3AV2Path() {
        PathExtractorContext extractorContext = new PathExtractorContext(METADATA_NAMESPACE, AWS_S3_ATLAS_MODEL_VERSION_V2);
        Path path = new Path(S3A_PATH);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = AtlasPathExtractorUtil.getPathEntity((Path)path, (PathExtractorContext)extractorContext);
        AtlasEntity entity = entityWithExtInfo.getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((String)entity.getTypeName(), (String)AWS_S3_V2_PSEUDO_DIR);
        Assert.assertEquals((int)entityWithExtInfo.getReferredEntities().size(), (int)1);
        this.verifyS3V2PseudoDir(S3A_SCHEME, S3A_PATH, entity);
        this.verifyS3V2KnownEntities(S3A_SCHEME, S3A_PATH, extractorContext.getKnownEntities());
    }

    @Test
    public void testGetPathEntityS3Path() {
        PathExtractorContext extractorContext = new PathExtractorContext(METADATA_NAMESPACE);
        Path path = new Path(S3_PATH);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = AtlasPathExtractorUtil.getPathEntity((Path)path, (PathExtractorContext)extractorContext);
        AtlasEntity entity = entityWithExtInfo.getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((String)entity.getTypeName(), (String)AWS_S3_PSEUDO_DIR);
        Assert.assertEquals((int)entityWithExtInfo.getReferredEntities().size(), (int)1);
        this.verifyS3PseudoDir(S3_PATH, entity);
        this.verifyS3KnownEntities(S3_SCHEME, S3_PATH, extractorContext.getKnownEntities());
    }

    @Test
    public void testGetPathEntityS3APath() {
        PathExtractorContext extractorContext = new PathExtractorContext(METADATA_NAMESPACE);
        Path path = new Path(S3A_PATH);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = AtlasPathExtractorUtil.getPathEntity((Path)path, (PathExtractorContext)extractorContext);
        AtlasEntity entity = entityWithExtInfo.getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((String)entity.getTypeName(), (String)AWS_S3_PSEUDO_DIR);
        Assert.assertEquals((int)entityWithExtInfo.getReferredEntities().size(), (int)1);
        this.verifyS3PseudoDir(S3A_PATH, entity);
        this.verifyS3KnownEntities(S3A_SCHEME, S3A_PATH, extractorContext.getKnownEntities());
    }

    @Test
    public void testGetPathEntityGCSPath() {
        PathExtractorContext extractorContext = new PathExtractorContext(METADATA_NAMESPACE);
        Path path = new Path(GCS_PATH);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = AtlasPathExtractorUtil.getPathEntity((Path)path, (PathExtractorContext)extractorContext);
        AtlasEntity entity = entityWithExtInfo.getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((String)entity.getTypeName(), (String)GCS_VIRTUAL_DIR);
        Assert.assertEquals((int)entityWithExtInfo.getReferredEntities().size(), (int)1);
        this.verifyGCSVirtualDir(GCS_SCHEME, GCS_PATH, entity);
        this.verifyGCSKnownEntities(GCS_SCHEME, GCS_PATH, extractorContext.getKnownEntities());
    }

    @DataProvider(name="ozonePathProvider")
    private Object[][] ozonePathProvider() {
        return new Object[][]{{new OzoneKeyValidator(OZONE_SCHEME, "ozone1.com/volume1/bucket1/files/file.txt", "files", "ozone1.com/volume1/bucket1/files", "file.txt", "ozone1.com/volume1/bucket1/files/file.txt")}, {new OzoneKeyValidator(OZONE_SCHEME, "ozone1:1234/volume1/bucket1/file21.txt", "file21.txt", "ozone1:1234/volume1/bucket1/file21.txt")}, {new OzoneKeyValidator(OZONE_SCHEME, "ozone1/volume1/bucket1/quarter_one/sales", "quarter_one", "ozone1/volume1/bucket1/quarter_one", "sales", "ozone1/volume1/bucket1/quarter_one/sales")}, {new OzoneKeyValidator(OZONE_SCHEME, "ozone1/volume1/bucket1/quarter_one/sales/", "quarter_one", "ozone1/volume1/bucket1/quarter_one", "sales", "ozone1/volume1/bucket1/quarter_one/sales")}, {new OzoneKeyValidator(OZONE_SCHEME, "ozone1745922163/volume1/bucket1/mykey1/key.text", "mykey1", "ozone1745922163/volume1/bucket1/mykey1", "key.text", "ozone1745922163/volume1/bucket1/mykey1/key.text")}, {new OzoneKeyValidator(OZONE_SCHEME, "ozone1/volume1/bucket1", "bucket1", "volume1.bucket1")}, {new OzoneKeyValidator(OZONE_SCHEME, "ozone1/volume1", "volume1", "volume1")}, {new OzoneKeyValidator(OZONE_3_SCHEME, "bucket1.volume1.ozone1/files/file.txt", "files", "bucket1.volume1.ozone1/files", "file.txt", "bucket1.volume1.ozone1/files/file.txt")}, {new OzoneKeyValidator(OZONE_3_SCHEME, "bucket1.volume1.ozone1/file21.txt", "file21.txt", "bucket1.volume1.ozone1/file21.txt")}, {new OzoneKeyValidator(OZONE_3_SCHEME, "bucket1.volume1.ozone1/quarter_one/sales", "quarter_one", "bucket1.volume1.ozone1/quarter_one", "sales", "bucket1.volume1.ozone1/quarter_one/sales")}, {new OzoneKeyValidator(OZONE_3_SCHEME, "bucket1.volume1.ozone1/quarter_one/sales/", "quarter_one", "bucket1.volume1.ozone1/quarter_one", "sales", "bucket1.volume1.ozone1/quarter_one/sales")}, {new OzoneKeyValidator(OZONE_3_SCHEME, "bucket1.volume1.ozone1/", "bucket1", "volume1.bucket1")}, {new OzoneKeyValidator(OZONE_3_SCHEME, "bucket1.volume1.ozone1/key1/key1.txt/", "key1", "bucket1.volume1.ozone1/key1", "key1.txt", "bucket1.volume1.ozone1/key1/key1.txt")}, {new OzoneKeyValidator(OZONE_3_SCHEME, "bucket1.volume1/key1/", "key1", "bucket1.volume1/key1")}};
    }

    private void verifyOzoneEntities(Map<String, AtlasEntity> knownEntities, OzoneKeyValidator validator) {
        for (AtlasEntity knownEntity : knownEntities.values()) {
            switch (knownEntity.getTypeName()) {
                case "ozone_key": {
                    this.verifyOzoneKeyEntity(knownEntity, validator);
                    break;
                }
                case "ozone_volume": {
                    Assert.assertEquals((Object)knownEntity.getAttribute(ATTRIBUTE_QUALIFIED_NAME), (Object)(validator.scheme + "volume1" + QNAME_METADATA_NAMESPACE));
                    Assert.assertEquals((Object)knownEntity.getAttribute(ATTRIBUTE_NAME), (Object)"volume1");
                    break;
                }
                case "ozone_bucket": {
                    Assert.assertEquals((Object)knownEntity.getAttribute(ATTRIBUTE_QUALIFIED_NAME), (Object)(validator.scheme + "volume1.bucket1" + QNAME_METADATA_NAMESPACE));
                    Assert.assertEquals((Object)knownEntity.getAttribute(ATTRIBUTE_NAME), (Object)"bucket1");
                }
            }
        }
    }

    private void verifyOzoneKeyEntity(AtlasEntity entity, OzoneKeyValidator validator) {
        if (Objects.equals(entity.getTypeName(), OZONE_KEY)) {
            Assert.assertEquals((String)entity.getTypeName(), (String)OZONE_KEY);
            Assert.assertTrue((boolean)validator.validateNameQName(entity));
        } else if (Objects.equals(entity.getTypeName(), OZONE_BUCKET)) {
            Assert.assertEquals((String)entity.getTypeName(), (String)OZONE_BUCKET);
            Assert.assertTrue((boolean)validator.validateNameQName(entity));
        } else if (Objects.equals(entity.getTypeName(), OZONE_VOLUME)) {
            Assert.assertEquals((String)entity.getTypeName(), (String)OZONE_VOLUME);
            Assert.assertTrue((boolean)validator.validateNameQName(entity));
        }
    }

    private void verifyHDFSEntity(AtlasEntity entity, boolean toLowerCase) {
        if (toLowerCase) {
            Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_QUALIFIED_NAME), (Object)(HDFS_PATH.toLowerCase() + QNAME_METADATA_NAMESPACE));
            Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_NAME), (Object)"/warehouse/tablespace/external/hive/table_306");
            Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_PATH), (Object)HDFS_PATH.toLowerCase());
            Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_CLUSTER_NAME), (Object)METADATA_NAMESPACE);
        } else {
            Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_QUALIFIED_NAME), (Object)"hdfs://host_name:8020/warehouse/tablespace/external/hive/taBlE_306@metaspace");
            Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_NAME), (Object)"/warehouse/tablespace/external/hive/taBlE_306");
            Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_PATH), (Object)HDFS_PATH);
            Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_CLUSTER_NAME), (Object)METADATA_NAMESPACE);
        }
    }

    private void verifyABFSAdlsGen2Dir(String abfsScheme, String path, AtlasEntity entity) {
        String entityQName;
        String pathQName = abfsScheme + "data@razrangersan/tmp/cdp-demo/sample.csv" + QNAME_METADATA_NAMESPACE;
        if (pathQName.equalsIgnoreCase(entityQName = (String)entity.getAttribute(ATTRIBUTE_QUALIFIED_NAME))) {
            Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_NAME), (Object)"sample.csv");
        } else {
            pathQName = abfsScheme + "data@razrangersan/tmp/cdp-demo" + QNAME_METADATA_NAMESPACE;
            if (pathQName.equalsIgnoreCase(entityQName)) {
                Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_NAME), (Object)"cdp-demo");
            } else {
                Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_QUALIFIED_NAME), (Object)(abfsScheme + "data@razrangersan/tmp" + QNAME_METADATA_NAMESPACE));
                Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_NAME), (Object)"tmp");
            }
        }
    }

    private void verifyABFSKnownEntities(String scheme, String path, Map<String, AtlasEntity> knownEntities) {
        Assert.assertEquals((int)knownEntities.size(), (int)5);
        int directoryCount = 0;
        for (AtlasEntity knownEntity : knownEntities.values()) {
            switch (knownEntity.getTypeName()) {
                case "adls_gen2_directory": {
                    this.verifyABFSAdlsGen2Dir(scheme, path, knownEntity);
                    ++directoryCount;
                    break;
                }
                case "adls_gen2_container": {
                    Assert.assertEquals((Object)knownEntity.getAttribute(ATTRIBUTE_QUALIFIED_NAME), (Object)(scheme + "data@razrangersan" + QNAME_METADATA_NAMESPACE));
                    Assert.assertEquals((Object)knownEntity.getAttribute(ATTRIBUTE_NAME), (Object)"data");
                    break;
                }
                case "adls_gen2_account": {
                    Assert.assertEquals((Object)knownEntity.getAttribute(ATTRIBUTE_QUALIFIED_NAME), (Object)(scheme + "razrangersan" + QNAME_METADATA_NAMESPACE));
                    Assert.assertEquals((Object)knownEntity.getAttribute(ATTRIBUTE_NAME), (Object)"razrangersan");
                }
            }
        }
        Assert.assertEquals((int)directoryCount, (int)3);
    }

    private void verifyS3V2PseudoDir(String s3Scheme, String path, AtlasEntity entity) {
        String entityQName;
        String pathQName = path + "/" + QNAME_METADATA_NAMESPACE;
        if (pathQName.equalsIgnoreCase(entityQName = (String)entity.getAttribute(ATTRIBUTE_QUALIFIED_NAME))) {
            Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_NAME), (Object)"Irradiance_A.csv");
            Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_OBJECT_PREFIX), (Object)"/1234567890/renders/Irradiance_A.csv/");
        } else {
            pathQName = s3Scheme + "aws_my_bucket1/1234567890/" + QNAME_METADATA_NAMESPACE;
            if (pathQName.equalsIgnoreCase(entityQName)) {
                Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_NAME), (Object)"1234567890");
                Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_OBJECT_PREFIX), (Object)"/1234567890/");
            } else {
                Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_QUALIFIED_NAME), (Object)(s3Scheme + "aws_my_bucket1/1234567890/renders/" + QNAME_METADATA_NAMESPACE));
                Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_NAME), (Object)"renders");
                Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_OBJECT_PREFIX), (Object)"/1234567890/renders/");
            }
        }
    }

    private void verifyGCSVirtualDir(String s3Scheme, String path, AtlasEntity entity) {
        String entityQName;
        String pathQName = path + "/" + QNAME_METADATA_NAMESPACE;
        if (pathQName.equalsIgnoreCase(entityQName = (String)entity.getAttribute(ATTRIBUTE_QUALIFIED_NAME))) {
            Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_NAME), (Object)"data");
            Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_OBJECT_PREFIX), (Object)"/1234567890/");
        } else {
            pathQName = s3Scheme + "gcs_test_bucket1/1234567890/" + QNAME_METADATA_NAMESPACE;
            Assert.assertEquals((String)entityQName, (String)pathQName);
            Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_NAME), (Object)"1234567890");
            Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_OBJECT_PREFIX), (Object)"/");
        }
    }

    private void verifyS3V2KnownEntities(String scheme, String path, Map<String, AtlasEntity> knownEntities) {
        Assert.assertEquals((int)knownEntities.size(), (int)4);
        int dirCount = 0;
        for (AtlasEntity knownEntity : knownEntities.values()) {
            switch (knownEntity.getTypeName()) {
                case "aws_s3_v2_directory": {
                    this.verifyS3V2PseudoDir(scheme, path, knownEntity);
                    ++dirCount;
                    break;
                }
                case "aws_s3_v2_bucket": {
                    this.verifyS3BucketEntity(scheme, knownEntity);
                }
            }
        }
        Assert.assertEquals((int)dirCount, (int)3);
    }

    private void verifyS3PseudoDir(String path, AtlasEntity entity) {
        Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_QUALIFIED_NAME), (Object)(path.toLowerCase() + QNAME_METADATA_NAMESPACE));
        Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_NAME), (Object)"/1234567890/renders/irradiance_a.csv");
        Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_OBJECT_PREFIX), (Object)"/1234567890/renders/irradiance_a.csv");
    }

    private void verifyS3KnownEntities(String scheme, String path, Map<String, AtlasEntity> knownEntities) {
        Assert.assertEquals((int)knownEntities.size(), (int)2);
        int dirCount = 0;
        for (AtlasEntity knownEntity : knownEntities.values()) {
            switch (knownEntity.getTypeName()) {
                case "aws_s3_pseudo_dir": {
                    this.verifyS3PseudoDir(path, knownEntity);
                    ++dirCount;
                    break;
                }
                case "aws_s3_bucket": {
                    this.verifyS3BucketEntity(scheme, knownEntity);
                }
            }
        }
        Assert.assertEquals((int)dirCount, (int)1);
    }

    private void verifyS3BucketEntity(String scheme, AtlasEntity entity) {
        Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_QUALIFIED_NAME), (Object)(scheme + "aws_my_bucket1" + QNAME_METADATA_NAMESPACE));
        Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_NAME), (Object)"aws_my_bucket1");
    }

    private void verifyGCSKnownEntities(String scheme, String path, Map<String, AtlasEntity> knownEntities) {
        Assert.assertEquals((int)knownEntities.size(), (int)3);
        int dirCount = 0;
        for (AtlasEntity knownEntity : knownEntities.values()) {
            switch (knownEntity.getTypeName()) {
                case "gcp_storage_virtual_directory": {
                    this.verifyGCSVirtualDir(scheme, path, knownEntity);
                    ++dirCount;
                    break;
                }
                case "gcp_storage_bucket": {
                    this.verifyGCSBucketEntity(scheme, knownEntity);
                }
            }
        }
        Assert.assertEquals((int)dirCount, (int)2);
    }

    private void verifyGCSBucketEntity(String scheme, AtlasEntity entity) {
        Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_QUALIFIED_NAME), (Object)(scheme + "gcs_test_bucket1" + QNAME_METADATA_NAMESPACE));
        Assert.assertEquals((Object)entity.getAttribute(ATTRIBUTE_NAME), (Object)"gcs_test_bucket1");
    }

    private static class OzoneKeyValidator {
        private final String scheme;
        private final String location;
        private final int knownEntitiesCountTillKey;
        private final int knownEntitiesCountTillBucket;
        private final int knownEntitiesCountTillVolume;
        private final Map<String, String> nameQNamePairs;

        public OzoneKeyValidator(String scheme, String location, String ... pairs) {
            this.scheme = scheme;
            this.location = location;
            this.nameQNamePairs = this.getPairMap(scheme, pairs);
            this.knownEntitiesCountTillKey = this.nameQNamePairs.size() + 2;
            this.knownEntitiesCountTillBucket = this.nameQNamePairs.size() + 1;
            this.knownEntitiesCountTillVolume = this.nameQNamePairs.size();
        }

        public boolean validateNameQName(AtlasEntity entity) {
            String qName = (String)entity.getAttribute(AtlasPathExtractorUtilTest.ATTRIBUTE_QUALIFIED_NAME);
            for (Map.Entry<String, String> nameQName : this.nameQNamePairs.entrySet()) {
                if (!qName.equals(nameQName.getValue())) continue;
                return true;
            }
            return false;
        }

        private Map<String, String> getPairMap(String scheme, String ... pairs) {
            HashMap<String, String> ret = new HashMap<String, String>();
            for (int i = 0; i < pairs.length; i += 2) {
                ret.put(pairs[i], scheme + pairs[i + 1] + AtlasPathExtractorUtilTest.QNAME_METADATA_NAMESPACE);
            }
            return ret;
        }
    }
}

