/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.ha;

import java.util.List;
import org.apache.atlas.ha.HAConfiguration;
import org.apache.commons.configuration.Configuration;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HAConfigurationTest {
    private static final String[] TEST_ATLAS_SERVER_IDS_HA = new String[]{"id1", "id2"};
    @Mock
    private Configuration configuration;

    @BeforeMethod
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        System.setProperty("atlas.app.port", "21000");
    }

    @Test
    public void testIsHAEnabledByLegacyConfiguration() {
        Mockito.when((Object)this.configuration.containsKey("atlas.server.ha.enabled")).thenReturn((Object)true);
        Mockito.when((Object)this.configuration.getBoolean("atlas.server.ha.enabled")).thenReturn((Object)Boolean.TRUE);
        boolean isHAEnabled = HAConfiguration.isHAEnabled((Configuration)this.configuration);
        Assert.assertTrue((boolean)isHAEnabled);
        Mockito.when((Object)this.configuration.containsKey("atlas.server.ha.enabled")).thenReturn((Object)false);
        isHAEnabled = HAConfiguration.isHAEnabled((Configuration)this.configuration);
        Assert.assertFalse((boolean)isHAEnabled);
    }

    @Test
    public void testIsHAEnabledByIds() {
        Mockito.when((Object)this.configuration.containsKey("atlas.server.ha.enabled")).thenReturn((Object)false);
        Mockito.when((Object)this.configuration.getStringArray("atlas.server.ids")).thenReturn((Object)TEST_ATLAS_SERVER_IDS_HA);
        boolean isHAEnabled = HAConfiguration.isHAEnabled((Configuration)this.configuration);
        Assert.assertTrue((boolean)isHAEnabled);
        Mockito.when((Object)this.configuration.getStringArray("atlas.server.ids")).thenReturn((Object)new String[]{"id1"});
        isHAEnabled = HAConfiguration.isHAEnabled((Configuration)this.configuration);
        Assert.assertFalse((boolean)isHAEnabled);
    }

    @Test
    public void testShouldReturnHTTPSBoundAddress() {
        Mockito.when((Object)this.configuration.getString("atlas.server.address.id1")).thenReturn((Object)"127.0.0.1:21443");
        Mockito.when((Object)this.configuration.getBoolean("atlas.enableTLS")).thenReturn((Object)true);
        String address = HAConfiguration.getBoundAddressForId((Configuration)this.configuration, (String)"id1");
        Assert.assertEquals((String)address, (String)"https://127.0.0.1:21443");
    }

    @Test
    public void testShouldReturnListOfAddressesInConfig() {
        Mockito.when((Object)this.configuration.getStringArray("atlas.server.ids")).thenReturn((Object)TEST_ATLAS_SERVER_IDS_HA);
        Mockito.when((Object)this.configuration.getString("atlas.server.address.id1")).thenReturn((Object)"127.0.0.1:21000");
        Mockito.when((Object)this.configuration.getString("atlas.server.address.id2")).thenReturn((Object)"127.0.0.1:31000");
        List serverInstances = HAConfiguration.getServerInstances((Configuration)this.configuration);
        Assert.assertEquals((int)serverInstances.size(), (int)2);
        Assert.assertTrue((boolean)serverInstances.contains("http://127.0.0.1:21000"));
        Assert.assertTrue((boolean)serverInstances.contains("http://127.0.0.1:31000"));
    }

    @Test
    public void testShouldGetZookeeperAcl() {
        Mockito.when((Object)this.configuration.getString("atlas.server.ha.zookeeper.acl")).thenReturn((Object)"sasl:myclient@EXAMPLE.COM");
        HAConfiguration.ZookeeperProperties zookeeperProperties = HAConfiguration.getZookeeperProperties((Configuration)this.configuration);
        Assert.assertTrue((boolean)zookeeperProperties.hasAcl());
    }

    @Test
    public void testShouldGetZookeeperAuth() {
        Mockito.when((Object)this.configuration.getString("atlas.server.ha.zookeeper.auth")).thenReturn((Object)"sasl:myclient@EXAMPLE.COM");
        HAConfiguration.ZookeeperProperties zookeeperProperties = HAConfiguration.getZookeeperProperties((Configuration)this.configuration);
        Assert.assertTrue((boolean)zookeeperProperties.hasAuth());
    }
}

