/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class AtlasPerfMetrics {
    private final Map<String, Metric> metrics = new LinkedHashMap<String, Metric>();
    private long startTimeMs = -1L;

    public MetricRecorder getMetricRecorder(String name) {
        return new MetricRecorder(name);
    }

    public void recordMetric(MetricRecorder recorder) {
        if (recorder != null) {
            Metric metric;
            String name = recorder.name;
            long timeTaken = recorder.getElapsedTime();
            if (this.startTimeMs == -1L) {
                this.startTimeMs = System.currentTimeMillis();
            }
            if ((metric = this.metrics.get(name)) == null) {
                metric = new Metric(name);
                this.metrics.put(name, metric);
            }
            Metric.access$108(metric);
            metric.totalTimeMSecs += timeTaken;
        }
    }

    public void clear() {
        this.metrics.clear();
        this.startTimeMs = -1L;
    }

    public boolean isEmpty() {
        return this.metrics.isEmpty();
    }

    public Set<String> getMetricsNames() {
        return this.metrics.keySet();
    }

    public Metric getMetric(String name) {
        return this.metrics.get(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (!this.metrics.isEmpty()) {
            for (Metric metric : this.metrics.values()) {
                sb.append("\"").append(metric.getName()).append("\":{\"count\":").append(metric.getInvocations()).append(",\"timeTaken\":").append(metric.getTotalTimeMSecs()).append("},");
            }
            sb.append("\"totalTime\":").append(System.currentTimeMillis() - this.startTimeMs);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetricRecorder {
        private final String name;
        private final long startTimeMs = System.currentTimeMillis();

        MetricRecorder(String name) {
            this.name = name;
        }

        long getElapsedTime() {
            return System.currentTimeMillis() - this.startTimeMs;
        }
    }

    public static class Metric {
        private final String name;
        private short invocations = 0;
        private long totalTimeMSecs = 0L;

        public Metric(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public short getInvocations() {
            return this.invocations;
        }

        public long getTotalTimeMSecs() {
            return this.totalTimeMSecs;
        }

        static /* synthetic */ short access$108(Metric x0) {
            short s = x0.invocations;
            x0.invocations = (short)(s + 1);
            return s;
        }
    }
}

