/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.utils.LruCache;
import org.apache.commons.lang.RandomStringUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class LruCacheTest {
    @Test
    public void testBasicOps() throws Exception {
        LruCache cache = new LruCache(1000, 0);
        String h1 = this.createHandle("s1::", "1::");
        String q1 = this.createQuery();
        String h2 = this.createHandle("s1::", "2::");
        String q2 = this.createQuery();
        String h3 = this.createHandle("s2::", "1::");
        String q3 = this.createQuery();
        String h4 = this.createHandle("s1::", "3::");
        String q4 = this.createQuery();
        String h5 = this.createHandle("s3::", null);
        String q5 = this.createQuery();
        String h5b = this.createHandle("s3::", null);
        String q5b = this.createQuery();
        String h6 = this.createHandle(null, "3::");
        String q6 = this.createQuery();
        String h6b = this.createHandle(null, "3::");
        String q6b = this.createQuery();
        cache.put((Object)h1, (Object)q1);
        cache.put((Object)h2, (Object)q2);
        cache.put((Object)h3, (Object)q3);
        cache.put((Object)h4, (Object)q4);
        cache.put((Object)h5, (Object)q5);
        cache.put((Object)h6, (Object)q6);
        Assert.assertEquals((String)((String)cache.get((Object)h1)), (String)q1);
        Assert.assertEquals((String)((String)cache.get((Object)h2)), (String)q2);
        Assert.assertEquals((String)((String)cache.get((Object)h3)), (String)q3);
        Assert.assertEquals((String)((String)cache.get((Object)h4)), (String)q4);
        Assert.assertEquals((String)((String)cache.get((Object)h5)), (String)q5);
        Assert.assertEquals((String)((String)cache.remove((Object)h1)), (String)q1);
        Assert.assertEquals((String)((String)cache.remove((Object)h2)), (String)q2);
        Assert.assertEquals((String)((String)cache.remove((Object)h3)), (String)q3);
        Assert.assertEquals((String)((String)cache.remove((Object)h4)), (String)q4);
        Assert.assertEquals((String)((String)cache.remove((Object)h5)), (String)q5);
        Assert.assertNull((Object)cache.remove((Object)h5b));
        Assert.assertEquals((String)q6, (String)((String)cache.remove((Object)h6)));
        Assert.assertNull((Object)cache.remove((Object)h6b));
        cache.put((Object)h5b, (Object)q5b);
        cache.put((Object)h6b, (Object)q6b);
        Assert.assertEquals((String)q5b, (String)((String)cache.remove((Object)h5)));
        Assert.assertNull((Object)cache.remove((Object)h5b));
        Assert.assertEquals((String)q6b, (String)((String)cache.remove((Object)h6)));
        Assert.assertNull((Object)cache.remove((Object)h6b));
    }

    @Test
    public void testMapOperations() {
        HashMap<String, String> reference = new HashMap<String, String>();
        reference.put("name", "Fred");
        reference.put("occupation", "student");
        reference.put("height", "5'11");
        reference.put("City", "Littleton");
        reference.put("State", "MA");
        LruCache map = new LruCache(10, 10);
        map.putAll(reference);
        Assert.assertEquals((int)map.size(), (int)reference.size());
        Assert.assertEquals((int)map.keySet().size(), (int)reference.keySet().size());
        Assert.assertTrue((boolean)map.keySet().containsAll(reference.keySet()));
        Assert.assertTrue((boolean)reference.keySet().containsAll(map.keySet()));
        Assert.assertEquals((int)reference.entrySet().size(), (int)map.entrySet().size());
        for (Map.Entry entry : map.entrySet()) {
            Assert.assertTrue((boolean)reference.containsKey(entry.getKey()));
            Assert.assertEquals((String)((String)entry.getValue()), (String)((String)reference.get(entry.getKey())));
            Assert.assertTrue((boolean)map.containsKey(entry.getKey()));
            Assert.assertTrue((boolean)map.containsValue(entry.getValue()));
            Assert.assertTrue((boolean)map.values().contains(entry.getValue()));
        }
        Assert.assertTrue((boolean)reference.equals(map));
        Assert.assertTrue((boolean)map.equals(reference));
    }

    @Test
    public void testReplaceValueInMap() {
        LruCache map = new LruCache(10, 10);
        map.put((Object)"name", (Object)"Fred");
        map.put((Object)"name", (Object)"George");
        Assert.assertEquals((String)((String)map.get((Object)"name")), (String)"George");
        Assert.assertEquals((int)map.size(), (int)1);
    }

    @Test
    public void testOrderUpdatedWhenAddExisting() {
        LruCache map = new LruCache(2, 10);
        map.put((Object)"name", (Object)"Fred");
        map.put((Object)"age", (Object)"15");
        map.put((Object)"name", (Object)"George");
        map.put((Object)"height", (Object)"5'3\"");
        Assert.assertFalse((boolean)map.containsKey((Object)"age"));
    }

    @Test
    public void testMapRemove() {
        LruCache map = new LruCache(10, 10);
        map.put((Object)"name", (Object)"Fred");
        map.put((Object)"occupation", (Object)"student");
        map.put((Object)"height", (Object)"5'11");
        map.put((Object)"City", (Object)"Littleton");
        map.put((Object)"State", (Object)"MA");
        this.assertMapHasSize((LruCache<String, String>)map, 5);
        Assert.assertTrue((boolean)map.containsKey((Object)"State"));
        map.remove((Object)"State");
        this.assertMapHasSize((LruCache<String, String>)map, 4);
        Assert.assertFalse((boolean)map.containsKey((Object)"State"));
    }

    private void assertMapHasSize(LruCache<String, String> map, int size) {
        Assert.assertEquals((int)map.size(), (int)size);
        Assert.assertEquals((int)map.keySet().size(), (int)size);
        Assert.assertEquals((int)map.values().size(), (int)size);
        Assert.assertEquals((int)map.entrySet().size(), (int)size);
    }

    @Test
    public void testEvict() {
        LruCache map = new LruCache(5, 10);
        map.put((Object)"name", (Object)"Fred");
        map.put((Object)"occupation", (Object)"student");
        map.put((Object)"height", (Object)"5'11");
        map.put((Object)"City", (Object)"Littleton");
        map.put((Object)"State", (Object)"MA");
        this.assertMapHasSize((LruCache<String, String>)map, 5);
        Assert.assertTrue((boolean)map.containsKey((Object)"name"));
        map.put((Object)"zip", (Object)"01460");
        Assert.assertFalse((boolean)map.containsKey((Object)"name"));
        this.assertMapHasSize((LruCache<String, String>)map, 5);
        map.get((Object)"occupation");
        Assert.assertTrue((boolean)map.containsKey((Object)"height"));
        map.put((Object)"country", (Object)"USA");
        Assert.assertFalse((boolean)map.containsKey((Object)"height"));
        this.assertMapHasSize((LruCache<String, String>)map, 5);
    }

    private String createHandle(String s1, String s2) {
        return s1 + ": " + s2 + ":select x from x in y";
    }

    private String createQuery() {
        return RandomStringUtils.randomAlphabetic((int)10);
    }
}

