/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.atlas.AtlasBaseClient;
import org.apache.atlas.AtlasException;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.EntityAuditEvent;
import org.apache.atlas.ResourceCreator;
import org.apache.atlas.model.legacy.EntityResult;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.utils.AtlasJson;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.atlas.v1.model.instance.Struct;
import org.apache.atlas.v1.model.typedef.AttributeDefinition;
import org.apache.atlas.v1.model.typedef.TraitTypeDefinition;
import org.apache.atlas.v1.model.typedef.TypesDef;
import org.apache.atlas.v1.typesystem.types.utils.TypesUtil;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AtlasClient
extends AtlasBaseClient {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasClient.class);
    public static final String TYPE = "type";
    public static final String TYPENAME = "typeName";
    public static final String GUID = "GUID";
    public static final String ENTITIES = "entities";
    public static final String GUID_ASSIGNMENTS = "guidAssignments";
    public static final String DEFINITION = "definition";
    public static final String ERROR = "error";
    public static final String STACKTRACE = "stackTrace";
    public static final String REQUEST_ID = "requestId";
    public static final String RESULTS = "results";
    public static final String COUNT = "count";
    public static final String ROWS = "rows";
    public static final String DATATYPE = "dataType";
    public static final String STATUS = "Status";
    public static final String EVENTS = "events";
    public static final String START_KEY = "startKey";
    public static final String NUM_RESULTS = "count";
    public static final String URI_ENTITY = "entities";
    public static final String URI_ENTITY_AUDIT = "audit";
    public static final String URI_SEARCH = "discovery/search";
    public static final String URI_NAME_LINEAGE = "lineage/hive/table";
    public static final String URI_LINEAGE = "lineage/";
    public static final String URI_TRAITS = "traits";
    public static final String TRAITS = "traits";
    public static final String TRAIT_DEFINITIONS = "traitDefinitions";
    public static final String QUERY_TYPE = "queryType";
    public static final String ATTRIBUTE_NAME = "property";
    public static final String ATTRIBUTE_VALUE = "value";
    public static final String SUPERTYPE = "supertype";
    public static final String NOT_SUPERTYPE = "notsupertype";
    public static final String ASSET_TYPE = "Asset";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String OWNER = "owner";
    public static final String CREATE_TIME = "createTime";
    public static final String INFRASTRUCTURE_SUPER_TYPE = "Infrastructure";
    public static final String DATA_SET_SUPER_TYPE = "DataSet";
    public static final String PROCESS_SUPER_TYPE = "Process";
    public static final String PROCESS_ATTRIBUTE_INPUTS = "inputs";
    public static final String PROCESS_ATTRIBUTE_OUTPUTS = "outputs";
    public static final String REFERENCEABLE_SUPER_TYPE = "Referenceable";
    public static final String QUALIFIED_NAME = "qualifiedName";
    public static final String REFERENCEABLE_ATTRIBUTE_NAME = "qualifiedName";
    public static final String UNKNOWN_STATUS = "Unknown status";

    public AtlasClient(String[] baseUrl, String cookieName, String value, String path, String domain) {
        super(baseUrl, new Cookie(cookieName, value, path, domain));
    }

    public AtlasClient(String[] baseUrl, Cookie cookie) {
        super(baseUrl, cookie);
    }

    public AtlasClient(String[] baseUrl, String[] basicAuthUserNamePassword) {
        super(baseUrl, basicAuthUserNamePassword);
    }

    public AtlasClient(String ... baseUrls) throws AtlasException {
        this(AtlasClient.getCurrentUGI(), baseUrls);
    }

    public AtlasClient(UserGroupInformation ugi, String doAsUser, String ... baseUrls) {
        this.initializeState(baseUrls, ugi, doAsUser);
    }

    private AtlasClient(UserGroupInformation ugi, String[] baseUrls) {
        this(ugi, ugi.getShortUserName(), baseUrls);
    }

    protected AtlasClient() {
    }

    @VisibleForTesting
    public AtlasClient(Configuration configuration, String[] baseUrl, String[] basicAuthUserNamePassword) {
        super(configuration, baseUrl, basicAuthUserNamePassword);
    }

    protected AtlasBaseClient.API formatPathParameters(AtlasBaseClient.API api, String ... params) {
        return new AtlasBaseClient.API(String.format(api.getPath(), params), api.getMethod(), api.getExpectedStatus());
    }

    @VisibleForTesting
    public AtlasClient(Configuration configuration, String ... baseUrls) throws AtlasException {
        this.initializeState(configuration, baseUrls, AtlasClient.getCurrentUGI(), AtlasClient.getCurrentUGI().getShortUserName());
    }

    @VisibleForTesting
    AtlasClient(WebResource service, Configuration configuration) {
        super(service, configuration);
    }

    public WebResource getResource() {
        return this.service;
    }

    public List<String> createType(String typeAsJson) throws AtlasServiceException {
        LOG.debug("Creating type definition: {}", (Object)typeAsJson);
        ObjectNode response = this.callAPIWithBody(API_V1.CREATE_TYPE, (Object)typeAsJson);
        List<String> results = this.extractResults(response, "types", new ExtractOperation<String, ObjectNode>(){

            @Override
            String extractElement(ObjectNode element) {
                return element.get(AtlasClient.NAME).asText();
            }
        });
        LOG.debug("Create type definition returned results: {}", results);
        return results;
    }

    public List<String> createType(TypesDef typeDef) throws AtlasServiceException {
        return this.createType(AtlasType.toV1Json((Object)typeDef));
    }

    public List<String> createTraitType(String traitName, Set<String> superTraits, AttributeDefinition ... attributeDefinitions) throws AtlasServiceException {
        TraitTypeDefinition piiTrait = TypesUtil.createTraitTypeDef((String)traitName, null, superTraits, Arrays.asList(attributeDefinitions));
        TypesDef typesDef = new TypesDef(Collections.emptyList(), Collections.emptyList(), Collections.singletonList(piiTrait), Collections.emptyList());
        LOG.debug("Creating trait type {} {}", (Object)traitName, (Object)AtlasType.toV1Json((Object)piiTrait));
        return this.createType(AtlasType.toV1Json((Object)typesDef));
    }

    public List<String> createTraitType(String traitName) throws AtlasServiceException {
        return this.createTraitType(traitName, null, new AttributeDefinition[0]);
    }

    public List<String> updateType(String typeAsJson) throws AtlasServiceException {
        LOG.debug("Updating type definition: {}", (Object)typeAsJson);
        ObjectNode response = this.callAPIWithBody(API_V1.UPDATE_TYPE, (Object)typeAsJson);
        List<String> results = this.extractResults(response, "types", new ExtractOperation<String, ObjectNode>(){

            @Override
            String extractElement(ObjectNode element) {
                return element.get(AtlasClient.NAME).asText();
            }
        });
        LOG.debug("Update type definition returned results: {}", results);
        return results;
    }

    public List<String> updateType(TypesDef typeDef) throws AtlasServiceException {
        return this.updateType(AtlasType.toV1Json((Object)typeDef));
    }

    public List<String> listTypes() throws AtlasServiceException {
        ObjectNode jsonResponse = this.callAPIWithQueryParams(API_V1.LIST_TYPES, (MultivaluedMap<String, String>)null);
        return this.extractStringList(jsonResponse);
    }

    public List<String> listTypes(final DataTypes.TypeCategory category) throws AtlasServiceException {
        final API_V1 api = API_V1.LIST_TYPES;
        ObjectNode response = this.callAPIWithRetries((AtlasBaseClient.API)api, null, new ResourceCreator(){

            public WebResource createResource() {
                WebResource resource = AtlasClient.this.getResource(api.getNormalizedPath(), new String[0]);
                resource = resource.queryParam(AtlasClient.TYPE, category.name());
                return resource;
            }
        });
        return this.extractResults(response, RESULTS, new ExtractOperation());
    }

    public List<String> listTypes(final DataTypes.TypeCategory category, final String superType, final String notSupertype) throws AtlasServiceException {
        final API_V1 api = API_V1.LIST_TYPES;
        ObjectNode response = this.callAPIWithRetries((AtlasBaseClient.API)api, null, new ResourceCreator(){

            public WebResource createResource() {
                WebResource resource = AtlasClient.this.getResource(api, new String[0]);
                resource = resource.queryParam(AtlasClient.TYPE, category.name());
                resource = resource.queryParam(AtlasClient.SUPERTYPE, superType);
                resource = resource.queryParam(AtlasClient.NOT_SUPERTYPE, notSupertype);
                return resource;
            }
        });
        return this.extractStringList(response);
    }

    public TypesDef getType(String typeName) throws AtlasServiceException {
        ObjectNode response = this.callAPIWithBodyAndParams(API_V1.GET_TYPE, (Object)null, typeName);
        String typeJson = AtlasType.toJson((Object)response.get(DEFINITION));
        return (TypesDef)AtlasType.fromV1Json((String)typeJson, TypesDef.class);
    }

    protected List<String> createEntity(ArrayNode entities) throws AtlasServiceException {
        LOG.debug("Creating entities: {}", (Object)entities);
        ObjectNode response = this.callAPIWithBody(API_V1.CREATE_ENTITY, (Object)entities.toString());
        List results = this.extractEntityResult(response).getCreatedEntities();
        LOG.debug("Create entities returned results: {}", (Object)results);
        return results;
    }

    protected EntityResult extractEntityResult(ObjectNode response) throws AtlasServiceException {
        return EntityResult.fromString((String)response.toString());
    }

    public List<String> createEntity(String ... entitiesAsJson) throws AtlasServiceException {
        try {
            return this.createEntity(AtlasJson.parseToV1ArrayNode(Arrays.asList(entitiesAsJson)));
        }
        catch (IOException excp) {
            throw new AtlasServiceException((Exception)excp);
        }
    }

    public List<String> createEntity(Referenceable ... entities) throws AtlasServiceException {
        return this.createEntity(Arrays.asList(entities));
    }

    public List<String> createEntity(Collection<Referenceable> entities) throws AtlasServiceException {
        ArrayNode entityArray = this.getEntitiesArray(entities);
        return this.createEntity(entityArray);
    }

    private ArrayNode getEntitiesArray(Collection<Referenceable> entities) {
        ArrayNode entityArray = AtlasJson.createV1ArrayNode();
        for (Referenceable entity : entities) {
            entityArray.add(AtlasType.toV1Json((Object)entity));
        }
        return entityArray;
    }

    public EntityResult updateEntities(Referenceable ... entities) throws AtlasServiceException {
        return this.updateEntities(Arrays.asList(entities));
    }

    protected EntityResult updateEntities(ArrayNode entities) throws AtlasServiceException {
        LOG.debug("Updating entities: {}", (Object)entities);
        ObjectNode response = this.callAPIWithBody(API_V1.UPDATE_ENTITY, (Object)entities.toString());
        EntityResult results = this.extractEntityResult(response);
        LOG.debug("Update entities returned results: {}", (Object)results);
        return results;
    }

    public EntityResult updateEntities(Collection<Referenceable> entities) throws AtlasServiceException {
        ArrayNode entitiesArray = this.getEntitiesArray(entities);
        return this.updateEntities(entitiesArray);
    }

    public EntityResult updateEntityAttribute(final String guid, final String attribute, String value) throws AtlasServiceException {
        LOG.debug("Updating entity id: {}, attribute name: {}, attribute value: {}", new Object[]{guid, attribute, value});
        final API_V1 api = API_V1.UPDATE_ENTITY_PARTIAL;
        ObjectNode response = this.callAPIWithRetries((AtlasBaseClient.API)api, (Object)value, new ResourceCreator(){

            public WebResource createResource() {
                WebResource resource = AtlasClient.this.getResource(api, guid);
                resource = resource.queryParam(AtlasClient.ATTRIBUTE_NAME, attribute);
                return resource;
            }
        });
        return this.extractEntityResult(response);
    }

    public EntityResult updateEntity(String guid, Referenceable entity) throws AtlasServiceException {
        String entityJson = AtlasType.toV1Json((Object)entity);
        LOG.debug("Updating entity id {} with {}", (Object)guid, (Object)entityJson);
        ObjectNode response = this.callAPIWithBodyAndParams(API_V1.UPDATE_ENTITY_PARTIAL, (Object)entityJson, guid);
        return this.extractEntityResult(response);
    }

    public void addTrait(String guid, Struct traitDefinition) throws AtlasServiceException {
        String traitJson = AtlasType.toV1Json((Object)traitDefinition);
        LOG.debug("Adding trait to entity with id {} {}", (Object)guid, (Object)traitJson);
        this.callAPIWithBodyAndParams(API_V1.ADD_TRAITS, (Object)traitJson, guid, "traits");
    }

    public void deleteTrait(String guid, String traitName) throws AtlasServiceException {
        this.callAPIWithBodyAndParams(API_V1.DELETE_TRAITS, (Object)null, guid, "traits", traitName);
    }

    public EntityResult updateEntity(final String entityType, final String uniqueAttributeName, final String uniqueAttributeValue, Referenceable entity) throws AtlasServiceException {
        final API_V1 api = API_V1.UPDATE_ENTITY_PARTIAL;
        String entityJson = AtlasType.toV1Json((Object)entity);
        LOG.debug("Updating entity type: {}, attributeName: {}, attributeValue: {}, entity: {}", new Object[]{entityType, uniqueAttributeName, uniqueAttributeValue, entityJson});
        ObjectNode response = this.callAPIWithRetries((AtlasBaseClient.API)api, (Object)entityJson, new ResourceCreator(){

            public WebResource createResource() {
                WebResource resource = AtlasClient.this.getResource(api, "qualifiedName");
                resource = resource.queryParam(AtlasClient.TYPE, entityType);
                resource = resource.queryParam(AtlasClient.ATTRIBUTE_NAME, uniqueAttributeName);
                resource = resource.queryParam(AtlasClient.ATTRIBUTE_VALUE, uniqueAttributeValue);
                return resource;
            }
        });
        EntityResult result = this.extractEntityResult(response);
        LOG.debug("Update entity returned result: {}", (Object)result);
        return result;
    }

    protected String getString(ObjectNode jsonObject, String parameter) throws AtlasServiceException {
        return jsonObject.get(parameter).asText();
    }

    public EntityResult deleteEntities(final String ... guids) throws AtlasServiceException {
        LOG.debug("Deleting entities: {}", (Object[])guids);
        final API_V1 api = API_V1.DELETE_ENTITIES;
        ObjectNode jsonResponse = this.callAPIWithRetries((AtlasBaseClient.API)api, null, new ResourceCreator(){

            public WebResource createResource() {
                WebResource resource = AtlasClient.this.getResource(api, new String[0]);
                for (String guid : guids) {
                    resource = resource.queryParam(AtlasClient.GUID.toLowerCase(), guid);
                }
                return resource;
            }
        });
        EntityResult results = this.extractEntityResult(jsonResponse);
        LOG.debug("Delete entities returned results: {}", (Object)results);
        return results;
    }

    public EntityResult deleteEntity(String entityType, String uniqueAttributeName, String uniqueAttributeValue) throws AtlasServiceException {
        LOG.debug("Deleting entity type: {}, attributeName: {}, attributeValue: {}", new Object[]{entityType, uniqueAttributeName, uniqueAttributeValue});
        API_V1 api = API_V1.DELETE_ENTITIES;
        WebResource resource = this.getResource((AtlasBaseClient.API)api, new String[0]);
        resource = resource.queryParam(TYPE, entityType);
        resource = resource.queryParam(ATTRIBUTE_NAME, uniqueAttributeName);
        resource = resource.queryParam(ATTRIBUTE_VALUE, uniqueAttributeValue);
        ObjectNode jsonResponse = this.callAPIWithResource((AtlasBaseClient.API)api, resource);
        EntityResult results = this.extractEntityResult(jsonResponse);
        LOG.debug("Delete entities returned results: {}", (Object)results);
        return results;
    }

    public Referenceable getEntity(String guid) throws AtlasServiceException {
        ObjectNode jsonResponse = this.callAPIWithBodyAndParams(API_V1.GET_ENTITY, (Object)null, guid);
        String entityInstanceDefinition = AtlasType.toJson((Object)jsonResponse.get(DEFINITION));
        return (Referenceable)AtlasType.fromV1Json((String)entityInstanceDefinition, Referenceable.class);
    }

    public static String toString(ArrayNode jsonArray) {
        ArrayList<String> resultsList = new ArrayList<String>();
        for (int index = 0; index < jsonArray.size(); ++index) {
            resultsList.add(jsonArray.get(index).asText());
        }
        return StringUtils.join(resultsList, (String)",");
    }

    public Referenceable getEntity(final String entityType, final String attribute, final String value) throws AtlasServiceException {
        final API_V1 api = API_V1.GET_ENTITY;
        ObjectNode jsonResponse = this.callAPIWithRetries((AtlasBaseClient.API)api, null, new ResourceCreator(){

            public WebResource createResource() {
                WebResource resource = AtlasClient.this.getResource(api, new String[0]);
                resource = resource.queryParam(AtlasClient.TYPE, entityType);
                resource = resource.queryParam(AtlasClient.ATTRIBUTE_NAME, attribute);
                resource = resource.queryParam(AtlasClient.ATTRIBUTE_VALUE, value);
                return resource;
            }
        });
        String entityInstanceDefinition = AtlasType.toJson((Object)jsonResponse.get(DEFINITION));
        return (Referenceable)AtlasType.fromV1Json((String)entityInstanceDefinition, Referenceable.class);
    }

    public List<String> listEntities(final String entityType) throws AtlasServiceException {
        ObjectNode jsonResponse = this.callAPIWithRetries(API_V1.LIST_ENTITIES, (Object)null, new ResourceCreator(){

            public WebResource createResource() {
                WebResource resource = AtlasClient.this.getResource(API_V1.LIST_ENTITIES, new String[0]);
                resource = resource.queryParam(AtlasClient.TYPE, entityType);
                return resource;
            }
        });
        return this.extractStringList(jsonResponse);
    }

    public List<String> listTraits(String guid) throws AtlasServiceException {
        ObjectNode jsonResponse = this.callAPIWithBodyAndParams(API_V1.LIST_TRAITS, (Object)null, guid, "traits");
        return this.extractStringList(jsonResponse);
    }

    public List<Struct> listTraitDefinitions(String guid) throws AtlasServiceException {
        ObjectNode jsonResponse = this.callAPIWithBodyAndParams(API_V1.GET_ALL_TRAIT_DEFINITIONS, (Object)null, guid, TRAIT_DEFINITIONS);
        List traitDefList = this.extractResults(jsonResponse, RESULTS, new ExtractOperation());
        ArrayList<Struct> traitStructList = new ArrayList<Struct>();
        for (ObjectNode traitDef : traitDefList) {
            Struct traitStruct = (Struct)AtlasType.fromV1Json((String)traitDef.toString(), Struct.class);
            traitStructList.add(traitStruct);
        }
        return traitStructList;
    }

    public Struct getTraitDefinition(String guid, String traitName) throws AtlasServiceException {
        ObjectNode jsonResponse = this.callAPIWithBodyAndParams(API_V1.GET_TRAIT_DEFINITION, (Object)null, guid, TRAIT_DEFINITIONS, traitName);
        return (Struct)AtlasType.fromV1Json((String)AtlasType.toJson((Object)jsonResponse.get(RESULTS)), Struct.class);
    }

    protected <T, U> List<T> extractResults(ObjectNode jsonResponse, String key, ExtractOperation<T, U> extractInterafce) throws AtlasServiceException {
        ArrayNode results = (ArrayNode)jsonResponse.get(key);
        ArrayList<T> resultsList = new ArrayList<T>();
        for (int index = 0; index < results.size(); ++index) {
            JsonNode element = results.get(index);
            resultsList.add(extractInterafce.extractElement(element));
        }
        return resultsList;
    }

    public List<EntityAuditEvent> getEntityAuditEvents(String entityId, short numResults) throws AtlasServiceException {
        return this.getEntityAuditEvents(entityId, null, numResults);
    }

    public List<EntityAuditEvent> getEntityAuditEvents(String entityId, String startKey, short numResults) throws AtlasServiceException {
        WebResource resource = this.getResource(API_V1.LIST_ENTITY_AUDIT, entityId, URI_ENTITY_AUDIT);
        if (StringUtils.isNotEmpty((String)startKey)) {
            resource = resource.queryParam(START_KEY, startKey);
        }
        resource = resource.queryParam("count", String.valueOf(numResults));
        ObjectNode jsonResponse = this.callAPIWithResource(API_V1.LIST_ENTITY_AUDIT, resource);
        return this.extractResults(jsonResponse, EVENTS, new ExtractOperation<EntityAuditEvent, ObjectNode>(){

            @Override
            EntityAuditEvent extractElement(ObjectNode element) {
                return (EntityAuditEvent)AtlasType.fromV1Json((String)element.toString(), EntityAuditEvent.class);
            }
        });
    }

    public JsonNode search(final String searchQuery, final int limit, final int offset) throws AtlasServiceException {
        final API_V1 api = API_V1.SEARCH;
        ObjectNode result = this.callAPIWithRetries((AtlasBaseClient.API)api, null, new ResourceCreator(){

            public WebResource createResource() {
                WebResource resource = AtlasClient.this.getResource(api, new String[0]);
                resource = resource.queryParam("query", searchQuery);
                resource = resource.queryParam("limit", String.valueOf(limit));
                resource = resource.queryParam("offset", String.valueOf(offset));
                return resource;
            }
        });
        return result.get(RESULTS);
    }

    public ArrayNode searchByDSL(final String query, final int limit, final int offset) throws AtlasServiceException {
        LOG.debug("DSL query: {}", (Object)query);
        final API_V1 api = API_V1.SEARCH_DSL;
        ObjectNode response = this.callAPIWithRetries((AtlasBaseClient.API)api, null, new ResourceCreator(){

            public WebResource createResource() {
                WebResource resource = AtlasClient.this.getResource(api, new String[0]);
                resource = resource.queryParam("query", query);
                resource = resource.queryParam("limit", String.valueOf(limit));
                resource = resource.queryParam("offset", String.valueOf(offset));
                return resource;
            }
        });
        JsonNode results = response.get(RESULTS);
        return results.isNull() ? AtlasJson.createV1ArrayNode() : (ArrayNode)response.get(RESULTS);
    }

    public ObjectNode searchByFullText(final String query, final int limit, final int offset) throws AtlasServiceException {
        final API_V1 api = API_V1.SEARCH_FULL_TEXT;
        return this.callAPIWithRetries((AtlasBaseClient.API)api, null, new ResourceCreator(){

            public WebResource createResource() {
                WebResource resource = AtlasClient.this.getResource(api, new String[0]);
                resource = resource.queryParam("query", query);
                resource = resource.queryParam("limit", String.valueOf(limit));
                resource = resource.queryParam("offset", String.valueOf(offset));
                return resource;
            }
        });
    }

    public ObjectNode getInputGraph(String datasetName) throws AtlasServiceException {
        ObjectNode response = this.callAPIWithBodyAndParams(API_V1.NAME_LINEAGE_INPUTS_GRAPH, (Object)null, datasetName, "/inputs/graph");
        return (ObjectNode)response.get(RESULTS);
    }

    public ObjectNode getOutputGraph(String datasetName) throws AtlasServiceException {
        ObjectNode response = this.callAPIWithBodyAndParams(API_V1.NAME_LINEAGE_OUTPUTS_GRAPH, (Object)null, datasetName, "/outputs/graph");
        return (ObjectNode)response.get(RESULTS);
    }

    public ObjectNode getInputGraphForEntity(String entityId) throws AtlasServiceException {
        ObjectNode response = this.callAPIWithBodyAndParams(API_V1.LINEAGE_INPUTS_GRAPH, (Object)null, entityId, "/inputs/graph");
        return (ObjectNode)response.get(RESULTS);
    }

    public ObjectNode getOutputGraphForEntity(String datasetId) throws AtlasServiceException {
        ObjectNode response = this.callAPIWithBodyAndParams(API_V1.LINEAGE_OUTPUTS_GRAPH, (Object)null, datasetId, "/outputs/graph");
        return (ObjectNode)response.get(RESULTS);
    }

    public ObjectNode getSchemaForEntity(String datasetId) throws AtlasServiceException {
        ObjectNode response = this.callAPIWithBodyAndParams(API_V1.LINEAGE_OUTPUTS_GRAPH, (Object)null, datasetId, "/schema");
        return (ObjectNode)response.get(RESULTS);
    }

    private List<String> extractStringList(ObjectNode response) {
        JsonNode results;
        ArrayList<String> ret = new ArrayList<String>();
        JsonNode jsonNode = results = response != null ? response.get(RESULTS) : null;
        if (results != null && results instanceof ArrayNode) {
            for (JsonNode node : results) {
                ret.add(node.asText());
            }
        }
        return ret;
    }

    @VisibleForTesting
    public ObjectNode callAPIWithResource(AtlasBaseClient.API api, WebResource resource) throws AtlasServiceException {
        return (ObjectNode)this.callAPIWithResource(api, resource, null, ObjectNode.class);
    }

    @VisibleForTesting
    public ObjectNode callAPIWithResource(API_V1 apiV1, WebResource resource) throws AtlasServiceException {
        return (ObjectNode)this.callAPIWithResource(apiV1, resource, null, ObjectNode.class);
    }

    @VisibleForTesting
    public WebResource getResource(AtlasBaseClient.API api, String ... params) {
        return this.getResource(api.getNormalizedPath(), params);
    }

    @VisibleForTesting
    public WebResource getResource(API_V1 apiV1, String ... params) {
        return this.getResource(apiV1.getNormalizedPath(), params);
    }

    @VisibleForTesting
    public ObjectNode callAPIWithBody(AtlasBaseClient.API api, Object requestObject) throws AtlasServiceException {
        return (ObjectNode)this.callAPI(api, ObjectNode.class, requestObject, null);
    }

    @VisibleForTesting
    public ObjectNode callAPIWithBody(API_V1 apiV1, Object requestObject) throws AtlasServiceException {
        return (ObjectNode)this.callAPI(apiV1, ObjectNode.class, requestObject, null);
    }

    @VisibleForTesting
    public ObjectNode callAPIWithBodyAndParams(AtlasBaseClient.API api, Object requestObject, String ... params) throws AtlasServiceException {
        return (ObjectNode)this.callAPI(api, ObjectNode.class, requestObject, params);
    }

    @VisibleForTesting
    public ObjectNode callAPIWithBodyAndParams(API_V1 apiV1, Object requestObject, String ... params) throws AtlasServiceException {
        return (ObjectNode)this.callAPI(apiV1, ObjectNode.class, requestObject, params);
    }

    @VisibleForTesting
    public ObjectNode callAPIWithQueryParams(AtlasBaseClient.API api, MultivaluedMap<String, String> queryParams) throws AtlasServiceException {
        return (ObjectNode)this.callAPI(api, ObjectNode.class, queryParams);
    }

    @VisibleForTesting
    public ObjectNode callAPIWithQueryParams(API_V1 apiV1, MultivaluedMap<String, String> queryParams) throws AtlasServiceException {
        return (ObjectNode)this.callAPI(apiV1, ObjectNode.class, queryParams);
    }

    @VisibleForTesting
    ObjectNode callAPIWithRetries(AtlasBaseClient.API api, Object requestObject, ResourceCreator resourceCreator) throws AtlasServiceException {
        return super.callAPIWithRetries(api, requestObject, resourceCreator);
    }

    @VisibleForTesting
    ObjectNode callAPIWithRetries(API_V1 apiV1, Object requestObject, ResourceCreator resourceCreator) throws AtlasServiceException {
        return super.callAPIWithRetries((AtlasBaseClient.API)apiV1, requestObject, resourceCreator);
    }

    public static class API_V1
    extends AtlasBaseClient.API {
        public static final API_V1 VERSION = new API_V1("api/atlas/admin/version", "GET", Response.Status.OK);
        public static final API_V1 STATUS = new API_V1("api/atlas/admin/status", "GET", Response.Status.OK);
        public static final API_V1 CREATE_TYPE = new API_V1("api/atlas/types", "POST", Response.Status.CREATED);
        public static final API_V1 UPDATE_TYPE = new API_V1("api/atlas/types", "PUT", Response.Status.OK);
        public static final API_V1 GET_TYPE = new API_V1("api/atlas/types", "GET", Response.Status.OK);
        public static final API_V1 LIST_TYPES = new API_V1("api/atlas/types", "GET", Response.Status.OK);
        public static final API_V1 LIST_TRAIT_TYPES = new API_V1("api/atlas/types?type=trait", "GET", Response.Status.OK);
        public static final API_V1 CREATE_ENTITY = new API_V1("api/atlas/entities", "POST", Response.Status.CREATED);
        public static final API_V1 GET_ENTITY = new API_V1("api/atlas/entities", "GET", Response.Status.OK);
        public static final API_V1 UPDATE_ENTITY = new API_V1("api/atlas/entities", "PUT", Response.Status.OK);
        public static final API_V1 UPDATE_ENTITY_PARTIAL = new API_V1("api/atlas/entities", "POST", Response.Status.OK);
        public static final API_V1 LIST_ENTITIES = new API_V1("api/atlas/entities", "GET", Response.Status.OK);
        public static final API_V1 DELETE_ENTITIES = new API_V1("api/atlas/entities", "DELETE", Response.Status.OK);
        public static final API_V1 DELETE_ENTITY = new API_V1("api/atlas/entities", "DELETE", Response.Status.OK);
        public static final API_V1 LIST_ENTITY_AUDIT = new API_V1("api/atlas/entities", "GET", Response.Status.OK);
        public static final API_V1 ADD_TRAITS = new API_V1("api/atlas/entities", "POST", Response.Status.CREATED);
        public static final API_V1 DELETE_TRAITS = new API_V1("api/atlas/entities", "DELETE", Response.Status.OK);
        public static final API_V1 LIST_TRAITS = new API_V1("api/atlas/entities", "GET", Response.Status.OK);
        public static final API_V1 GET_ALL_TRAIT_DEFINITIONS = new API_V1("api/atlas/entities", "GET", Response.Status.OK);
        public static final API_V1 GET_TRAIT_DEFINITION = new API_V1("api/atlas/entities", "GET", Response.Status.OK);
        public static final API_V1 SEARCH = new API_V1("api/atlas/discovery/search", "GET", Response.Status.OK);
        public static final API_V1 SEARCH_DSL = new API_V1("api/atlas/discovery/search/dsl", "GET", Response.Status.OK);
        public static final API_V1 SEARCH_FULL_TEXT = new API_V1("api/atlas/discovery/search/fulltext", "GET", Response.Status.OK);
        public static final API_V1 GREMLIN_SEARCH = new API_V1("api/atlas/discovery/search/gremlin", "GET", Response.Status.OK);
        public static final API_V1 NAME_LINEAGE_INPUTS_GRAPH = new API_V1("api/atlas/lineage/hive/table", "GET", Response.Status.OK);
        public static final API_V1 NAME_LINEAGE_OUTPUTS_GRAPH = new API_V1("api/atlas/lineage/hive/table", "GET", Response.Status.OK);
        public static final API_V1 NAME_LINEAGE_SCHEMA = new API_V1("api/atlas/lineage/hive/table", "GET", Response.Status.OK);
        public static final API_V1 LINEAGE_INPUTS_GRAPH = new API_V1("api/atlas/lineage/", "GET", Response.Status.OK);
        public static final API_V1 LINEAGE_OUTPUTS_GRAPH = new API_V1("api/atlas/lineage/", "GET", Response.Status.OK);
        public static final API_V1 LINEAGE_SCHEMA = new API_V1("api/atlas/lineage/", "GET", Response.Status.OK);

        private API_V1(String path, String method, Response.Status status) {
            super(path, method, status);
        }
    }

    protected class ExtractOperation<T, U> {
        protected ExtractOperation() {
        }

        T extractElement(U element) {
            return (T)element;
        }
    }
}

