/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.webapp;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.ambari.metrics.core.timeline.TimelineMetricServiceSummary;
import org.apache.ambari.metrics.core.timeline.TimelineMetricStore;
import org.apache.ambari.metrics.timeline.GenericObjectMapper;
import org.apache.ambari.metrics.timeline.NameValuePair;
import org.apache.ambari.metrics.timeline.TimelineReader;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.sink.timeline.AggregationResult;
import org.apache.hadoop.metrics2.sink.timeline.ContainerMetric;
import org.apache.hadoop.metrics2.sink.timeline.Precision;
import org.apache.hadoop.metrics2.sink.timeline.PrecisionLimitExceededException;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetricMetadata;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;
import org.apache.hadoop.metrics2.sink.timeline.TopNConfig;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.apache.hadoop.yarn.webapp.BadRequestException;

@Singleton
@Path(value="/ws/v1/timeline")
public class TimelineWebServices {
    private static final Log LOG = LogFactory.getLog(TimelineWebServices.class);
    private TimelineMetricStore timelineMetricStore;
    private static final String SMOKETEST_METRIC_APP_ID = "amssmoketestfake";

    @Inject
    public TimelineWebServices(TimelineMetricStore timelineMetricStore) {
        this.timelineMetricStore = timelineMetricStore;
    }

    @GET
    @Produces(value={"application/json"})
    public AboutInfo about(@Context HttpServletRequest req, @Context HttpServletResponse res) {
        this.init(res);
        return new AboutInfo("AMS API");
    }

    @Path(value="/metrics")
    @POST
    @Consumes(value={"application/json"})
    public TimelinePutResponse postMetrics(@Context HttpServletRequest req, @Context HttpServletResponse res, TimelineMetrics metrics) {
        this.init(res);
        if (metrics == null) {
            return new TimelinePutResponse();
        }
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Storing metrics: " + TimelineUtils.dumpTimelineRecordtoJSON((Object)metrics, (boolean)true)));
            }
            if (CollectionUtils.isNotEmpty((Collection)metrics.getMetrics()) && ((TimelineMetric)metrics.getMetrics().get(0)).getAppId().equals(SMOKETEST_METRIC_APP_ID)) {
                return this.timelineMetricStore.putMetricsSkipCache(metrics);
            }
            return this.timelineMetricStore.putMetrics(metrics);
        }
        catch (Exception e) {
            LOG.error((Object)"Error saving metrics.", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Path(value="/metrics/aggregated")
    @POST
    @Consumes(value={"application/json"})
    public TimelinePutResponse postAggregatedMetrics(@Context HttpServletRequest req, @Context HttpServletResponse res, AggregationResult metrics) {
        this.init(res);
        if (metrics == null) {
            return new TimelinePutResponse();
        }
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Storing aggregated metrics: " + TimelineUtils.dumpTimelineRecordtoJSON((Object)metrics, (boolean)true)));
            }
            return this.timelineMetricStore.putHostAggregatedMetrics(metrics);
        }
        catch (Exception e) {
            LOG.error((Object)"Error saving metrics.", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Path(value="/containermetrics")
    @POST
    @Consumes(value={"application/json"})
    public TimelinePutResponse postContainerMetrics(@Context HttpServletRequest req, @Context HttpServletResponse res, List<ContainerMetric> metrics) {
        this.init(res);
        if (metrics == null || metrics.isEmpty()) {
            return new TimelinePutResponse();
        }
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Storing container metrics: " + TimelineUtils.dumpTimelineRecordtoJSON(metrics, (boolean)true)));
            }
            return this.timelineMetricStore.putContainerMetrics(metrics);
        }
        catch (Exception e) {
            LOG.error((Object)"Error saving metrics.", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/metrics")
    @Produces(value={"application/json"})
    public TimelineMetrics getTimelineMetrics(@Context HttpServletRequest req, @Context HttpServletResponse res, @QueryParam(value="metricNames") String metricNames, @QueryParam(value="appId") String appId, @QueryParam(value="instanceId") String instanceId, @QueryParam(value="hostname") String hostname, @QueryParam(value="startTime") String startTime, @QueryParam(value="endTime") String endTime, @QueryParam(value="precision") String precision, @QueryParam(value="limit") String limit, @QueryParam(value="grouped") String grouped, @QueryParam(value="topN") String topN, @QueryParam(value="topNFunction") String topNFunction, @QueryParam(value="isBottomN") String isBottomN, @QueryParam(value="seriesAggregateFunction") String seriesAggregateFunction) {
        this.init(res);
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Request for metrics => metricNames: " + metricNames + ", appId: " + appId + ", instanceId: " + instanceId + ", hostname: " + hostname + ", startTime: " + startTime + ", endTime: " + endTime + ", precision: " + precision + "seriesAggregateFunction: " + seriesAggregateFunction));
            }
            return this.timelineMetricStore.getTimelineMetrics(TimelineWebServices.parseListStr(metricNames, ","), TimelineWebServices.parseListStr(hostname, ","), appId, TimelineWebServices.parseStr(instanceId), TimelineWebServices.parseLongStr(startTime), TimelineWebServices.parseLongStr(endTime), Precision.getPrecision((String)precision), TimelineWebServices.parseIntStr(limit), TimelineWebServices.parseBoolean(grouped), TimelineWebServices.parseTopNConfig(topN, topNFunction, isBottomN), seriesAggregateFunction);
        }
        catch (NumberFormatException ne) {
            throw new BadRequestException("startTime and limit should be numeric values");
        }
        catch (Precision.PrecisionFormatException pfe) {
            throw new BadRequestException("precision should be seconds, minutes or hours");
        }
        catch (PrecisionLimitExceededException iae) {
            throw new PrecisionLimitExceededException(iae.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage());
        }
        catch (IOException | SQLException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="metrics/{instanceId}")
    @Produces(value={"application/json"})
    public TimelineMetrics getTimelineMetricsForInstance(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="instanceId") String instanceId, @QueryParam(value="metricNames") String metricNames, @QueryParam(value="appId") String appId, @QueryParam(value="hostname") String hostname, @QueryParam(value="startTime") String startTime, @QueryParam(value="endTime") String endTime, @QueryParam(value="precision") String precision, @QueryParam(value="limit") String limit, @QueryParam(value="grouped") String grouped, @QueryParam(value="topN") String topN, @QueryParam(value="topNFunction") String topNFunction, @QueryParam(value="isBottomN") String isBottomN, @QueryParam(value="seriesAggregateFunction") String seriesAggregateFunction) {
        return this.getTimelineMetrics(req, res, metricNames, appId, instanceId, hostname, startTime, endTime, precision, limit, grouped, topN, topNFunction, isBottomN, seriesAggregateFunction);
    }

    @GET
    @Path(value="/metrics/summary")
    @Produces(value={"application/json"})
    public TimelineMetricServiceSummary getTimelineMetricServiceSummary(@Context HttpServletRequest req, @Context HttpServletResponse res) {
        this.init(res);
        try {
            return this.timelineMetricStore.getTimelineMetricServiceSummary();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/metrics/metadata")
    @Produces(value={"application/json"})
    public Map<String, List<TimelineMetricMetadata>> getTimelineMetricMetadata(@Context HttpServletRequest req, @Context HttpServletResponse res, @QueryParam(value="appId") String appId, @QueryParam(value="metricName") String metricPattern, @QueryParam(value="includeAll") String includeBlacklistedMetrics) {
        this.init(res);
        try {
            return this.timelineMetricStore.getTimelineMetricMetadata(TimelineWebServices.parseStr(appId), TimelineWebServices.parseStr(metricPattern), TimelineWebServices.parseBoolean(includeBlacklistedMetrics));
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/metrics/{instanceId}/metadata")
    @Produces(value={"application/json"})
    public Map<String, List<TimelineMetricMetadata>> getTimelineMetricMetadataForInstance(@Context HttpServletRequest req, @Context HttpServletResponse res, @QueryParam(value="appId") String appId, @QueryParam(value="metricName") String metricPattern, @QueryParam(value="includeAll") String includeBlacklistedMetrics) {
        this.init(res);
        try {
            return this.timelineMetricStore.getTimelineMetricMetadata(TimelineWebServices.parseStr(appId), TimelineWebServices.parseStr(metricPattern), TimelineWebServices.parseBoolean(includeBlacklistedMetrics));
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/metrics/hosts")
    @Produces(value={"application/json"})
    public Map<String, Set<String>> getHostedAppsMetadata(@Context HttpServletRequest req, @Context HttpServletResponse res) {
        this.init(res);
        try {
            return this.timelineMetricStore.getHostAppsMetadata();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/metrics/instance")
    @Produces(value={"application/json"})
    public Map<String, Map<String, Set<String>>> getClusterHostsMetadata(@Context HttpServletRequest req, @Context HttpServletResponse res, @QueryParam(value="appId") String appId, @QueryParam(value="instanceId") String instanceId) {
        this.init(res);
        try {
            return this.timelineMetricStore.getInstanceHostsMetadata(instanceId, appId);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/metrics/{instanceId}/instance")
    @Produces(value={"application/json"})
    public Map<String, Map<String, Set<String>>> getClusterHostsMetadataForInstance(@Context HttpServletRequest req, @Context HttpServletResponse res, @QueryParam(value="appId") String appId, @PathParam(value="instanceId") String instanceId) {
        this.init(res);
        try {
            return this.timelineMetricStore.getInstanceHostsMetadata(instanceId, appId);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/metrics/uuid")
    @Produces(value={"application/json"})
    public byte[] getUuid(@Context HttpServletRequest req, @Context HttpServletResponse res, @QueryParam(value="metricName") String metricName, @QueryParam(value="appId") String appId, @QueryParam(value="instanceId") String instanceId, @QueryParam(value="hostname") String hostname) {
        this.init(res);
        if (metricName == null || appId == null) {
            throw new WebApplicationException((Throwable)new IllegalArgumentException("Non null values needed for metricName and appId"), Response.Status.BAD_REQUEST);
        }
        try {
            return this.timelineMetricStore.getUuid(metricName, appId, instanceId, hostname);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/metrics/livenodes")
    @Produces(value={"application/json"})
    public List<String> getLiveCollectorNodes(@Context HttpServletRequest req, @Context HttpServletResponse res) {
        this.init(res);
        return this.timelineMetricStore.getLiveInstances();
    }

    private void init(HttpServletResponse response) {
        response.setContentType(null);
    }

    private static SortedSet<String> parseArrayStr(String str, String delimiter) {
        String[] strs;
        if (str == null) {
            return null;
        }
        TreeSet<String> strSet = new TreeSet<String>();
        for (String aStr : strs = str.split(delimiter)) {
            strSet.add(aStr.trim());
        }
        return strSet;
    }

    private static NameValuePair parsePairStr(String str, String delimiter) {
        if (str == null) {
            return null;
        }
        String[] strs = str.split(delimiter, 2);
        try {
            return new NameValuePair(strs[0].trim(), GenericObjectMapper.OBJECT_READER.readValue(strs[1].trim()));
        }
        catch (Exception e) {
            return new NameValuePair(strs[0].trim(), strs[1].trim());
        }
    }

    private static Collection<NameValuePair> parsePairsStr(String str, String aDelimiter, String pDelimiter) {
        if (str == null) {
            return null;
        }
        String[] strs = str.split(aDelimiter);
        HashSet<NameValuePair> pairs = new HashSet<NameValuePair>();
        for (String aStr : strs) {
            pairs.add(TimelineWebServices.parsePairStr(aStr, pDelimiter));
        }
        return pairs;
    }

    private static EnumSet<TimelineReader.Field> parseFieldsStr(String str, String delimiter) {
        if (str == null) {
            return null;
        }
        String[] strs = str.split(delimiter);
        ArrayList<TimelineReader.Field> fieldList = new ArrayList<TimelineReader.Field>();
        for (String s : strs) {
            if ((s = s.trim().toUpperCase()).equals("EVENTS")) {
                fieldList.add(TimelineReader.Field.EVENTS);
                continue;
            }
            if (s.equals("LASTEVENTONLY")) {
                fieldList.add(TimelineReader.Field.LAST_EVENT_ONLY);
                continue;
            }
            if (s.equals("RELATEDENTITIES")) {
                fieldList.add(TimelineReader.Field.RELATED_ENTITIES);
                continue;
            }
            if (s.equals("PRIMARYFILTERS")) {
                fieldList.add(TimelineReader.Field.PRIMARY_FILTERS);
                continue;
            }
            if (s.equals("OTHERINFO")) {
                fieldList.add(TimelineReader.Field.OTHER_INFO);
                continue;
            }
            throw new IllegalArgumentException("Requested nonexistent field " + s);
        }
        if (fieldList.size() == 0) {
            return null;
        }
        TimelineReader.Field f1 = (TimelineReader.Field)((Object)fieldList.remove(fieldList.size() - 1));
        if (fieldList.size() == 0) {
            return EnumSet.of(f1);
        }
        return EnumSet.of(f1, fieldList.toArray(new TimelineReader.Field[fieldList.size()]));
    }

    private static Long parseLongStr(String str) {
        return str == null ? null : Long.valueOf(Long.parseLong(str.trim()));
    }

    private static Integer parseIntStr(String str) {
        return str == null ? null : Integer.valueOf(Integer.parseInt(str.trim()));
    }

    private static boolean parseBoolean(String booleanStr) {
        return booleanStr == null || Boolean.parseBoolean(booleanStr);
    }

    private static TopNConfig parseTopNConfig(String topN, String topNFunction, String bottomN) {
        if (topN == null || topN.isEmpty()) {
            return null;
        }
        Integer topNValue = TimelineWebServices.parseIntStr(topN);
        if (topNValue == 0) {
            LOG.info((Object)"Invalid Input for TopN query. Ignoring TopN Request.");
            return null;
        }
        Boolean isBottomN = bottomN != null && Boolean.parseBoolean(bottomN);
        return new TopNConfig(topNValue, topNFunction, isBottomN);
    }

    private static List<String> parseListStr(String str, String delimiter) {
        if (str == null || str.trim().isEmpty()) {
            return null;
        }
        String[] split = str.trim().split(delimiter);
        ArrayList<String> list = new ArrayList<String>(split.length);
        for (String s : split) {
            if (s.trim().isEmpty()) continue;
            list.add(s);
        }
        return list;
    }

    private static String parseStr(String str) {
        String trimmedInstance;
        String string = trimmedInstance = str == null ? null : str.trim();
        if (trimmedInstance != null && (trimmedInstance.isEmpty() || trimmedInstance.equalsIgnoreCase("undefined"))) {
            trimmedInstance = null;
        }
        return trimmedInstance;
    }

    @XmlRootElement(name="about")
    @XmlAccessorType(value=XmlAccessType.NONE)
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static class AboutInfo {
        private String about;

        public AboutInfo() {
        }

        public AboutInfo(String about) {
            this.about = about;
        }

        @XmlElement(name="About")
        public String getAbout() {
            return this.about;
        }

        public void setAbout(String about) {
            this.about = about;
        }
    }
}

