/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.webapp;

import com.google.inject.Singleton;
import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.api.json.JSONJAXBContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptsInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainersInfo;

@Singleton
@Provider
public class JAXBContextResolver
implements ContextResolver<JAXBContext> {
    private JAXBContext context;
    private final Set<Class> types;
    private final Class[] cTypes = new Class[]{AppInfo.class, AppsInfo.class, AppAttemptInfo.class, AppAttemptsInfo.class, ContainerInfo.class, ContainersInfo.class};

    public JAXBContextResolver() throws Exception {
        this.types = new HashSet<Class>(Arrays.asList(this.cTypes));
        this.context = new JSONJAXBContext(JSONConfiguration.natural().rootUnwrapping(false).build(), this.cTypes);
    }

    public JAXBContext getContext(Class<?> objectType) {
        return this.types.contains(objectType) ? this.context : null;
    }
}

