/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.uuid;

import com.google.common.hash.Hashing;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineClusterMetric;
import org.apache.ambari.metrics.core.timeline.uuid.MetricUuidGenNullRestrictedStrategy;
import org.apache.commons.lang.StringUtils;

public class Murmur3HashUuidGenStrategy
extends MetricUuidGenNullRestrictedStrategy {
    @Override
    byte[] computeUuidInternal(TimelineClusterMetric timelineClusterMetric, int maxLength) {
        String metricString = timelineClusterMetric.getMetricName() + timelineClusterMetric.getAppId();
        if (StringUtils.isNotEmpty((String)timelineClusterMetric.getInstanceId())) {
            metricString = metricString + timelineClusterMetric.getInstanceId();
        }
        byte[] metricBytes = metricString.getBytes();
        return Hashing.murmur3_128().hashBytes(metricBytes).asBytes();
    }

    @Override
    byte[] computeUuidInternal(String value, int maxLength) {
        byte[] valueBytes = value.getBytes();
        return Hashing.murmur3_32().hashBytes(valueBytes).asBytes();
    }
}

