/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.uuid;

import org.apache.ambari.metrics.core.timeline.aggregators.TimelineClusterMetric;
import org.apache.ambari.metrics.core.timeline.uuid.MetricUuidGenStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MetricUuidGenNullRestrictedStrategy
implements MetricUuidGenStrategy {
    private static final Log LOG = LogFactory.getLog(MetricUuidGenNullRestrictedStrategy.class);
    static final int RETRY_NUMBER = 5;

    @Override
    public byte[] computeUuid(TimelineClusterMetric timelineClusterMetric, int maxLength) {
        int retry_attempt = 0;
        byte[] result = null;
        while (retry_attempt++ < 5) {
            for (byte b : result = this.computeUuidInternal(timelineClusterMetric, maxLength)) {
                if (b == 0) continue;
                return result;
            }
            LOG.debug((Object)"Was generated Uuid which can represent null value in DB.");
        }
        LOG.error((Object)String.format("After %n attempts was generated Uuid which can represent null value in DB", 5));
        return result;
    }

    @Override
    public byte[] computeUuid(String value, int maxLength) {
        int retry_attempt = 0;
        byte[] result = null;
        while (retry_attempt++ < 5) {
            for (byte b : result = this.computeUuidInternal(value, maxLength)) {
                if (b == 0) continue;
                return result;
            }
            LOG.debug((Object)"Was generated Uuid which can represent null value in DB.");
        }
        LOG.error((Object)String.format("After %n attempts was generated Uuid which can represent null value in DB", 5));
        return result;
    }

    abstract byte[] computeUuidInternal(TimelineClusterMetric var1, int var2);

    abstract byte[] computeUuidInternal(String var1, int var2);
}

