/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.uuid;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineClusterMetric;
import org.apache.ambari.metrics.core.timeline.uuid.MetricUuidGenNullRestrictedStrategy;
import org.apache.commons.lang.StringUtils;

public class MD5UuidGenStrategy
extends MetricUuidGenNullRestrictedStrategy {
    @Override
    protected byte[] computeUuidInternal(TimelineClusterMetric timelineClusterMetric, int maxLength) {
        String metricString = timelineClusterMetric.getMetricName() + timelineClusterMetric.getAppId();
        if (StringUtils.isNotEmpty((String)timelineClusterMetric.getInstanceId())) {
            metricString = metricString + timelineClusterMetric.getInstanceId();
        }
        byte[] metricBytes = metricString.getBytes();
        UUID uuid = UUID.nameUUIDFromBytes(metricBytes);
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[maxLength]);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        return byteBuffer.array();
    }

    @Override
    protected byte[] computeUuidInternal(String value, int maxLength) {
        byte[] valueBytes = value.getBytes();
        UUID uuid = UUID.nameUUIDFromBytes(valueBytes);
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[maxLength]);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        return byteBuffer.array();
    }
}

