/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.uuid;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineClusterMetric;
import org.apache.ambari.metrics.core.timeline.uuid.MetricUuidGenNullRestrictedStrategy;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class HashBasedUuidGenStrategy
extends MetricUuidGenNullRestrictedStrategy {
    @Override
    protected byte[] computeUuidInternal(TimelineClusterMetric timelineClusterMetric, int maxLength) {
        int metricNameUuidLength = 12;
        String instanceId = timelineClusterMetric.getInstanceId();
        if (StringUtils.isEmpty((CharSequence)instanceId)) {
            metricNameUuidLength = 14;
        }
        String metricName = timelineClusterMetric.getMetricName();
        String[] splits = this.getIndidivualSplits(metricName);
        StringBuilder splitSums = new StringBuilder();
        long totalAsciiSum = 0L;
        if (splits.length > 0) {
            for (String split : splits) {
                int asciiSum = 0;
                for (int i = 0; i < split.length(); ++i) {
                    asciiSum += (i + 1) * split.charAt(i);
                }
                splitSums.append(asciiSum);
                totalAsciiSum += (long)asciiSum;
            }
        }
        String splitSumString = totalAsciiSum + splitSums.reverse().toString();
        int splitLength = splitSumString.length();
        String stemmedMetric = this.stem(metricName);
        long metricSeed = 100123456789L;
        byte[] metricSeedBytes = StringUtils.reverse((String)String.valueOf(metricSeed += this.computeWeightedNumericalAsciiSum(stemmedMetric))).getBytes();
        int seedLength = (int)(0.25 * (double)metricNameUuidLength);
        int sumLength = metricNameUuidLength - seedLength;
        if (splitLength < sumLength) {
            sumLength = splitLength;
            seedLength = metricNameUuidLength - sumLength;
        }
        byte[] metricUuidPortion = ArrayUtils.addAll((byte[])ArrayUtils.subarray((byte[])splitSumString.getBytes(), (int)0, (int)sumLength), (byte[])ArrayUtils.subarray((byte[])metricSeedBytes, (int)0, (int)seedLength));
        String appId = timelineClusterMetric.getAppId();
        int appidSeed = 11;
        for (int i = 0; i < appId.length(); ++i) {
            appidSeed += appId.charAt(i);
        }
        String appIdSeedStr = String.valueOf(appidSeed);
        byte[] appUuidPortion = ArrayUtils.subarray((byte[])appIdSeedStr.getBytes(), (int)(appIdSeedStr.length() - 2), (int)appIdSeedStr.length());
        if (StringUtils.isNotEmpty((CharSequence)instanceId)) {
            byte[] instanceUuidPortion = new byte[2];
            ByteBuffer buffer = ByteBuffer.allocate(4);
            int instanceIdSeed = 1489;
            for (int i = 0; i < appId.length(); ++i) {
                instanceIdSeed += (i + 1) * appId.charAt(i);
            }
            buffer.putInt(instanceIdSeed);
            ArrayUtils.subarray((byte[])buffer.array(), (int)2, (int)4);
            return ArrayUtils.addAll((byte[])ArrayUtils.addAll((byte[])metricUuidPortion, (byte[])appUuidPortion), (byte[])instanceUuidPortion);
        }
        return ArrayUtils.addAll((byte[])metricUuidPortion, (byte[])appUuidPortion);
    }

    private String[] getIndidivualSplits(String metricName) {
        ArrayList<String> tokens = new ArrayList<String>();
        String[] splits = new String[]{};
        if (metricName.contains(".")) {
            for (String split : splits = metricName.split("\\.")) {
                if (split.contains("_")) {
                    String[] subSplits = split.split("\\_");
                    tokens.addAll(Arrays.asList(subSplits));
                    continue;
                }
                tokens.add(split);
            }
        }
        if (splits.length <= 1) {
            splits = metricName.split("\\_");
            return splits;
        }
        if (splits.length <= 1) {
            splits = metricName.split("\\=");
            return splits;
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private String stem(String metricName) {
        String metric = metricName.toLowerCase();
        String regex = "[\\.\\_\\%\\-\\=\\/\\@\\(\\)\\[\\]\\:]";
        String trimmedMetric = StringUtils.removePattern((String)metric, (String)regex);
        return trimmedMetric;
    }

    @Override
    protected byte[] computeUuidInternal(String value, int maxLength) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        int customAsciiSum = 27177289 + (int)this.computeWeightedNumericalAsciiSum(value);
        StringBuilder customAsciiSumStr = new StringBuilder(String.valueOf(customAsciiSum));
        if (customAsciiSumStr.length() < maxLength) {
            String originalcustomAsciiSumStr = customAsciiSumStr.toString();
            while (customAsciiSumStr.length() < maxLength) {
                customAsciiSumStr.append(originalcustomAsciiSumStr);
            }
            return customAsciiSumStr.substring(0, maxLength).getBytes();
        }
        return customAsciiSumStr.substring(customAsciiSumStr.length() - maxLength, customAsciiSumStr.length()).getBytes();
    }

    public long computeWeightedNumericalAsciiSum(String value) {
        int len = value.length();
        long numericValue = 0L;
        long sum = 0L;
        int numericCtr = 0;
        int i = 0;
        while (i < len) {
            char ascii = value.charAt(i);
            if ('0' <= ascii && ascii <= '9' && numericCtr < 4) {
                numericValue = numericValue * 10L + (long)(ascii - 48);
                ++numericCtr;
                ++i;
                continue;
            }
            if (numericValue > 0L) {
                sum += numericValue;
                numericValue = 0L;
            }
            if (numericCtr < 4) {
                sum += (long)value.charAt(i);
                ++i;
            }
            numericCtr = 0;
        }
        if (numericValue != 0L) {
            sum += numericValue;
        }
        return sum;
    }
}

