/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.upgrade.core;

import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.ambari.metrics.core.timeline.PhoenixHBaseAccessor;
import org.apache.ambari.metrics.core.timeline.upgrade.core.AbstractPhoenixMetricsCopier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.sink.timeline.MetricHostAggregate;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;

public class PhoenixHostMetricsCopier
extends AbstractPhoenixMetricsCopier {
    private static final Log LOG = LogFactory.getLog(PhoenixHostMetricsCopier.class);
    private final Map<TimelineMetric, MetricHostAggregate> aggregateMap = new HashMap<TimelineMetric, MetricHostAggregate>();

    PhoenixHostMetricsCopier(String inputTableName, String outputTableName, PhoenixHBaseAccessor hBaseAccessor, Set<String> metricNames, long startTime, Writer processedMetricsFileWriter) {
        super(inputTableName, outputTableName, hBaseAccessor, metricNames, startTime, processedMetricsFileWriter);
    }

    @Override
    protected String getColumnsClause() {
        return "METRIC_NAME, HOSTNAME, APP_ID, INSTANCE_ID, SERVER_TIME, METRIC_SUM, METRIC_COUNT, METRIC_MAX, METRIC_MIN";
    }

    @Override
    protected void saveMetrics() throws SQLException {
        LOG.debug((Object)String.format("Saving %s results read from %s into %s", this.aggregateMap.size(), this.inputTable, this.outputTable));
        this.hBaseAccessor.saveHostAggregateRecords(this.aggregateMap, this.outputTable);
    }

    @Override
    protected void addToResults(ResultSet rs) throws SQLException {
        TimelineMetric timelineMetric = new TimelineMetric();
        timelineMetric.setMetricName(rs.getString("METRIC_NAME"));
        timelineMetric.setHostName(rs.getString("HOSTNAME"));
        timelineMetric.setAppId(rs.getString("APP_ID"));
        timelineMetric.setInstanceId(rs.getString("INSTANCE_ID"));
        timelineMetric.setStartTime(rs.getLong("SERVER_TIME"));
        MetricHostAggregate metricHostAggregate = this.extractMetricHostAggregate(rs);
        this.aggregateMap.put(timelineMetric, metricHostAggregate);
    }
}

