/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.upgrade.core;

import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.apache.ambari.metrics.core.timeline.PhoenixHBaseAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.sink.timeline.MetricHostAggregate;

public abstract class AbstractPhoenixMetricsCopier
implements Runnable {
    private static final Log LOG = LogFactory.getLog(AbstractPhoenixMetricsCopier.class);
    private static final long DEFAULT_NATIVE_TIME_RANGE_DELAY = 120000L;
    private final long startTime;
    protected final Writer processedMetricsFile;
    protected String inputTable;
    protected String outputTable;
    protected Set<String> metricNames;
    protected PhoenixHBaseAccessor hBaseAccessor;

    public AbstractPhoenixMetricsCopier(String inputTableName, String outputTableName, PhoenixHBaseAccessor hBaseAccessor, Set<String> metricNames, long startTime, Writer outputStream) {
        this.inputTable = inputTableName;
        this.outputTable = outputTableName;
        this.hBaseAccessor = hBaseAccessor;
        this.metricNames = metricNames;
        this.startTime = startTime;
        this.processedMetricsFile = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.info((Object)String.format("Copying %s metrics from %s to %s", this.metricNames, this.inputTable, this.outputTable));
        long timerStart = System.currentTimeMillis();
        String query = String.format("SELECT %s %s FROM %s WHERE %s AND SERVER_TIME > %s ORDER BY METRIC_NAME, SERVER_TIME", this.getQueryHint(this.startTime), this.getColumnsClause(), this.inputTable, this.getMetricNamesLikeClause(), this.startTime);
        this.runPhoenixQueryAndAddToResults(query);
        try {
            this.saveMetrics();
        }
        catch (SQLException e) {
            try {
                LOG.error((Object)e);
            }
            catch (Throwable throwable) {
                long timerDelta = System.currentTimeMillis() - timerStart;
                LOG.debug((Object)String.format("Copying took %s seconds from table %s to table %s for metric names %s", (double)timerDelta / 1000.0, this.inputTable, this.outputTable, this.metricNames));
                this.saveMetricsProgress();
                throw throwable;
            }
            long timerDelta = System.currentTimeMillis() - timerStart;
            LOG.debug((Object)String.format("Copying took %s seconds from table %s to table %s for metric names %s", (double)timerDelta / 1000.0, this.inputTable, this.outputTable, this.metricNames));
            this.saveMetricsProgress();
        }
        long timerDelta = System.currentTimeMillis() - timerStart;
        LOG.debug((Object)String.format("Copying took %s seconds from table %s to table %s for metric names %s", (double)timerDelta / 1000.0, this.inputTable, this.outputTable, this.metricNames));
        this.saveMetricsProgress();
    }

    private String getMetricNamesLikeClause() {
        StringBuilder sb = new StringBuilder(256);
        sb.append('(');
        int i = 0;
        for (String metricName : this.metricNames) {
            sb.append("METRIC_NAME LIKE '").append(metricName).append("'");
            if (i < this.metricNames.size() - 1) {
                sb.append(" OR ");
            }
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }

    protected abstract String getColumnsClause();

    private void runPhoenixQueryAndAddToResults(String query) {
        LOG.debug((Object)String.format("Running query: %s", query));
        try (Connection conn = this.hBaseAccessor.getConnection();
             PreparedStatement stmt = conn.prepareStatement(query);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                this.addToResults(rs);
            }
        }
        catch (SQLException e) {
            LOG.error((Object)String.format("Exception during running phoenix query %s", query), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMetricsProgress() {
        if (this.processedMetricsFile == null) {
            LOG.info((Object)"Skipping metrics progress save as the file is null");
            return;
        }
        for (String metricName : this.metricNames) {
            try {
                Writer writer = this.processedMetricsFile;
                synchronized (writer) {
                    this.processedMetricsFile.append(this.inputTable).append(":").append(metricName).append(System.lineSeparator());
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
    }

    protected String getQueryHint(long startTime) {
        return "/*+ NATIVE_TIME_RANGE(" + (startTime - 120000L) + ") */";
    }

    protected MetricHostAggregate extractMetricHostAggregate(ResultSet rs) throws SQLException {
        MetricHostAggregate metricHostAggregate = new MetricHostAggregate();
        metricHostAggregate.setSum(Double.valueOf(rs.getDouble("METRIC_SUM")));
        metricHostAggregate.setNumberOfSamples(rs.getLong("METRIC_COUNT"));
        metricHostAggregate.setMax(Double.valueOf(rs.getDouble("METRIC_MAX")));
        metricHostAggregate.setMin(Double.valueOf(rs.getDouble("METRIC_MIN")));
        return metricHostAggregate;
    }

    protected abstract void saveMetrics() throws SQLException;

    protected abstract void addToResults(ResultSet var1) throws SQLException;
}

