/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.source.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ambari.metrics.core.timeline.TimelineMetricConfiguration;
import org.apache.ambari.metrics.core.timeline.source.cache.InternalMetricsCache;

public class InternalMetricsCacheProvider {
    private Map<String, InternalMetricsCache> metricsCacheMap = new ConcurrentHashMap<String, InternalMetricsCache>();
    private static final InternalMetricsCacheProvider instance = new InternalMetricsCacheProvider();

    private InternalMetricsCacheProvider() {
    }

    public static InternalMetricsCacheProvider getInstance() {
        return instance;
    }

    public InternalMetricsCache getCacheInstance(String instanceName) {
        if (this.metricsCacheMap.containsKey(instanceName)) {
            return this.metricsCacheMap.get(instanceName);
        }
        TimelineMetricConfiguration conf = TimelineMetricConfiguration.getInstance();
        InternalMetricsCache cache = new InternalMetricsCache(instanceName, conf.getInternalCacheSize(instanceName));
        this.metricsCacheMap.put(instanceName, cache);
        return cache;
    }
}

