/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.source.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ambari.metrics.core.timeline.source.cache.InternalMetricCacheKey;
import org.apache.ambari.metrics.core.timeline.source.cache.InternalMetricCacheValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.event.CacheEvent;
import org.ehcache.event.CacheEventListener;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.ehcache.event.EventType;
import org.ehcache.expiry.Expirations;

public class InternalMetricsCache {
    private static final Log LOG = LogFactory.getLog(InternalMetricsCache.class);
    private final String instanceName;
    private final Integer internalCacheEntryCount;
    private volatile boolean isCacheInitialized = false;
    private Cache<InternalMetricCacheKey, InternalMetricCacheValue> cache;
    private final Lock lock = new ReentrantLock();
    private static final int LOCK_TIMEOUT_SECONDS = 2;

    public InternalMetricsCache(String instanceName, Integer internalCacheEntryCount) {
        this.instanceName = instanceName;
        this.internalCacheEntryCount = internalCacheEntryCount;
        this.initialize();
    }

    private void initialize() {
        if (this.isCacheInitialized) {
            throw new RuntimeException("Cannot initialize internal cache twice");
        }
        CacheManager manager = CacheManagerBuilder.newCacheManagerBuilder().build(true);
        CacheConfiguration cacheConfig = CacheConfigurationBuilder.newCacheConfigurationBuilder(InternalMetricCacheKey.class, InternalMetricCacheValue.class, (Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().heap((long)this.internalCacheEntryCount.intValue(), (ResourceUnit)EntryUnit.ENTRIES)).withExpiry(Expirations.noExpiration()).build();
        this.cache = manager.createCache(this.instanceName, cacheConfig);
        this.cache.getRuntimeConfiguration().registerCacheEventListener((CacheEventListener)new InternalCacheEvictionListener(), EventOrdering.ORDERED, EventFiring.SYNCHRONOUS, EnumSet.of(EventType.EVICTED));
        LOG.info((Object)("Registering internal metrics cache with provider: name = " + this.instanceName));
        this.isCacheInitialized = true;
    }

    public InternalMetricCacheValue getInternalMetricCacheValue(InternalMetricCacheKey key) {
        return (InternalMetricCacheValue)this.cache.get((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TimelineMetrics> evictAll() {
        TimelineMetrics metrics;
        block7: {
            metrics = new TimelineMetrics();
            try {
                if (this.lock.tryLock(2L, TimeUnit.SECONDS)) {
                    try {
                        Iterator iterator = this.cache.iterator();
                        while (iterator.hasNext()) {
                            Cache.Entry entry = (Cache.Entry)iterator.next();
                            TimelineMetric metric = new TimelineMetric();
                            InternalMetricCacheKey key = (InternalMetricCacheKey)entry.getKey();
                            metric.setMetricName(key.getMetricName());
                            metric.setAppId(key.getAppId());
                            metric.setInstanceId(key.getInstanceId());
                            metric.setHostName(key.getHostname());
                            metric.setStartTime(key.getStartTime());
                            InternalMetricCacheValue value = (InternalMetricCacheValue)this.cache.get((Object)key);
                            metric.setMetricValues(value.getMetricValues());
                            metrics.getMetrics().add(metric);
                            iterator.remove();
                        }
                        break block7;
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                LOG.warn((Object)"evictAll: Unable to acquire lock on the cache instance. Giving up after 2 seconds.");
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Interrupted while waiting to acquire lock");
            }
        }
        return Collections.singletonList(metrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Collection<TimelineMetrics> metrics) {
        block10: {
            try {
                if (this.lock.tryLock(2L, TimeUnit.SECONDS)) {
                    try {
                        if (metrics != null) {
                            for (TimelineMetrics timelineMetrics : metrics) {
                                for (TimelineMetric timelineMetric : timelineMetrics.getMetrics()) {
                                    InternalMetricCacheKey key = new InternalMetricCacheKey(timelineMetric.getMetricName(), timelineMetric.getAppId(), timelineMetric.getInstanceId(), timelineMetric.getHostName(), timelineMetric.getStartTime());
                                    InternalMetricCacheValue value = (InternalMetricCacheValue)this.cache.get((Object)key);
                                    if (value != null) {
                                        value.addMetricValues(timelineMetric.getMetricValues());
                                        continue;
                                    }
                                    value = new InternalMetricCacheValue();
                                    value.setMetricValues(timelineMetric.getMetricValues());
                                    this.cache.put((Object)key, (Object)value);
                                }
                            }
                        }
                        break block10;
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                LOG.warn((Object)"putAll: Unable to acquire lock on the cache instance. Giving up after 2 seconds.");
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Interrupted while waiting to acquire lock");
            }
        }
    }

    class InternalCacheEvictionListener
    implements CacheEventListener<InternalMetricCacheKey, InternalMetricCacheValue> {
        InternalCacheEvictionListener() {
        }

        public void onEvent(CacheEvent<? extends InternalMetricCacheKey, ? extends InternalMetricCacheValue> event) {
            if (event.getType() == EventType.EVICTED) {
                InternalMetricCacheKey key = (InternalMetricCacheKey)event.getKey();
                LOG.warn((Object)("Evicting element from internal metrics cache, metric => " + key.getMetricName() + ", startTime = " + new Date(key.getStartTime())));
            }
        }
    }
}

