/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.source;

import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ambari.metrics.core.timeline.sink.ExternalMetricsSink;
import org.apache.ambari.metrics.core.timeline.source.InternalMetricsSource;
import org.apache.ambari.metrics.core.timeline.source.cache.InternalMetricsCache;
import org.apache.ambari.metrics.core.timeline.source.cache.InternalMetricsCacheProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;

public class RawMetricsSource
implements InternalMetricsSource {
    private static final Log LOG = LogFactory.getLog(RawMetricsSource.class);
    private final int internalCacheInterval;
    private final ExternalMetricsSink rawMetricsSink;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final InternalMetricsCache cache;
    static final String RAW_METRICS_CACHE = "RAW_METRICS_CACHE_INSTANCE";

    public RawMetricsSource(int internalCacheInterval, ExternalMetricsSink rawMetricsSink) {
        this.internalCacheInterval = internalCacheInterval;
        this.rawMetricsSink = rawMetricsSink;
        this.cache = InternalMetricsCacheProvider.getInstance().getCacheInstance(RAW_METRICS_CACHE);
        if (rawMetricsSink.getFlushSeconds() > internalCacheInterval) {
            this.initializeFixedRateScheduler();
        }
    }

    @Override
    public void publishTimelineMetrics(Collection<TimelineMetrics> metrics) {
        if (this.rawMetricsSink.getFlushSeconds() > this.internalCacheInterval) {
            this.cache.putAll(metrics);
        } else {
            this.submitDataWithTimeout(metrics);
        }
    }

    private void initializeFixedRateScheduler() {
        this.executorService.scheduleAtFixedRate(() -> this.rawMetricsSink.sinkMetricData(this.cache.evictAll()), this.rawMetricsSink.getFlushSeconds(), this.rawMetricsSink.getFlushSeconds(), TimeUnit.SECONDS);
    }

    private void submitDataWithTimeout(Collection<TimelineMetrics> metrics) {
        Future<Object> f = this.executorService.submit(() -> {
            this.rawMetricsSink.sinkMetricData(metrics);
            return null;
        });
        try {
            f.get(this.rawMetricsSink.getSinkTimeOutSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Raw metrics sink interrupted.");
        }
        catch (ExecutionException e) {
            LOG.warn((Object)"Exception on sinking metrics", (Throwable)e);
        }
        catch (TimeoutException e) {
            LOG.warn((Object)"Timeout exception on sinking metrics", (Throwable)e);
        }
    }
}

