/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.sink;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import java.util.Collection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.ambari.metrics.core.timeline.TimelineMetricConfiguration;
import org.apache.ambari.metrics.core.timeline.sink.ExternalMetricsSink;
import org.apache.ambari.metrics.core.timeline.sink.ExternalSinkProvider;
import org.apache.ambari.metrics.core.timeline.source.InternalSourceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;
import org.apache.http.client.utils.URIBuilder;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

public class HttpSinkProvider
implements ExternalSinkProvider {
    private static final Log LOG = LogFactory.getLog(HttpSinkProvider.class);
    TimelineMetricConfiguration conf = TimelineMetricConfiguration.getInstance();
    private String connectUrl;
    private SSLSocketFactory sslSocketFactory;
    protected static ObjectMapper mapper = new ObjectMapper();

    public HttpSinkProvider() {
        Configuration config;
        try {
            config = this.conf.getMetricsConf();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("Unable to read configuration for sink.");
        }
        String protocol = config.get("timeline.metrics.service.external.http.sink.protocol", "http");
        String host = config.get("timeline.metrics.service.external.http.sink.host", "localhost");
        String port = config.get("timeline.metrics.service.external.http.sink.port", "6189");
        if (protocol.contains("https")) {
            this.loadTruststore(config.getTrimmed("timeline.metrics.service.external.http.sink.truststore.path"), config.getTrimmed("timeline.metrics.service.external.http.sink.truststore.type"), config.getTrimmed("timeline.metrics.service.external.http.sink.truststore.password"));
        }
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme(protocol);
        uriBuilder.setHost(host);
        uriBuilder.setPort(Integer.parseInt(port));
        this.connectUrl = uriBuilder.toString();
    }

    @Override
    public ExternalMetricsSink getExternalMetricsSink(InternalSourceProvider.SOURCE_NAME sourceName) {
        return new DefaultHttpMetricsSink();
    }

    protected HttpURLConnection getConnection(String spec) throws IOException {
        return (HttpURLConnection)new URL(spec).openConnection();
    }

    protected HttpsURLConnection getSSLConnection(String spec) throws IOException, IllegalStateException {
        HttpsURLConnection connection = (HttpsURLConnection)new URL(spec).openConnection();
        connection.setSSLSocketFactory(this.sslSocketFactory);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadTruststore(String trustStorePath, String trustStoreType, String trustStorePassword) {
        if (this.sslSocketFactory == null) {
            if (trustStorePath == null || trustStorePassword == null) {
                String msg = "Can't load TrustStore. Truststore path or password is not set.";
                LOG.error((Object)msg);
                throw new IllegalStateException(msg);
            }
            FileInputStream in = null;
            try {
                in = new FileInputStream(new File(trustStorePath));
                KeyStore store = KeyStore.getInstance(trustStoreType == null ? KeyStore.getDefaultType() : trustStoreType);
                store.load(in, trustStorePassword.toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(store);
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, tmf.getTrustManagers(), null);
                this.sslSocketFactory = context.getSocketFactory();
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to load TrustStore", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Unable to load TrustStore", (Throwable)e);
                    }
                }
            }
        }
    }

    static {
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        mapper.setAnnotationIntrospector((AnnotationIntrospector)introspector);
        mapper.getSerializationConfig().withSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }

    class DefaultHttpMetricsSink
    implements ExternalMetricsSink {
        DefaultHttpMetricsSink() {
        }

        @Override
        public int getSinkTimeOutSeconds() {
            try {
                return HttpSinkProvider.this.conf.getMetricsConf().getInt("timeline.metrics.external.sink.http.timeout.seconds", 10);
            }
            catch (Exception e) {
                return 10;
            }
        }

        @Override
        public int getFlushSeconds() {
            try {
                return HttpSinkProvider.this.conf.getMetricsConf().getInt("timeline.metrics.cache.commit.interval", 3);
            }
            catch (Exception e) {
                LOG.warn((Object)"Cannot read cache commit interval.");
                return 3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String cleanupInputStream(InputStream is) throws IOException {
            StringBuilder sb = new StringBuilder();
            if (is != null) {
                try (InputStreamReader isr = new InputStreamReader(is);
                     BufferedReader br = new BufferedReader(isr);){
                    String line;
                    while ((line = br.readLine()) != null) {
                        if (!LOG.isDebugEnabled()) continue;
                        sb.append(line);
                    }
                }
                finally {
                    is.close();
                }
            }
            return sb.toString();
        }

        @Override
        public void sinkMetricData(Collection<TimelineMetrics> metrics) {
            HttpURLConnection connection = null;
            try {
                int statusCode;
                connection = HttpSinkProvider.this.connectUrl.startsWith("https") ? HttpSinkProvider.this.getSSLConnection(HttpSinkProvider.this.connectUrl) : HttpSinkProvider.this.getConnection(HttpSinkProvider.this.connectUrl);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("Connection", "Keep-Alive");
                connection.setConnectTimeout(this.getSinkTimeOutSeconds());
                connection.setReadTimeout(this.getSinkTimeOutSeconds());
                connection.setDoOutput(true);
                if (metrics != null) {
                    String jsonData = mapper.writeValueAsString(metrics);
                    try (OutputStream os = connection.getOutputStream();){
                        os.write(jsonData.getBytes("UTF-8"));
                    }
                }
                if ((statusCode = connection.getResponseCode()) != 200) {
                    LOG.info((Object)("Unable to POST metrics to external sink, " + HttpSinkProvider.this.connectUrl + ", statusCode = " + statusCode));
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Metrics posted to external sink " + HttpSinkProvider.this.connectUrl));
                }
                this.cleanupInputStream(connection.getInputStream());
            }
            catch (IOException io) {
                LOG.warn((Object)"Unable to sink data to external system.", (Throwable)io);
            }
        }
    }
}

