/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.sink;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import org.apache.ambari.metrics.core.timeline.TimelineMetricConfiguration;
import org.apache.ambari.metrics.core.timeline.sink.ExternalMetricsSink;
import org.apache.ambari.metrics.core.timeline.sink.ExternalSinkProvider;
import org.apache.ambari.metrics.core.timeline.source.InternalSourceProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;

public class DefaultFSSinkProvider
implements ExternalSinkProvider {
    private static final Log LOG = LogFactory.getLog(DefaultFSSinkProvider.class);
    TimelineMetricConfiguration conf = TimelineMetricConfiguration.getInstance();
    private final DefaultExternalMetricsSink sink = new DefaultExternalMetricsSink();
    private long FIXED_FILE_SIZE;
    private final String SINK_FILE_NAME = "external-metrics-sink.dat";
    private final String SEPARATOR = ", ";
    private final String LINE_SEP = System.lineSeparator();
    private final String HEADERS = "METRIC, APP_ID, INSTANCE_ID, HOSTNAME, START_TIME, DATA";

    public DefaultFSSinkProvider() {
        try {
            this.FIXED_FILE_SIZE = this.conf.getMetricsConf().getLong("timeline.metrics.service.external.fs.sink.filesize", 0x6400000L);
        }
        catch (Exception ignored) {
            this.FIXED_FILE_SIZE = 0x6400000L;
        }
    }

    @Override
    public ExternalMetricsSink getExternalMetricsSink(InternalSourceProvider.SOURCE_NAME sourceName) {
        return this.sink;
    }

    class DefaultExternalMetricsSink
    implements ExternalMetricsSink {
        DefaultExternalMetricsSink() {
        }

        @Override
        public int getSinkTimeOutSeconds() {
            return 10;
        }

        @Override
        public int getFlushSeconds() {
            try {
                return DefaultFSSinkProvider.this.conf.getMetricsConf().getInt("timeline.metrics.cache.commit.interval", 3);
            }
            catch (Exception e) {
                LOG.warn((Object)"Cannot read cache commit interval.");
                return 3;
            }
        }

        private boolean createFile(File f) {
            boolean created = false;
            if (!f.exists()) {
                try {
                    created = f.createNewFile();
                    FileUtils.writeStringToFile((File)f, (String)"METRIC, APP_ID, INSTANCE_ID, HOSTNAME, START_TIME, DATA");
                }
                catch (IOException e) {
                    LOG.error((Object)("Cannot create external-metrics-sink.dat at " + f.getPath()));
                    return false;
                }
            }
            return created;
        }

        private boolean shouldReCreate(File f) {
            if (!f.exists()) {
                return true;
            }
            return FileUtils.sizeOf((File)f) > DefaultFSSinkProvider.this.FIXED_FILE_SIZE;
        }

        @Override
        public void sinkMetricData(Collection<TimelineMetrics> metrics) {
            String dirPath = TimelineMetricConfiguration.getInstance().getDefaultMetricsSinkDir();
            File dir = new File(dirPath);
            if (!dir.exists()) {
                LOG.error((Object)("Cannot sink data to file system, incorrect dir path " + dirPath));
                return;
            }
            File f = FileUtils.getFile((String[])new String[]{dirPath, "external-metrics-sink.dat"});
            if (this.shouldReCreate(f)) {
                if (!f.delete()) {
                    LOG.warn((Object)"Unable to delete external sink file.");
                    return;
                }
                this.createFile(f);
            }
            if (metrics != null) {
                for (TimelineMetrics timelineMetrics : metrics) {
                    for (TimelineMetric metric : timelineMetrics.getMetrics()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(metric.getMetricName());
                        sb.append(", ");
                        sb.append(metric.getAppId());
                        sb.append(", ");
                        if (StringUtils.isEmpty((String)metric.getInstanceId())) {
                            sb.append(", ");
                        } else {
                            sb.append(metric.getInstanceId());
                            sb.append(", ");
                        }
                        if (StringUtils.isEmpty((String)metric.getHostName())) {
                            sb.append(", ");
                        } else {
                            sb.append(metric.getHostName());
                            sb.append(", ");
                        }
                        sb.append(new Date(metric.getStartTime()));
                        sb.append(", ");
                        sb.append(metric.getMetricValues().toString());
                        sb.append(DefaultFSSinkProvider.this.LINE_SEP);
                        try {
                            FileUtils.writeStringToFile((File)f, (String)sb.toString());
                        }
                        catch (IOException e) {
                            LOG.warn((Object)("Unable to sink data to file " + f.getPath()));
                        }
                    }
                }
            }
        }
    }
}

