/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ambari.metrics.core.timeline.query.DefaultCondition;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.metrics2.sink.timeline.Precision;

public class TransientMetricCondition
extends DefaultCondition {
    private List<String> transientMetricNames = new ArrayList<String>();

    public TransientMetricCondition(List<byte[]> uuids, List<String> metricNames, List<String> hostnames, String appId, String instanceId, Long startTime, Long endTime, Precision precision, Integer limit, boolean grouped, List<String> transientMetricNames) {
        super(uuids, metricNames, hostnames, appId, instanceId, startTime, endTime, precision, limit, grouped);
        this.transientMetricNames = transientMetricNames;
        if (CollectionUtils.isEmpty(hostnames)) {
            this.hostnames = Collections.singletonList("%");
        }
    }

    public TransientMetricCondition(List<String> metricNames, List<String> hostnames, String appId, String instanceId, Long startTime, Long endTime, Precision precision, Integer limit, boolean grouped, List<String> transientMetricNames) {
        super(metricNames, hostnames, appId, instanceId, startTime, endTime, precision, limit, grouped);
        this.transientMetricNames = transientMetricNames;
        if (CollectionUtils.isEmpty(hostnames)) {
            this.hostnames = Collections.singletonList("%");
        }
    }

    public StringBuilder getTransientConditionClause() {
        String instanceId;
        StringBuilder sb = new StringBuilder();
        boolean appendConjunction = this.appendMetricNameClause(sb);
        appendConjunction = this.appendHostnameClause(sb, appendConjunction);
        String appId = this.getAppId();
        if (appId != null) {
            appendConjunction = appId.contains("%") ? TransientMetricCondition.append(sb, appendConjunction, this.getAppId(), " APP_ID LIKE ?") : TransientMetricCondition.append(sb, appendConjunction, this.getAppId(), " APP_ID = ?");
        }
        if ((instanceId = this.getInstanceId()) != null) {
            appendConjunction = instanceId.contains("%") ? TransientMetricCondition.append(sb, appendConjunction, this.getInstanceId(), " INSTANCE_ID LIKE ?") : TransientMetricCondition.append(sb, appendConjunction, this.getInstanceId(), " INSTANCE_ID = ?");
        }
        appendConjunction = TransientMetricCondition.append(sb, appendConjunction, this.getStartTime(), " SERVER_TIME >= ?");
        TransientMetricCondition.append(sb, appendConjunction, this.getEndTime(), " SERVER_TIME < ?");
        return sb;
    }

    protected boolean appendMetricNameClause(StringBuilder sb) {
        boolean appendConjunction = false;
        ArrayList<String> metricsLike = new ArrayList<String>();
        ArrayList<String> metricsIn = new ArrayList<String>();
        if (this.getMetricNames() != null) {
            for (String name : this.getMetricNames()) {
                if (name.contains("%")) {
                    metricsLike.add(name);
                    continue;
                }
                metricsIn.add(name);
            }
            sb.append("(");
            if (CollectionUtils.isNotEmpty(metricsIn)) {
                sb.append("METRIC_NAME");
                if (this.metricNamesNotCondition) {
                    sb.append(" NOT");
                }
                sb.append(" IN (");
                for (int i = 0; i < metricsIn.size(); ++i) {
                    sb.append("?");
                    if (i >= metricsIn.size() - 1) continue;
                    sb.append(", ");
                }
                sb.append(")");
                appendConjunction = true;
            }
            if (CollectionUtils.isNotEmpty(metricsIn) && CollectionUtils.isNotEmpty(metricsLike)) {
                if (this.metricNamesNotCondition) {
                    sb.append(" AND ");
                } else {
                    sb.append(" OR ");
                }
            }
            if (CollectionUtils.isNotEmpty(metricsLike)) {
                for (int i = 0; i < metricsLike.size(); ++i) {
                    sb.append("METRIC_NAME");
                    if (this.metricNamesNotCondition) {
                        sb.append(" NOT");
                    }
                    sb.append(" LIKE ");
                    sb.append("?");
                    if (i >= metricsLike.size() - 1) continue;
                    if (this.metricNamesNotCondition) {
                        sb.append(" AND ");
                        continue;
                    }
                    sb.append(" OR ");
                }
                appendConjunction = true;
            }
            if (appendConjunction) {
                sb.append(")");
            }
            this.metricNames.clear();
            if (CollectionUtils.isNotEmpty(metricsIn)) {
                this.metricNames.addAll(metricsIn);
            }
            if (CollectionUtils.isNotEmpty(metricsLike)) {
                this.metricNames.addAll(metricsLike);
            }
        }
        return appendConjunction;
    }

    protected boolean appendHostnameClause(StringBuilder sb, boolean appendConjunction) {
        boolean hostnameContainsRegex = false;
        if (this.hostnames != null) {
            for (String hostname : this.hostnames) {
                if (!hostname.contains("%")) continue;
                hostnameContainsRegex = true;
                break;
            }
        }
        StringBuilder hostnamesCondition = new StringBuilder();
        if (hostnameContainsRegex) {
            hostnamesCondition.append(" (");
            for (String hostname : this.getHostnames()) {
                if (hostnamesCondition.length() > 2) {
                    hostnamesCondition.append(" OR ");
                }
                hostnamesCondition.append("HOSTNAME LIKE ?");
            }
            hostnamesCondition.append(")");
            appendConjunction = TransientMetricCondition.append(sb, appendConjunction, this.getHostnames(), hostnamesCondition.toString());
        } else if (CollectionUtils.isNotEmpty((Collection)this.hostnames)) {
            for (String hostname : this.getHostnames()) {
                if (hostnamesCondition.length() > 0) {
                    hostnamesCondition.append(" ,");
                } else {
                    hostnamesCondition.append(" HOSTNAME IN (");
                }
                hostnamesCondition.append('?');
            }
            hostnamesCondition.append(')');
            appendConjunction = TransientMetricCondition.append(sb, appendConjunction, this.getHostnames(), hostnamesCondition.toString());
        } else {
            appendConjunction = TransientMetricCondition.append(sb, appendConjunction, this.getHostnames(), " HOSTNAME = ?");
        }
        return appendConjunction;
    }

    @Override
    public String toString() {
        return "Condition{metricNames=" + this.metricNames + ", hostnames='" + this.hostnames + "', appId='" + this.appId + "', instanceId='" + this.instanceId + "', startTime=" + this.startTime + ", endTime=" + this.endTime + ", limit=" + this.limit + ", grouped=" + this.grouped + ", orderBy=" + this.orderByColumns + ", noLimit=" + this.noLimit + "}";
    }

    @Override
    public List<String> getTransientMetricNames() {
        return this.transientMetricNames;
    }
}

