/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.query;

import java.util.Collection;
import java.util.List;
import org.apache.ambari.metrics.core.timeline.aggregators.Function;
import org.apache.ambari.metrics.core.timeline.query.DefaultCondition;
import org.apache.ambari.metrics.core.timeline.query.PhoenixTransactSQL;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.sink.timeline.Precision;

public class TopNCondition
extends DefaultCondition {
    private Integer topN;
    private boolean isBottomN;
    private Function topNFunction;
    private static final Log LOG = LogFactory.getLog(TopNCondition.class);

    public TopNCondition(List<byte[]> uuids, List<String> metricNames, List<String> hostnames, String appId, String instanceId, Long startTime, Long endTime, Precision precision, Integer limit, boolean grouped, Integer topN, Function topNFunction, boolean isBottomN) {
        super(uuids, metricNames, hostnames, appId, instanceId, startTime, endTime, precision, limit, grouped);
        this.topN = topN;
        this.isBottomN = isBottomN;
        this.topNFunction = topNFunction;
    }

    @Override
    public StringBuilder getConditionClause() {
        if (!TopNCondition.isTopNHostCondition(this.metricNames, this.hostnames) && !TopNCondition.isTopNMetricCondition(this.metricNames, this.hostnames)) {
            LOG.error((Object)"Unsupported TopN Operation requested. Query can have either multiple hosts or multiple metric names but not both.");
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" UUID IN (");
        sb.append(this.getTopNInnerQuery());
        sb.append(")");
        boolean appendConjunction = true;
        appendConjunction = TopNCondition.append(sb, appendConjunction, this.getStartTime(), " SERVER_TIME >= ?");
        TopNCondition.append(sb, appendConjunction, this.getEndTime(), " SERVER_TIME < ?");
        return sb;
    }

    public String getTopNInnerQuery() {
        return String.format("SELECT UUID FROM %s WHERE %s GROUP BY UUID ORDER BY %s LIMIT %s", PhoenixTransactSQL.getTargetTableUsingPrecision(this.precision, CollectionUtils.isNotEmpty((Collection)this.hostnames)), super.getConditionClause().toString(), this.getTopNOrderByClause(), this.topN);
    }

    private String getTopNOrderByClause() {
        Object orderByClause = TopNCondition.getColumnSelect(this.topNFunction);
        orderByClause = (String)orderByClause + (this.isBottomN ? " ASC" : " DESC");
        return orderByClause;
    }

    public static String getColumnSelect(Function topNFunction) {
        String columnSelect = null;
        if (topNFunction != null) {
            switch (topNFunction.getReadFunction()) {
                case AVG: {
                    columnSelect = "ROUND(AVG(METRIC_SUM),2)";
                    break;
                }
                case SUM: {
                    columnSelect = "SUM(METRIC_SUM)";
                    break;
                }
                default: {
                    columnSelect = "MAX(METRIC_MAX)";
                }
            }
        }
        if (columnSelect == null) {
            columnSelect = "MAX(METRIC_MAX)";
        }
        return columnSelect;
    }

    public boolean isTopNHostCondition() {
        return TopNCondition.isTopNHostCondition(this.metricNames, this.hostnames);
    }

    public boolean isTopNMetricCondition() {
        return TopNCondition.isTopNMetricCondition(this.metricNames, this.hostnames);
    }

    public static boolean isTopNHostCondition(List<String> metricNames, List<String> hostnames) {
        return CollectionUtils.isNotEmpty(hostnames) && metricNames.size() == 1 && !TopNCondition.metricNamesHaveWildcard(metricNames);
    }

    public static boolean isTopNMetricCondition(List<String> metricNames, List<String> hostnames) {
        return CollectionUtils.isNotEmpty(metricNames) && (hostnames == null || hostnames.size() <= 1) && !TopNCondition.hostNamesHaveWildcard(hostnames);
    }

    public Integer getTopN() {
        return this.topN;
    }

    public void setTopN(Integer topN) {
        this.topN = topN;
    }

    public boolean isBottomN() {
        return this.isBottomN;
    }

    public void setIsBottomN(boolean isBottomN) {
        this.isBottomN = isBottomN;
    }

    public Function getTopNFunction() {
        return this.topNFunction;
    }

    public void setTopNFunction(Function topNFunction) {
        this.topNFunction = topNFunction;
    }
}

