/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.query;

import java.util.Collections;
import java.util.List;
import org.apache.ambari.metrics.core.timeline.query.Condition;
import org.apache.ambari.metrics.core.timeline.query.DefaultCondition;
import org.apache.hadoop.metrics2.sink.timeline.Precision;

public class SplitByMetricNamesCondition
implements Condition {
    private final Condition adaptee;
    private byte[] currentUuid;
    private boolean metricNamesNotCondition = false;

    public SplitByMetricNamesCondition(Condition condition) {
        this.adaptee = condition;
    }

    @Override
    public boolean isEmpty() {
        return this.adaptee.isEmpty();
    }

    @Override
    public List<byte[]> getUuids() {
        return this.adaptee.getUuids();
    }

    @Override
    public List<String> getMetricNames() {
        return Collections.singletonList(new String(this.currentUuid));
    }

    @Override
    public List<String> getTransientMetricNames() {
        return null;
    }

    @Override
    public boolean isPointInTime() {
        return this.adaptee.isPointInTime();
    }

    @Override
    public boolean isGrouped() {
        return this.adaptee.isGrouped();
    }

    @Override
    public void setStatement(String statement) {
        this.adaptee.setStatement(statement);
    }

    @Override
    public List<String> getHostnames() {
        return this.adaptee.getHostnames();
    }

    @Override
    public Precision getPrecision() {
        return this.adaptee.getPrecision();
    }

    @Override
    public void setPrecision(Precision precision) {
        this.adaptee.setPrecision(precision);
    }

    @Override
    public String getAppId() {
        return this.adaptee.getAppId();
    }

    @Override
    public String getInstanceId() {
        return this.adaptee.getInstanceId();
    }

    @Override
    public StringBuilder getConditionClause() {
        StringBuilder sb = new StringBuilder();
        boolean appendConjunction = false;
        if (this.getMetricNames() != null) {
            for (String name : this.getMetricNames()) {
                if (sb.length() > 1) {
                    sb.append(" OR ");
                }
                sb.append("UUID = ?");
            }
            appendConjunction = true;
        }
        appendConjunction = DefaultCondition.append(sb, appendConjunction, this.getStartTime(), " SERVER_TIME >= ?");
        DefaultCondition.append(sb, appendConjunction, this.getEndTime(), " SERVER_TIME < ?");
        return sb;
    }

    @Override
    public String getOrderByClause(boolean asc) {
        return this.adaptee.getOrderByClause(asc);
    }

    @Override
    public String getStatement() {
        return this.adaptee.getStatement();
    }

    @Override
    public Long getStartTime() {
        return this.adaptee.getStartTime();
    }

    @Override
    public Long getEndTime() {
        return this.adaptee.getEndTime();
    }

    @Override
    public Integer getLimit() {
        return this.adaptee.getLimit();
    }

    @Override
    public Integer getFetchSize() {
        return this.adaptee.getFetchSize();
    }

    @Override
    public void setFetchSize(Integer fetchSize) {
        this.adaptee.setFetchSize(fetchSize);
    }

    @Override
    public void addOrderByColumn(String column) {
        this.adaptee.addOrderByColumn(column);
    }

    @Override
    public void setNoLimit() {
        this.adaptee.setNoLimit();
    }

    @Override
    public boolean doUpdate() {
        return false;
    }

    public List<String> getOriginalMetricNames() {
        return this.adaptee.getMetricNames();
    }

    public void setCurrentUuid(byte[] uuid) {
        this.currentUuid = uuid;
    }

    public byte[] getCurrentUuid() {
        return this.currentUuid;
    }

    @Override
    public void setMetricNamesNotCondition(boolean metricNamesNotCondition) {
        this.metricNamesNotCondition = metricNamesNotCondition;
    }

    @Override
    public void setHostnamesNotCondition(boolean hostNamesNotCondition) {
    }

    @Override
    public void setUuidNotCondition(boolean uuidNotCondition) {
    }
}

