/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.query;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ambari.metrics.core.timeline.query.TransientMetricCondition;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class MetadataQueryCondition
extends TransientMetricCondition {
    private boolean isMetricMetadataCondition = true;

    public MetadataQueryCondition(List<String> metricNames, String appId, String instanceId) {
        super(metricNames, (List<String>)Collections.EMPTY_LIST, appId, instanceId, null, null, null, null, true, null);
        this.hostnames = Collections.EMPTY_LIST;
    }

    public MetadataQueryCondition(List<String> hostnames) {
        super(Collections.EMPTY_LIST, hostnames, "", "", null, null, null, null, true, null);
        this.isMetricMetadataCondition = false;
    }

    @Override
    public StringBuilder getConditionClause() {
        String instanceId;
        String appId;
        StringBuilder sb = new StringBuilder();
        boolean appendConjunction = false;
        if (CollectionUtils.isNotEmpty((Collection)this.metricNames)) {
            appendConjunction = this.appendMetricNameClause(sb);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.hostnames)) {
            appendConjunction = this.appendHostnameClause(sb, appendConjunction);
        }
        if (StringUtils.isNotEmpty((String)(appId = this.getAppId()))) {
            appendConjunction = appId.contains("%") ? MetadataQueryCondition.append(sb, appendConjunction, appId, " APP_ID LIKE ?") : MetadataQueryCondition.append(sb, appendConjunction, appId, " APP_ID = ?");
        }
        if (StringUtils.isNotEmpty((String)(instanceId = this.getInstanceId())) && !"%".equals(instanceId)) {
            appendConjunction = instanceId.contains("%") ? MetadataQueryCondition.append(sb, appendConjunction, instanceId, " INSTANCE_ID LIKE ?") : MetadataQueryCondition.append(sb, appendConjunction, instanceId, " INSTANCE_ID = ?");
        }
        return sb;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId == null || "%".equals(this.instanceId) || this.instanceId.isEmpty() ? null : this.instanceId;
    }

    public boolean isMetricMetadataCondition() {
        return this.isMetricMetadataCondition;
    }
}

