/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.ambari.metrics.core.timeline.PhoenixHBaseAccessor;
import org.apache.ambari.metrics.core.timeline.query.Condition;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.sink.timeline.Precision;

public class DefaultCondition
implements Condition {
    List<String> metricNames;
    List<String> hostnames;
    String appId;
    String instanceId;
    Long startTime;
    Long endTime;
    Precision precision;
    Integer limit;
    boolean grouped;
    boolean noLimit = false;
    Integer fetchSize;
    String statement;
    Set<String> orderByColumns = new LinkedHashSet<String>();
    boolean metricNamesNotCondition = false;
    boolean hostNamesNotCondition = false;
    boolean uuidNotCondition = false;
    List<byte[]> uuids = new ArrayList<byte[]>();
    private static final Log LOG = LogFactory.getLog(DefaultCondition.class);

    public DefaultCondition(List<String> metricNames, List<String> hostnames, String appId, String instanceId, Long startTime, Long endTime, Precision precision, Integer limit, boolean grouped) {
        this.metricNames = metricNames;
        this.hostnames = hostnames;
        this.appId = appId;
        this.instanceId = instanceId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.precision = precision;
        this.limit = limit;
        this.grouped = grouped;
    }

    public DefaultCondition(List<byte[]> uuids, List<String> metricNames, List<String> hostnames, String appId, String instanceId, Long startTime, Long endTime, Precision precision, Integer limit, boolean grouped) {
        this.uuids = uuids;
        this.metricNames = metricNames;
        this.hostnames = hostnames;
        this.appId = appId;
        this.instanceId = instanceId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.precision = precision;
        this.limit = limit;
        this.grouped = grouped;
    }

    @Override
    public String getStatement() {
        return this.statement;
    }

    @Override
    public void setStatement(String statement) {
        this.statement = statement;
    }

    @Override
    public List<String> getMetricNames() {
        return this.metricNames == null || this.metricNames.isEmpty() ? null : this.metricNames;
    }

    @Override
    public StringBuilder getConditionClause() {
        StringBuilder sb = new StringBuilder();
        boolean appendConjunction = this.appendUuidClause(sb);
        appendConjunction = DefaultCondition.append(sb, appendConjunction, this.getStartTime(), " SERVER_TIME >= ?");
        DefaultCondition.append(sb, appendConjunction, this.getEndTime(), " SERVER_TIME < ?");
        return sb;
    }

    protected static boolean append(StringBuilder sb, boolean appendConjunction, Object value, String str) {
        if (value != null) {
            if (appendConjunction) {
                sb.append(" AND");
            }
            sb.append(str);
            appendConjunction = true;
        }
        return appendConjunction;
    }

    @Override
    public List<String> getHostnames() {
        return this.hostnames;
    }

    @Override
    public Precision getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(Precision precision) {
        this.precision = precision;
    }

    @Override
    public String getAppId() {
        if (this.appId != null && !this.appId.isEmpty()) {
            if (!this.appId.equals("HOST") && !this.appId.equals("FLUME_HANDLER")) {
                return this.appId.toLowerCase();
            }
            return this.appId;
        }
        return null;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId == null || this.instanceId.isEmpty() ? null : this.instanceId;
    }

    @Override
    public Long getStartTime() {
        if (this.startTime == null) {
            return null;
        }
        if (this.startTime < 9999999999L) {
            return this.startTime * 1000L;
        }
        return this.startTime;
    }

    @Override
    public Long getEndTime() {
        if (this.endTime == null) {
            return null;
        }
        if (this.endTime < 9999999999L) {
            return this.endTime * 1000L;
        }
        return this.endTime;
    }

    @Override
    public void setNoLimit() {
        this.noLimit = true;
    }

    @Override
    public boolean doUpdate() {
        return false;
    }

    @Override
    public Integer getLimit() {
        if (this.noLimit) {
            return null;
        }
        return this.limit == null ? PhoenixHBaseAccessor.RESULTSET_LIMIT : this.limit;
    }

    @Override
    public boolean isGrouped() {
        return this.grouped;
    }

    @Override
    public boolean isPointInTime() {
        return this.getStartTime() == null && this.getEndTime() == null;
    }

    @Override
    public boolean isEmpty() {
        return !(this.metricNames != null && !this.metricNames.isEmpty() || this.hostnames != null && !this.hostnames.isEmpty() || this.appId != null && !this.appId.isEmpty() || this.instanceId != null && !this.instanceId.isEmpty() || this.startTime != null || this.endTime != null);
    }

    @Override
    public Integer getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    public void addOrderByColumn(String column) {
        this.orderByColumns.add(column);
    }

    @Override
    public String getOrderByClause(boolean asc) {
        String orderByStr = " ORDER BY ";
        if (!this.orderByColumns.isEmpty()) {
            StringBuilder sb = new StringBuilder(orderByStr);
            for (String orderByColumn : this.orderByColumns) {
                if (sb.length() != orderByStr.length()) {
                    sb.append(", ");
                }
                sb.append(orderByColumn);
                if (asc) continue;
                sb.append(" DESC");
            }
            sb.append(" ");
            return sb.toString();
        }
        return null;
    }

    protected boolean appendUuidClause(StringBuilder sb) {
        boolean appendConjunction = false;
        if (CollectionUtils.isNotEmpty(this.uuids)) {
            sb.append("(");
            if (CollectionUtils.isNotEmpty(this.uuids)) {
                sb.append("UUID");
                if (this.metricNamesNotCondition) {
                    sb.append(" NOT");
                }
                sb.append(" IN (");
                for (int i = 0; i < this.uuids.size(); ++i) {
                    sb.append("?");
                    if (i >= this.uuids.size() - 1) continue;
                    sb.append(", ");
                }
                sb.append(")");
            }
            appendConjunction = true;
            sb.append(")");
        }
        return appendConjunction;
    }

    public String toString() {
        return "Condition{uuids=" + this.uuids + ", appId='" + this.appId + "', instanceId='" + this.instanceId + "', startTime=" + this.startTime + ", endTime=" + this.endTime + ", limit=" + this.limit + ", grouped=" + this.grouped + ", orderBy=" + this.orderByColumns + ", noLimit=" + this.noLimit + "}";
    }

    protected static boolean metricNamesHaveWildcard(List<String> metricNames) {
        for (String name : metricNames) {
            if (!name.contains("%")) continue;
            return true;
        }
        return false;
    }

    protected static boolean hostNamesHaveWildcard(List<String> hostnames) {
        if (hostnames == null) {
            return false;
        }
        for (String name : hostnames) {
            if (!name.contains("%")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setMetricNamesNotCondition(boolean metricNamesNotCondition) {
        this.metricNamesNotCondition = metricNamesNotCondition;
    }

    @Override
    public void setHostnamesNotCondition(boolean hostNamesNotCondition) {
        this.hostNamesNotCondition = hostNamesNotCondition;
    }

    @Override
    public void setUuidNotCondition(boolean uuidNotCondition) {
        this.uuidNotCondition = uuidNotCondition;
    }

    @Override
    public List<byte[]> getUuids() {
        return this.uuids;
    }

    @Override
    public List<String> getTransientMetricNames() {
        return Collections.EMPTY_LIST;
    }
}

