/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.function;

import org.apache.ambari.metrics.core.timeline.aggregators.Function;
import org.apache.ambari.metrics.core.timeline.function.SeriesAggregateFunction;
import org.apache.ambari.metrics.core.timeline.function.TimelineMetricsSeriesAggregateFunction;
import org.apache.ambari.metrics.core.timeline.function.TimelineMetricsSeriesAvgAggregateFunction;
import org.apache.ambari.metrics.core.timeline.function.TimelineMetricsSeriesMaxAggregateFunction;
import org.apache.ambari.metrics.core.timeline.function.TimelineMetricsSeriesMinAggregateFunction;
import org.apache.ambari.metrics.core.timeline.function.TimelineMetricsSeriesSumAggregateFunction;

public class TimelineMetricsSeriesAggregateFunctionFactory {
    private TimelineMetricsSeriesAggregateFunctionFactory() {
    }

    public static TimelineMetricsSeriesAggregateFunction newInstance(SeriesAggregateFunction func) {
        switch (func) {
            case AVG: {
                return new TimelineMetricsSeriesAvgAggregateFunction();
            }
            case MIN: {
                return new TimelineMetricsSeriesMinAggregateFunction();
            }
            case MAX: {
                return new TimelineMetricsSeriesMaxAggregateFunction();
            }
            case SUM: {
                return new TimelineMetricsSeriesSumAggregateFunction();
            }
        }
        throw new Function.FunctionFormatException("Function should be sum, avg, min, max. Got " + func.name());
    }
}

