/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.function;

import com.google.common.base.Joiner;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.ambari.metrics.core.timeline.function.TimelineMetricsSeriesAggregateFunction;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;

public abstract class AbstractTimelineMetricsSeriesAggregateFunction
implements TimelineMetricsSeriesAggregateFunction {
    @Override
    public TimelineMetric apply(TimelineMetrics timelineMetrics) {
        TreeSet<String> metricNameSet = new TreeSet<String>();
        TreeSet<String> hostNameSet = new TreeSet<String>();
        TreeSet<String> appIdSet = new TreeSet<String>();
        TreeSet<String> instanceIdSet = new TreeSet<String>();
        TreeMap metricValues = new TreeMap();
        for (Object timelineMetric2 : timelineMetrics.getMetrics()) {
            metricNameSet.add(timelineMetric2.getMetricName());
            this.addToSetOnlyNotNull(hostNameSet, timelineMetric2.getHostName());
            this.addToSetOnlyNotNull(appIdSet, timelineMetric2.getAppId());
            this.addToSetOnlyNotNull(instanceIdSet, timelineMetric2.getInstanceId());
            for (Map.Entry metricValue : timelineMetric2.getMetricValues().entrySet()) {
                Long timestamp = (Long)metricValue.getKey();
                Double value = (Double)metricValue.getValue();
                if (!metricValues.containsKey(timestamp)) {
                    metricValues.put(timestamp, new LinkedList());
                }
                ((List)metricValues.get(timestamp)).add(value);
            }
        }
        TreeMap<Long, Double> aggregatedMetricValues = new TreeMap<Long, Double>();
        for (Map.Entry entry : metricValues.entrySet()) {
            List values = (List)entry.getValue();
            if (values.size() == 0) {
                throw new IllegalArgumentException("count of values should be more than 0");
            }
            aggregatedMetricValues.put((Long)entry.getKey(), this.applyFunction(values));
        }
        TimelineMetric timelineMetric = new TimelineMetric();
        timelineMetric.setMetricName(this.getMetricName(metricNameSet.iterator()));
        timelineMetric.setHostName(this.joinStringsWithComma(hostNameSet.iterator()));
        timelineMetric.setAppId(this.joinStringsWithComma(appIdSet.iterator()));
        timelineMetric.setInstanceId(this.joinStringsWithComma(instanceIdSet.iterator()));
        if (aggregatedMetricValues.size() > 0) {
            timelineMetric.setStartTime(((Long)aggregatedMetricValues.firstKey()).longValue());
        }
        timelineMetric.setMetricValues(aggregatedMetricValues);
        return timelineMetric;
    }

    protected String getMetricName(Iterator<String> metricNames) {
        return this.getFunctionName() + "(" + Joiner.on((String)",").join(metricNames) + ")";
    }

    protected String joinStringsWithComma(Iterator<String> hostNames) {
        return Joiner.on((String)",").join(hostNames);
    }

    protected abstract Double applyFunction(List<Double> var1);

    protected abstract String getFunctionName();

    private void addToSetOnlyNotNull(Set<String> set, String value) {
        if (value != null) {
            set.add(value);
        }
    }
}

