/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.discovery;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricHostMetadata;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataKey;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetricMetadata;

public class TimelineMetricMetadataSync
implements Runnable {
    private static final Log LOG = LogFactory.getLog(TimelineMetricMetadataSync.class);
    private final TimelineMetricMetadataManager cacheManager;

    public TimelineMetricMetadataSync(TimelineMetricMetadataManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void run() {
        LOG.debug((Object)"Persisting metric metadata...");
        this.persistMetricMetadata();
        LOG.debug((Object)"Persisting hosted apps metadata...");
        this.persistHostAppsMetadata();
        LOG.debug((Object)"Persisting hosted instance metadata...");
        this.persistHostInstancesMetadata();
        if (this.cacheManager.isDistributedModeEnabled()) {
            LOG.debug((Object)"Refreshing metric metadata...");
            this.refreshMetricMetadata();
            LOG.debug((Object)"Refreshing hosted apps metadata...");
            this.refreshHostAppsMetadata();
            LOG.debug((Object)"Refreshing hosted instances metadata...");
            this.refreshHostedInstancesMetadata();
        }
    }

    private void persistMetricMetadata() {
        ArrayList<TimelineMetricMetadata> metadataToPersist = new ArrayList<TimelineMetricMetadata>();
        for (TimelineMetricMetadata metadata : this.cacheManager.getMetadataCache().values()) {
            if (metadata.isPersisted()) continue;
            metadataToPersist.add(metadata);
        }
        boolean markSuccess = false;
        if (!metadataToPersist.isEmpty()) {
            try {
                this.cacheManager.persistMetadata(metadataToPersist);
                markSuccess = true;
            }
            catch (SQLException e) {
                LOG.warn((Object)"Error persisting metadata.", (Throwable)e);
            }
        }
        if (markSuccess) {
            for (TimelineMetricMetadata metadata : metadataToPersist) {
                TimelineMetricMetadataKey key = new TimelineMetricMetadataKey(metadata.getMetricName(), metadata.getAppId(), metadata.getInstanceId());
                metadata.setIsPersisted(true);
                this.cacheManager.getMetadataCache().put(key, metadata);
            }
        }
    }

    private void refreshMetricMetadata() {
        Map<TimelineMetricMetadataKey, TimelineMetricMetadata> metadataFromStore = null;
        try {
            metadataFromStore = this.cacheManager.getMetadataFromStore();
        }
        catch (SQLException e) {
            LOG.warn((Object)"Error refreshing metadata from store.", (Throwable)e);
        }
        if (metadataFromStore != null) {
            Map<TimelineMetricMetadataKey, TimelineMetricMetadata> cachedMetadata = this.cacheManager.getMetadataCache();
            for (Map.Entry<TimelineMetricMetadataKey, TimelineMetricMetadata> metadataEntry : metadataFromStore.entrySet()) {
                if (cachedMetadata.containsKey(metadataEntry.getKey())) continue;
                cachedMetadata.put(metadataEntry.getKey(), metadataEntry.getValue());
                this.cacheManager.addMetricsInUuidMap(metadataEntry.getValue().getUuid(), metadataEntry.getKey());
            }
        }
    }

    private void persistHostAppsMetadata() {
        if (this.cacheManager.syncHostedAppsMetadata()) {
            Map<String, TimelineMetricHostMetadata> persistedData = null;
            try {
                persistedData = this.cacheManager.getHostedAppsFromStore();
            }
            catch (SQLException e) {
                LOG.warn((Object)"Failed on fetching hosted apps data from store.", (Throwable)e);
                return;
            }
            Map<String, TimelineMetricHostMetadata> cachedData = this.cacheManager.getHostedAppsCache();
            HashMap<String, TimelineMetricHostMetadata> dataToSync = new HashMap<String, TimelineMetricHostMetadata>();
            if (cachedData != null && !cachedData.isEmpty()) {
                for (Map.Entry<String, TimelineMetricHostMetadata> cacheEntry : cachedData.entrySet()) {
                    if (persistedData != null && !persistedData.isEmpty() && persistedData.containsKey(cacheEntry.getKey()) && ((ConcurrentHashMap.CollectionView)((Object)persistedData.get(cacheEntry.getKey()).getHostedApps().keySet())).containsAll(cacheEntry.getValue().getHostedApps().keySet())) continue;
                    dataToSync.put(cacheEntry.getKey(), cacheEntry.getValue());
                }
                try {
                    this.cacheManager.persistHostedAppsMetadata(dataToSync);
                    this.cacheManager.markSuccessOnSyncHostedAppsMetadata();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Error persisting hosted apps metadata.", (Throwable)e);
                }
            }
        }
    }

    private void persistHostInstancesMetadata() {
        if (this.cacheManager.syncHostedInstanceMetadata()) {
            Map<String, Set<String>> persistedData = null;
            try {
                persistedData = this.cacheManager.getHostedInstancesFromStore();
            }
            catch (SQLException e) {
                LOG.warn((Object)"Failed on fetching hosted instances data from store.", (Throwable)e);
                return;
            }
            Map<String, Set<String>> cachedData = this.cacheManager.getHostedInstanceCache();
            HashMap<String, Set<String>> dataToSync = new HashMap<String, Set<String>>();
            if (cachedData != null && !cachedData.isEmpty()) {
                for (Map.Entry<String, Set<String>> cacheEntry : cachedData.entrySet()) {
                    if (persistedData != null && !persistedData.isEmpty() && persistedData.containsKey(cacheEntry.getKey()) && persistedData.get(cacheEntry.getKey()).containsAll((Collection)cacheEntry.getValue())) continue;
                    dataToSync.put(cacheEntry.getKey(), cacheEntry.getValue());
                }
                try {
                    this.cacheManager.persistHostedInstanceMetadata(dataToSync);
                    this.cacheManager.markSuccessOnSyncHostedInstanceMetadata();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Error persisting hosted apps metadata.", (Throwable)e);
                }
            }
        }
    }

    private void refreshHostAppsMetadata() {
        Map<String, TimelineMetricHostMetadata> hostedAppsDataFromStore = null;
        try {
            hostedAppsDataFromStore = this.cacheManager.getHostedAppsFromStore();
        }
        catch (SQLException e) {
            LOG.warn((Object)"Error refreshing metadata from store.", (Throwable)e);
        }
        if (hostedAppsDataFromStore != null) {
            Map<String, TimelineMetricHostMetadata> cachedData = this.cacheManager.getHostedAppsCache();
            for (Map.Entry<String, TimelineMetricHostMetadata> storeEntry : hostedAppsDataFromStore.entrySet()) {
                if (!cachedData.containsKey(storeEntry.getKey())) {
                    this.cacheManager.addHostInUuidHostMap(storeEntry.getKey(), storeEntry.getValue());
                    cachedData.put(storeEntry.getKey(), storeEntry.getValue());
                    continue;
                }
                if (((ConcurrentHashMap.CollectionView)((Object)cachedData.get(storeEntry.getKey()).getHostedApps().keySet())).containsAll(storeEntry.getValue().getHostedApps().keySet())) continue;
                cachedData.put(storeEntry.getKey(), storeEntry.getValue());
            }
        }
    }

    private void refreshHostedInstancesMetadata() {
        Map<String, Set<String>> hostedInstancesFromStore = null;
        try {
            hostedInstancesFromStore = this.cacheManager.getHostedInstancesFromStore();
        }
        catch (SQLException e) {
            LOG.warn((Object)"Error refreshing metadata from store.", (Throwable)e);
        }
        if (hostedInstancesFromStore != null) {
            Map<String, Set<String>> cachedData = this.cacheManager.getHostedInstanceCache();
            for (Map.Entry<String, Set<String>> storeEntry : hostedInstancesFromStore.entrySet()) {
                if (cachedData.containsKey(storeEntry.getKey())) continue;
                cachedData.put(storeEntry.getKey(), storeEntry.getValue());
            }
        }
    }
}

