/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.core.timeline.discovery;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ambari.metrics.core.timeline.MetricsSystemInitializationException;
import org.apache.ambari.metrics.core.timeline.PhoenixHBaseAccessor;
import org.apache.ambari.metrics.core.timeline.TimelineMetricConfiguration;
import org.apache.ambari.metrics.core.timeline.aggregators.TimelineClusterMetric;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricHostMetadata;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataKey;
import org.apache.ambari.metrics.core.timeline.discovery.TimelineMetricMetadataSync;
import org.apache.ambari.metrics.core.timeline.uuid.MetricUuidGenStrategy;
import org.apache.ambari.metrics.core.timeline.uuid.Murmur3HashUuidGenStrategy;
import org.apache.ambari.metrics.core.timeline.uuid.TimelineMetricUuid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.sink.timeline.MetadataException;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetricMetadata;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetricUtils;

public class TimelineMetricMetadataManager {
    private static final Log LOG = LogFactory.getLog(TimelineMetricMetadataManager.class);
    private final Map<TimelineMetricMetadataKey, TimelineMetricMetadata> METADATA_CACHE = new ConcurrentHashMap<TimelineMetricMetadataKey, TimelineMetricMetadata>();
    private final Map<TimelineMetricUuid, TimelineMetricMetadataKey> uuidKeyMap = new ConcurrentHashMap<TimelineMetricUuid, TimelineMetricMetadataKey>();
    private final Map<String, TimelineMetricHostMetadata> HOSTED_APPS_MAP = new ConcurrentHashMap<String, TimelineMetricHostMetadata>();
    private final Map<TimelineMetricUuid, String> uuidHostMap = new ConcurrentHashMap<TimelineMetricUuid, String>();
    private final Map<String, Set<String>> INSTANCE_HOST_MAP = new ConcurrentHashMap<String, Set<String>>();
    AtomicBoolean SYNC_HOSTED_APPS_METADATA = new AtomicBoolean(false);
    AtomicBoolean SYNC_HOSTED_INSTANCES_METADATA = new AtomicBoolean(false);
    private MetricUuidGenStrategy uuidGenStrategy = new Murmur3HashUuidGenStrategy();
    public static final int TIMELINE_METRIC_UUID_LENGTH = 16;
    public static int HOSTNAME_UUID_LENGTH = 4;
    private List<String> transientMetricPatterns = new ArrayList<String>();
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private PhoenixHBaseAccessor hBaseAccessor;
    private Configuration metricsConf;
    TimelineMetricMetadataSync metricMetadataSync;
    private final List<String> metricNameFilters = new ArrayList<String>();

    public TimelineMetricMetadataManager(Configuration metricsConf, PhoenixHBaseAccessor hBaseAccessor) {
        this.metricsConf = metricsConf;
        this.hBaseAccessor = hBaseAccessor;
        String patternStrings = metricsConf.get("timeline.metrics.service.metadata.filters");
        if (!StringUtils.isEmpty((String)patternStrings)) {
            this.metricNameFilters.addAll(Arrays.asList(patternStrings.split(",")));
        }
        this.uuidGenStrategy = this.getUuidStrategy(metricsConf);
        String transientMetricPatternsString = metricsConf.get("timeline.metrics.transient.metric.patterns", "");
        if (StringUtils.isNotEmpty((String)transientMetricPatternsString)) {
            LOG.info((Object)("Skipping UUID for patterns : " + transientMetricPatternsString));
            this.transientMetricPatterns.addAll(TimelineMetricUtils.getJavaMetricPatterns((String)transientMetricPatternsString));
        }
    }

    public TimelineMetricMetadataManager(PhoenixHBaseAccessor hBaseAccessor) throws MalformedURLException, URISyntaxException {
        this(TimelineMetricConfiguration.getInstance().getMetricsConf(), hBaseAccessor);
    }

    public void initializeMetadata() {
        this.initializeMetadata(true);
    }

    public void initializeMetadata(boolean scheduleMetadateSync) {
        Connection conn = null;
        Statement stmt = null;
        String encoding = this.metricsConf.get("timeline.metrics.hbase.data.block.encoding", "FAST_DIFF");
        String compression = this.metricsConf.get("timeline.metrics.hbase.compression.scheme", "SNAPPY");
        try {
            LOG.info((Object)"Initializing metrics metadata schema...");
            conn = this.hBaseAccessor.getConnectionRetryingOnException();
            stmt = conn.createStatement();
            String metadataSql = String.format("CREATE TABLE IF NOT EXISTS METRICS_METADATA_UUID (METRIC_NAME VARCHAR, APP_ID VARCHAR, INSTANCE_ID VARCHAR, UUID BINARY(16), UNITS CHAR(20), TYPE CHAR(20), START_TIME UNSIGNED_LONG, SUPPORTS_AGGREGATION BOOLEAN, IS_WHITELISTED BOOLEAN CONSTRAINT pk PRIMARY KEY (METRIC_NAME, APP_ID, INSTANCE_ID)) DATA_BLOCK_ENCODING='%s', COMPRESSION='%s'", encoding, compression);
            stmt.executeUpdate(metadataSql);
            String hostedAppSql = String.format("CREATE TABLE IF NOT EXISTS HOSTED_APPS_METADATA_UUID (HOSTNAME VARCHAR, UUID BINARY(4), APP_IDS VARCHAR, CONSTRAINT pk PRIMARY KEY (HOSTNAME))DATA_BLOCK_ENCODING='%s', COMPRESSION='%s'", encoding, compression);
            stmt.executeUpdate(hostedAppSql);
            String hostedInstancesSql = String.format("CREATE TABLE IF NOT EXISTS INSTANCE_HOST_METADATA (INSTANCE_ID VARCHAR, HOSTNAME VARCHAR, CONSTRAINT pk PRIMARY KEY (INSTANCE_ID, HOSTNAME))DATA_BLOCK_ENCODING='%s', COMPRESSION='%s'", encoding, compression);
            stmt.executeUpdate(hostedInstancesSql);
        }
        catch (InterruptedException | SQLException sql) {
            LOG.error((Object)"Error creating Metrics Schema in HBase using Phoenix.", (Throwable)sql);
            throw new MetricsSystemInitializationException("Error creating Metrics Metadata Schema in HBase using Phoenix.", sql);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        this.metricMetadataSync = new TimelineMetricMetadataSync(this);
        if (scheduleMetadateSync) {
            this.executorService.scheduleWithFixedDelay(this.metricMetadataSync, this.metricsConf.getInt("timeline.metrics.service.metadata.sync.init.delay", 120), this.metricsConf.getInt("timeline.metrics.service.metadata.sync.delay", 300), TimeUnit.SECONDS);
        }
        try {
            Map<TimelineMetricMetadataKey, TimelineMetricMetadata> metadata = this.getMetadataFromStore();
            LOG.info((Object)("Retrieved " + metadata.size() + ", metadata objects from store."));
            this.METADATA_CACHE.putAll(metadata);
            Map<String, TimelineMetricHostMetadata> hostedAppData = this.getHostedAppsFromStore();
            LOG.info((Object)("Retrieved " + hostedAppData.size() + " host objects from store."));
            this.HOSTED_APPS_MAP.putAll(hostedAppData);
            this.loadUuidMapsOnInit();
            this.hBaseAccessor.setMetadataInstance(this);
        }
        catch (SQLException e) {
            LOG.warn((Object)"Exception loading metric metadata", (Throwable)e);
        }
    }

    public Map<TimelineMetricMetadataKey, TimelineMetricMetadata> getMetadataCache() {
        return this.METADATA_CACHE;
    }

    public TimelineMetricMetadata getMetadataCacheValue(TimelineMetricMetadataKey key) {
        return this.METADATA_CACHE.get(key);
    }

    public Map<String, TimelineMetricHostMetadata> getHostedAppsCache() {
        return this.HOSTED_APPS_MAP;
    }

    public Map<String, Set<String>> getHostedInstanceCache() {
        return this.INSTANCE_HOST_MAP;
    }

    public boolean syncHostedAppsMetadata() {
        return this.SYNC_HOSTED_APPS_METADATA.get();
    }

    public boolean syncHostedInstanceMetadata() {
        return this.SYNC_HOSTED_INSTANCES_METADATA.get();
    }

    public void markSuccessOnSyncHostedAppsMetadata() {
        this.SYNC_HOSTED_APPS_METADATA.set(false);
    }

    public void markSuccessOnSyncHostedInstanceMetadata() {
        this.SYNC_HOSTED_INSTANCES_METADATA.set(false);
    }

    boolean skipMetadataCache(String metricName) {
        for (String pattern : this.metricNameFilters) {
            if (!metricName.contains(pattern)) continue;
            return true;
        }
        return false;
    }

    public void putIfModifiedTimelineMetricMetadata(TimelineMetricMetadata metadata) {
        if (this.skipMetadataCache(metadata.getMetricName())) {
            return;
        }
        TimelineMetricMetadataKey key = new TimelineMetricMetadataKey(metadata.getMetricName(), metadata.getAppId(), metadata.getInstanceId());
        TimelineMetricMetadata metadataFromCache = this.METADATA_CACHE.get(key);
        if (metadataFromCache != null) {
            try {
                if (metadataFromCache.needsToBeSynced(metadata)) {
                    metadata.setIsPersisted(false);
                    this.METADATA_CACHE.put(key, metadata);
                }
            }
            catch (MetadataException e) {
                LOG.warn((Object)"Error inserting Metadata in cache.", (Throwable)e);
            }
        } else {
            this.METADATA_CACHE.put(key, metadata);
        }
    }

    public void putIfModifiedHostedAppsMetadata(String hostname, String appId) {
        ConcurrentHashMap<String, String> apps;
        TimelineMetricHostMetadata timelineMetricHostMetadata = this.HOSTED_APPS_MAP.get(hostname);
        ConcurrentHashMap<String, String> concurrentHashMap = apps = timelineMetricHostMetadata != null ? timelineMetricHostMetadata.getHostedApps() : null;
        if (apps == null) {
            apps = new ConcurrentHashMap();
            if (timelineMetricHostMetadata == null) {
                TimelineMetricHostMetadata newHostMetadata = new TimelineMetricHostMetadata(apps);
                this.HOSTED_APPS_MAP.put(hostname, newHostMetadata);
            } else {
                this.HOSTED_APPS_MAP.get(hostname).setHostedApps(apps);
            }
        }
        if (!apps.containsKey(appId)) {
            apps.put(appId, appId);
            this.SYNC_HOSTED_APPS_METADATA.set(true);
        }
    }

    public void putIfModifiedHostedInstanceMetadata(String instanceId, String hostname) {
        if (StringUtils.isEmpty((String)instanceId)) {
            return;
        }
        Set<String> hosts = this.INSTANCE_HOST_MAP.get(instanceId);
        if (hosts == null) {
            hosts = new HashSet<String>();
            this.INSTANCE_HOST_MAP.put(instanceId, hosts);
        }
        if (!hosts.contains(hostname)) {
            hosts.add(hostname);
            this.SYNC_HOSTED_INSTANCES_METADATA.set(true);
        }
    }

    public void persistMetadata(Collection<TimelineMetricMetadata> metadata) throws SQLException {
        this.hBaseAccessor.saveMetricMetadata(metadata);
    }

    public void persistHostedAppsMetadata(Map<String, TimelineMetricHostMetadata> hostedApps) throws SQLException {
        this.hBaseAccessor.saveHostAppsMetadata(hostedApps);
    }

    public void persistHostedInstanceMetadata(Map<String, Set<String>> hostedInstancesMetadata) throws SQLException {
        this.hBaseAccessor.saveInstanceHostsMetadata(hostedInstancesMetadata);
    }

    public TimelineMetricMetadata createTimelineMetricMetadata(TimelineMetric timelineMetric, boolean isWhitelisted) {
        TimelineMetricMetadata timelineMetricMetadata = new TimelineMetricMetadata(timelineMetric.getMetricName(), timelineMetric.getAppId(), timelineMetric.getInstanceId(), timelineMetric.getUnits(), timelineMetric.getType(), Long.valueOf(timelineMetric.getStartTime()), this.supportAggregates(timelineMetric), isWhitelisted);
        if (!this.isTransientMetric(timelineMetric.getMetricName(), timelineMetric.getAppId())) {
            byte[] uuid = this.getUuid(timelineMetric.getMetricName(), timelineMetric.getAppId(), timelineMetric.getInstanceId(), null, true);
            timelineMetricMetadata.setUuid(uuid);
        }
        return timelineMetricMetadata;
    }

    boolean isDistributedModeEnabled() {
        String mode = this.metricsConf.get("timeline.metrics.service.operation.mode");
        return mode != null && mode.equals("distributed");
    }

    Map<TimelineMetricMetadataKey, TimelineMetricMetadata> getMetadataFromStoreV1() throws SQLException {
        return this.hBaseAccessor.getTimelineMetricMetadataV1();
    }

    Map<TimelineMetricMetadataKey, TimelineMetricMetadata> getMetadataFromStore() throws SQLException {
        return this.hBaseAccessor.getTimelineMetricMetadata();
    }

    Map<String, TimelineMetricHostMetadata> getHostedAppsFromStore() throws SQLException {
        return this.hBaseAccessor.getHostedAppsMetadata();
    }

    Map<String, Set<String>> getHostedInstancesFromStore() throws SQLException {
        return this.hBaseAccessor.getInstanceHostsMetdata();
    }

    private boolean supportAggregates(TimelineMetric metric) {
        return MapUtils.isEmpty((Map)metric.getMetadata()) || !String.valueOf(true).equals(metric.getMetadata().get("skipAggregation"));
    }

    private void loadUuidMapsOnInit() {
        for (TimelineMetricMetadataKey key : this.METADATA_CACHE.keySet()) {
            TimelineMetricMetadata timelineMetricMetadata = this.METADATA_CACHE.get(key);
            if (timelineMetricMetadata == null || timelineMetricMetadata.getUuid() == null) continue;
            this.uuidKeyMap.put(new TimelineMetricUuid(timelineMetricMetadata.getUuid()), key);
        }
        for (String host : this.HOSTED_APPS_MAP.keySet()) {
            TimelineMetricHostMetadata timelineMetricHostMetadata = this.HOSTED_APPS_MAP.get(host);
            if (timelineMetricHostMetadata == null || timelineMetricHostMetadata.getUuid() == null) continue;
            this.uuidHostMap.put(new TimelineMetricUuid(timelineMetricHostMetadata.getUuid()), host);
        }
    }

    public void addMetricsInUuidMap(byte[] uuid, TimelineMetricMetadataKey metadataKey) {
        this.uuidKeyMap.put(new TimelineMetricUuid(uuid), metadataKey);
    }

    public void addHostInUuidHostMap(String hostName, TimelineMetricHostMetadata tmHostMetadata) {
        TimelineMetricUuid timelineMetricUuid = new TimelineMetricUuid(tmHostMetadata.getUuid());
        this.uuidHostMap.put(timelineMetricUuid, hostName);
    }

    private MetricUuidGenStrategy getUuidStrategy(Configuration configuration) {
        return new Murmur3HashUuidGenStrategy();
    }

    private byte[] getUuidForHostname(String hostname, boolean createIfNotPresent) {
        byte[] uuid;
        TimelineMetricHostMetadata timelineMetricHostMetadata = this.HOSTED_APPS_MAP.get(hostname);
        if (timelineMetricHostMetadata != null && (uuid = timelineMetricHostMetadata.getUuid()) != null) {
            return uuid;
        }
        if (!createIfNotPresent) {
            LOG.debug((Object)("UUID not found for " + hostname + ", createIfNotPresent is false"));
            return null;
        }
        uuid = this.uuidGenStrategy.computeUuid(hostname, HOSTNAME_UUID_LENGTH);
        TimelineMetricUuid timelineMetricUuid = new TimelineMetricUuid(uuid);
        if (this.uuidHostMap.containsKey(timelineMetricUuid) && !hostname.equals(this.uuidHostMap.get(timelineMetricUuid))) {
            LOG.error((Object)("Duplicate key computed for " + hostname + ", Collides with  " + this.uuidHostMap.get(timelineMetricUuid)));
            return null;
        }
        timelineMetricHostMetadata = this.HOSTED_APPS_MAP.computeIfAbsent(hostname, k -> new TimelineMetricHostMetadata());
        if (timelineMetricHostMetadata.getUuid() == null) {
            timelineMetricHostMetadata.setUuid(uuid);
        }
        if (!this.uuidHostMap.containsKey(timelineMetricUuid)) {
            this.uuidHostMap.put(timelineMetricUuid, hostname);
        }
        return uuid;
    }

    public byte[] getUuid(TimelineClusterMetric timelineClusterMetric, boolean createIfNotPresent) {
        byte[] uuid;
        TimelineMetricMetadataKey key = new TimelineMetricMetadataKey(timelineClusterMetric.getMetricName(), timelineClusterMetric.getAppId(), timelineClusterMetric.getInstanceId());
        TimelineMetricMetadata timelineMetricMetadata = this.METADATA_CACHE.get(key);
        if (timelineMetricMetadata != null && (uuid = timelineMetricMetadata.getUuid()) != null) {
            return uuid;
        }
        if (!createIfNotPresent) {
            LOG.debug((Object)("UUID not found for " + key + ", createIfNotPresent is false"));
            return null;
        }
        byte[] uuidBytes = this.uuidGenStrategy.computeUuid(timelineClusterMetric, 16);
        TimelineMetricUuid uuid2 = new TimelineMetricUuid(uuidBytes);
        if (this.uuidKeyMap.containsKey(uuid2) && !this.uuidKeyMap.get(uuid2).equals(key)) {
            TimelineMetricMetadataKey collidingKey = this.uuidKeyMap.get(uuid2);
            LOG.error((Object)("Duplicate key " + uuid2 + " computed for " + timelineClusterMetric + ", Collides with  " + collidingKey));
            return null;
        }
        timelineMetricMetadata = this.METADATA_CACHE.get(key);
        if (timelineMetricMetadata == null) {
            timelineMetricMetadata = new TimelineMetricMetadata();
            timelineMetricMetadata.setMetricName(timelineClusterMetric.getMetricName());
            timelineMetricMetadata.setAppId(timelineClusterMetric.getAppId());
            timelineMetricMetadata.setInstanceId(timelineClusterMetric.getInstanceId());
            this.METADATA_CACHE.put(key, timelineMetricMetadata);
        }
        if (timelineMetricMetadata.getUuid() == null) {
            timelineMetricMetadata.setUuid(uuid2.uuid);
        }
        timelineMetricMetadata.setIsPersisted(false);
        if (!this.uuidKeyMap.containsKey(uuid2)) {
            this.uuidKeyMap.put(uuid2, key);
        }
        return uuid2.uuid;
    }

    public byte[] getUuid(TimelineMetric timelineMetric, boolean createIfNotPresent) {
        byte[] metricUuid = this.getUuid(new TimelineClusterMetric(timelineMetric.getMetricName(), timelineMetric.getAppId(), timelineMetric.getInstanceId(), -1L), createIfNotPresent);
        byte[] hostUuid = this.getUuidForHostname(timelineMetric.getHostName(), createIfNotPresent);
        if (hostUuid != null) {
            this.putIfModifiedHostedAppsMetadata(timelineMetric.getHostName(), timelineMetric.getAppId());
        }
        if (metricUuid == null || hostUuid == null) {
            return null;
        }
        return ArrayUtils.addAll((byte[])metricUuid, (byte[])hostUuid);
    }

    public byte[] getUuid(String metricName, String appId, String instanceId, String hostname, boolean createIfNotPresent) {
        byte[] metricUuid = this.getUuid(new TimelineClusterMetric(metricName, appId, instanceId, -1L), createIfNotPresent);
        if (StringUtils.isNotEmpty((String)hostname)) {
            byte[] hostUuid = this.getUuidForHostname(hostname, createIfNotPresent);
            if (hostUuid == null || metricUuid == null) {
                return null;
            }
            return ArrayUtils.addAll((byte[])metricUuid, (byte[])hostUuid);
        }
        return metricUuid;
    }

    public String getMetricNameFromUuid(byte[] uuid) {
        TimelineMetricMetadataKey key;
        byte[] metricUuid = uuid;
        if (uuid.length == 16 + HOSTNAME_UUID_LENGTH) {
            metricUuid = ArrayUtils.subarray((byte[])uuid, (int)0, (int)16);
        }
        return (key = this.uuidKeyMap.get(new TimelineMetricUuid(metricUuid))) != null ? key.getMetricName() : null;
    }

    public TimelineMetric getMetricFromUuid(byte[] uuid) {
        if (uuid == null) {
            return null;
        }
        if (uuid.length == 16) {
            TimelineMetricMetadataKey key = this.uuidKeyMap.get(new TimelineMetricUuid(uuid));
            return key != null ? new TimelineMetric(key.metricName, null, key.appId, key.instanceId) : null;
        }
        byte[] metricUuid = ArrayUtils.subarray((byte[])uuid, (int)0, (int)16);
        TimelineMetricMetadataKey key = this.uuidKeyMap.get(new TimelineMetricUuid(metricUuid));
        if (key == null) {
            LOG.error((Object)("TimelineMetricMetadataKey is null for : " + Arrays.toString(uuid)));
            return null;
        }
        TimelineMetric timelineMetric = new TimelineMetric();
        timelineMetric.setMetricName(key.metricName);
        timelineMetric.setAppId(key.appId);
        timelineMetric.setInstanceId(key.instanceId);
        byte[] hostUuid = ArrayUtils.subarray((byte[])uuid, (int)16, (int)(HOSTNAME_UUID_LENGTH + 16));
        String hostname = this.uuidHostMap.get(new TimelineMetricUuid(hostUuid));
        if (hostname == null) {
            return null;
        }
        timelineMetric.setHostName(hostname);
        return timelineMetric;
    }

    public List<byte[]> getUuidsForGetMetricQuery(Collection<String> metricNames, List<String> hostnames, String appId, String instanceId) {
        return this.getUuidsForGetMetricQuery(metricNames, hostnames, appId, instanceId, Collections.EMPTY_LIST);
    }

    public List<byte[]> getUuidsForGetMetricQuery(Collection<String> metricNames, List<String> hostnames, String appId, String instanceId, List<String> transientMetricNames) {
        ArrayList<byte[]> uuids = new ArrayList<byte[]>();
        boolean metricNameHasWildcard = false;
        for (String string : metricNames) {
            if (!this.hasWildCard(string)) continue;
            metricNameHasWildcard = true;
            break;
        }
        boolean hostNameHasWildcard = false;
        if (CollectionUtils.isNotEmpty(hostnames)) {
            for (String hostname : hostnames) {
                if (!this.hasWildCard(hostname)) continue;
                hostNameHasWildcard = true;
                break;
            }
        }
        if (this.hasWildCard(instanceId) || this.hasWildCard(appId) || hostNameHasWildcard || metricNameHasWildcard) {
            try {
                List<TimelineMetricMetadata> list = this.hBaseAccessor.scanMetricMetadataForWildCardRequest(metricNames, appId, instanceId);
                List<byte[]> hostUuidsFromStore = this.hBaseAccessor.scanHostMetadataForWildCardRequest(hostnames);
                for (TimelineMetricMetadata matchedEntry : list) {
                    if (matchedEntry.getUuid() != null) {
                        if (CollectionUtils.isNotEmpty(hostnames)) {
                            for (byte[] hostUuidEntry : hostUuidsFromStore) {
                                uuids.add(ArrayUtils.addAll((byte[])matchedEntry.getUuid(), (byte[])hostUuidEntry));
                            }
                            continue;
                        }
                        uuids.add(matchedEntry.getUuid());
                        continue;
                    }
                    if (!this.isTransientMetric(matchedEntry.getMetricName(), matchedEntry.getAppId())) continue;
                    transientMetricNames.add(matchedEntry.getMetricName());
                }
                return uuids;
            }
            catch (SQLException sQLException) {
                LOG.error((Object)("Unable to query metadata table to check satisfying metric keys for wildcard request : " + sQLException));
                return uuids;
            }
        }
        if (CollectionUtils.isNotEmpty(hostnames)) {
            if (CollectionUtils.isNotEmpty(metricNames)) {
                for (String metricName : metricNames) {
                    if (this.isTransientMetric(metricName, appId)) {
                        transientMetricNames.add(metricName);
                        continue;
                    }
                    TimelineMetric metric = new TimelineMetric();
                    metric.setMetricName(metricName);
                    metric.setAppId(appId);
                    metric.setInstanceId(instanceId);
                    for (String hostname : hostnames) {
                        metric.setHostName(hostname);
                        byte[] uuid = this.getUuid(metric, false);
                        if (uuid == null) continue;
                        uuids.add(uuid);
                    }
                }
            } else {
                for (String hostname : hostnames) {
                    byte[] uuid = this.getUuidForHostname(hostname, false);
                    if (uuid == null) continue;
                    uuids.add(uuid);
                }
            }
        } else {
            for (String metricName : metricNames) {
                if (this.isTransientMetric(metricName, appId)) {
                    transientMetricNames.add(metricName);
                    continue;
                }
                TimelineClusterMetric metric = new TimelineClusterMetric(metricName, appId, instanceId, -1L);
                byte[] uuid = this.getUuid(metric, false);
                if (uuid == null) continue;
                uuids.add(uuid);
            }
        }
        return uuids;
    }

    public List<String> getNotLikeHostnames(List<String> hostnames) {
        ArrayList<String> result = new ArrayList<String>();
        Set<String> sanitizedHostNames = this.getSanitizedHostnames(hostnames);
        for (String hostname : this.HOSTED_APPS_MAP.keySet()) {
            if (sanitizedHostNames.contains(hostname)) continue;
            result.add(hostname);
        }
        return result;
    }

    private Set<String> getSanitizedHostnames(List<String> hostnamedWithOrWithoutWildcard) {
        HashSet<String> sanitizedHostNames = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(hostnamedWithOrWithoutWildcard)) {
            for (String hostname : hostnamedWithOrWithoutWildcard) {
                if (hostname.contains("%")) {
                    String hostRegEx = hostname.replace("%", ".*");
                    for (String host : this.HOSTED_APPS_MAP.keySet()) {
                        if (!host.matches(hostRegEx)) continue;
                        sanitizedHostNames.add(host);
                    }
                    continue;
                }
                sanitizedHostNames.add(hostname);
            }
        }
        return sanitizedHostNames;
    }

    public Map<String, List<TimelineMetricMetadata>> getTimelineMetricMetadataByAppId(String appId, String metricPattern, boolean includeBlacklistedMetrics) throws SQLException, IOException {
        Map<TimelineMetricMetadataKey, TimelineMetricMetadata> metadata = this.getMetadataCache();
        boolean filterByAppId = StringUtils.isNotEmpty((String)appId);
        boolean filterByMetricName = StringUtils.isNotEmpty((String)metricPattern);
        Pattern metricFilterPattern = null;
        if (filterByMetricName) {
            metricFilterPattern = Pattern.compile(metricPattern);
        }
        HashMap<String, List<TimelineMetricMetadata>> metadataByAppId = new HashMap<String, List<TimelineMetricMetadata>>();
        for (TimelineMetricMetadata metricMetadata : metadata.values()) {
            Matcher m;
            if (!includeBlacklistedMetrics && !metricMetadata.isWhitelisted()) continue;
            String currentAppId = metricMetadata.getAppId();
            if (filterByAppId && !currentAppId.equals(appId) || filterByMetricName && !(m = metricFilterPattern.matcher(metricMetadata.getMetricName())).find()) continue;
            ArrayList<TimelineMetricMetadata> metadataList = (ArrayList<TimelineMetricMetadata>)metadataByAppId.get(currentAppId);
            if (metadataList == null) {
                metadataList = new ArrayList<TimelineMetricMetadata>();
                metadataByAppId.put(currentAppId, metadataList);
            }
            metadataList.add(metricMetadata);
        }
        return metadataByAppId;
    }

    public Map<String, String> getMetadataSummary() throws IOException, SQLException {
        HashMap<String, String> summary = new HashMap<String, String>();
        summary.put("Number of Hosts", String.valueOf(this.HOSTED_APPS_MAP.size()));
        Map<String, List<TimelineMetricMetadata>> metadataMap = this.getTimelineMetricMetadataByAppId("", "", true);
        if (metadataMap != null) {
            for (String appId : metadataMap.keySet()) {
                summary.put(appId, String.valueOf(metadataMap.get(appId).size()));
            }
        }
        return summary;
    }

    public boolean isTransientMetric(String metricName, String appId) {
        for (String pattern : this.transientMetricPatterns) {
            if (!metricName.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public void forceMetricsMetadataSync() {
        if (this.metricMetadataSync == null) {
            this.metricMetadataSync = new TimelineMetricMetadataSync(this);
        }
        this.metricMetadataSync.run();
    }

    public void updateMetadataCacheUsingV1Tables() throws SQLException {
        Map<TimelineMetricMetadataKey, TimelineMetricMetadata> metadataV1Map = this.getMetadataFromStoreV1();
        for (TimelineMetricMetadataKey key : this.METADATA_CACHE.keySet()) {
            TimelineMetricMetadata cacheValue = this.METADATA_CACHE.get(key);
            TimelineMetricMetadata oldValue = metadataV1Map.get(key);
            if (oldValue == null) continue;
            if (!cacheValue.isPersisted()) {
                LOG.info((Object)String.format("Updating properties for %s", key));
                cacheValue.setSeriesStartTime(oldValue.getSeriesStartTime());
                cacheValue.setSupportsAggregates(oldValue.isSupportsAggregates());
                cacheValue.setType(oldValue.getType());
                cacheValue.setIsWhitelisted(oldValue.isWhitelisted());
                continue;
            }
            if (oldValue.getSeriesStartTime() >= cacheValue.getSeriesStartTime() || cacheValue.getSeriesStartTime() == 0L || !cacheValue.isWhitelisted()) continue;
            LOG.info((Object)String.format("Updating startTime for %s", key));
            cacheValue.setSeriesStartTime(oldValue.getSeriesStartTime());
            cacheValue.setIsPersisted(false);
        }
    }

    private boolean hasWildCard(String key) {
        return StringUtils.isNotEmpty((String)key) && key.contains("%");
    }
}

